/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.commands;

import com.archimatetool.editor.model.commands.Messages;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IFolder;
import org.eclipse.gef.commands.Command;

public class DeleteArchimateRelationshipCommand
extends Command {
    private IArchimateRelationship fRelationship;
    private int fIndex;
    private IFolder fFolder;

    public DeleteArchimateRelationshipCommand(IArchimateRelationship relationship) {
        this.fFolder = (IFolder)relationship.eContainer();
        this.fRelationship = relationship;
        this.setLabel(Messages.DeleteArchimateRelationshipCommand_0);
    }

    public void execute() {
        this.fIndex = this.fFolder.getElements().indexOf((Object)this.fRelationship);
        if (this.fIndex != -1) {
            this.fFolder.getElements().remove((Object)this.fRelationship);
        }
        this.fRelationship.disconnect();
    }

    public void undo() {
        if (this.fIndex != -1) {
            this.fFolder.getElements().add(this.fIndex, (Object)this.fRelationship);
        }
        this.fRelationship.reconnect();
    }

    public void dispose() {
        this.fRelationship = null;
        this.fFolder = null;
    }
}

