/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.commands;

import com.archimatetool.editor.model.commands.Messages;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import org.eclipse.gef.commands.Command;

public class DeleteDiagramModelCommand
extends Command {
    private IDiagramModel fDiagramModel;
    private int fIndex;
    private IFolder fFolder;

    public DeleteDiagramModelCommand(IDiagramModel model) {
        this.fFolder = (IFolder)model.eContainer();
        this.fDiagramModel = model;
        this.setLabel(Messages.DeleteDiagramModelCommand_0);
    }

    public void execute() {
        this.fIndex = this.fFolder.getElements().indexOf((Object)this.fDiagramModel);
        if (this.fIndex != -1) {
            EditorManager.closeDiagramEditor(this.fDiagramModel);
            this.fFolder.getElements().remove((Object)this.fDiagramModel);
        }
    }

    public void undo() {
        if (this.fIndex != -1) {
            this.fFolder.getElements().add(this.fIndex, (Object)this.fDiagramModel);
        }
    }

    public void dispose() {
        this.fDiagramModel = null;
        this.fFolder = null;
    }
}

