/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.commands;

import com.archimatetool.editor.model.commands.Messages;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import org.eclipse.gef.commands.Command;

public class SetProfileCommand
extends Command {
    private IProfiles owner;
    private IProfile oldProfile;
    private IProfile newProfile;

    public SetProfileCommand(IProfiles owner, IProfile profile) {
        this.owner = owner;
        this.newProfile = profile;
        this.setLabel(Messages.SetProfileCommand_0);
    }

    public void execute() {
        if (this.owner.getProfiles().isEmpty()) {
            this.owner.getProfiles().add((Object)this.newProfile);
        } else {
            this.oldProfile = this.owner.getPrimaryProfile();
            if (this.newProfile == null) {
                this.owner.getProfiles().remove((Object)this.oldProfile);
            } else {
                this.owner.getProfiles().set(0, (Object)this.newProfile);
            }
        }
    }

    public void undo() {
        if (this.oldProfile != null) {
            if (this.owner.getProfiles().isEmpty()) {
                this.owner.getProfiles().add((Object)this.oldProfile);
            } else {
                this.owner.getProfiles().set(0, (Object)this.oldProfile);
            }
        } else {
            this.owner.getProfiles().remove((Object)this.newProfile);
        }
    }

    public boolean canExecute() {
        if (this.newProfile == null) {
            return !this.owner.getProfiles().isEmpty();
        }
        if (!this.owner.eClass().getName().equals(this.newProfile.getConceptType())) {
            return false;
        }
        return this.owner.getPrimaryProfile() != this.newProfile;
    }

    public void dispose() {
        this.owner = null;
        this.oldProfile = null;
        this.newProfile = null;
    }
}

