/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.compatibility.handlers;

import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.ICompatibilityHandler;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateObject;
import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class Archimate32Handler
implements ICompatibilityHandler {
    @Override
    public void fixCompatibility(Resource resource) throws CompatibilityHandlerException {
        IArchimateModel model = (IArchimateModel)resource.getContents().get(0);
        if (this.isVersion(model)) {
            this.setDefaultFigures(model);
        }
    }

    boolean isVersion(IArchimateModel model) {
        String version = model.getVersion();
        return version != null && StringUtils.compareVersionNumbers(version, "5.0.0") < 0;
    }

    void setDefaultFigures(IArchimateModel model) {
        HashSet<EClass> set = new HashSet<EClass>();
        set.add(IArchimatePackage.eINSTANCE.getGrouping());
        set.add(IArchimatePackage.eINSTANCE.getBusinessObject());
        set.add(IArchimatePackage.eINSTANCE.getContract());
        set.add(IArchimatePackage.eINSTANCE.getRepresentation());
        set.add(IArchimatePackage.eINSTANCE.getProduct());
        set.add(IArchimatePackage.eINSTANCE.getDataObject());
        set.add(IArchimatePackage.eINSTANCE.getMeaning());
        set.add(IArchimatePackage.eINSTANCE.getValue());
        set.add(IArchimatePackage.eINSTANCE.getDeliverable());
        set.add(IArchimatePackage.eINSTANCE.getApplicationComponent());
        set.add(IArchimatePackage.eINSTANCE.getArtifact());
        set.add(IArchimatePackage.eINSTANCE.getDevice());
        set.add(IArchimatePackage.eINSTANCE.getNode());
        TreeIterator iter = model.getFolder(FolderType.DIAGRAMS).eAllContents();
        while (iter.hasNext()) {
            IDiagramModelArchimateObject dmo;
            IArchimateElement element;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IDiagramModelArchimateObject) || !set.contains((element = (dmo = (IDiagramModelArchimateObject)eObject).getArchimateElement()).eClass())) continue;
            dmo.setType(dmo.getType() ^ 1);
        }
    }
}

