/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.compatibility.handlers;

import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.ICompatibilityHandler;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelImage;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IJunction;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class FixDefaultSizesHandler
implements ICompatibilityHandler {
    @Override
    public void fixCompatibility(Resource resource) throws CompatibilityHandlerException {
        IArchimateModel model = (IArchimateModel)resource.getContents().get(0);
        if (this.isVersion(model)) {
            this.fixMissingWidthAndHeight(model);
        }
    }

    boolean isVersion(IArchimateModel model) {
        String version = model.getVersion();
        return version != null && StringUtils.compareVersionNumbers(version, "3.0.0") < 0;
    }

    void fixMissingWidthAndHeight(IArchimateModel model) {
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof IDiagramModelImage || !(eObject instanceof IDiagramModelObject)) continue;
            IDiagramModelObject dmo = (IDiagramModelObject)eObject;
            Dimension d = this.getNewSize(dmo);
            IBounds bounds = dmo.getBounds();
            bounds.setWidth(d.width);
            bounds.setHeight(d.height);
        }
    }

    Dimension getNewSize(IDiagramModelObject dmo) {
        IBounds bounds = dmo.getBounds().getCopy();
        if (bounds.getWidth() != -1 && bounds.getHeight() != -1) {
            return new Dimension(bounds.getWidth(), bounds.getHeight());
        }
        if (dmo instanceof IDiagramModelContainer && ((IDiagramModelContainer)dmo).getChildren().size() > 0) {
            IDiagramModelContainer container = (IDiagramModelContainer)dmo;
            Dimension childrenSize = new Dimension();
            for (IDiagramModelObject child : container.getChildren()) {
                IBounds childbounds = child.getBounds().getCopy();
                Dimension size = this.getNewSize(child);
                childrenSize.width = Math.max(childbounds.getX() + size.width() + 10, childrenSize.width);
                childrenSize.height = Math.max(childbounds.getY() + size.height() + 10, childrenSize.height);
            }
            Dimension defaultSize = this.getDefaultSize(dmo);
            Dimension newSize = childrenSize.union(defaultSize);
            return newSize;
        }
        return this.getDefaultSize(dmo);
    }

    Dimension getDefaultSize(IDiagramModelObject dmo) {
        IBounds bounds = dmo.getBounds();
        if (bounds.getWidth() != -1 && bounds.getHeight() != -1) {
            return new Dimension(bounds.getWidth(), bounds.getHeight());
        }
        if (dmo instanceof IDiagramModelArchimateObject && !(((IDiagramModelArchimateObject)dmo).getArchimateElement() instanceof IJunction)) {
            return IGraphicalObjectUIProvider.defaultSize();
        }
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider((EObject)dmo);
        return provider != null ? provider.getDefaultSize() : IGraphicalObjectUIProvider.defaultSize();
    }
}

