/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.compatibility.handlers;

import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.ICompatibilityHandler;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class OutlineOpacityHandler
implements ICompatibilityHandler {
    @Override
    public void fixCompatibility(Resource resource) throws CompatibilityHandlerException {
        IArchimateModel model = (IArchimateModel)resource.getContents().get(0);
        if (this.isVersion(model)) {
            this.setDefaultOutlineOpacity(model);
        }
    }

    boolean isVersion(IArchimateModel model) {
        String version = model.getVersion();
        return version != null && (StringUtils.compareVersionNumbers(version, "4.0.1") == 0 || StringUtils.compareVersionNumbers(version, "4.4.0") == 0);
    }

    void setDefaultOutlineOpacity(IArchimateModel model) {
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IDiagramModelObject)) continue;
            IDiagramModelObject dmo = (IDiagramModelObject)eObject;
            dmo.setLineAlpha(dmo.getAlpha());
        }
    }
}

