/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.impl;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.impl.ByteArrayStorage;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModelImageProvider;
import com.archimatetool.model.util.ArchimateResourceFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ArchiveManager
implements IArchiveManager {
    private ByteArrayStorage byteArrayStorage = new ByteArrayStorage();
    private IArchimateModel fModel;
    private boolean fImagesLoaded = false;

    public ArchiveManager(IArchimateModel model) {
        this.fModel = model;
    }

    @Override
    public boolean useArchiveFormat() {
        if (this.fModel.getFile() == null) {
            return true;
        }
        File gitFolder = new File(this.fModel.getFile().getParentFile(), ".git");
        return !gitFolder.exists() || !gitFolder.isDirectory();
    }

    @Override
    public String addImageFromFile(File file) throws IOException {
        if (file == null || !file.exists() || !file.canRead()) {
            throw new FileNotFoundException("Cannot find file");
        }
        byte[] bytes = this.byteArrayStorage.getBytesFromFile(file);
        if (bytes == null) {
            throw new IOException("Could not get bytes from file");
        }
        String entryName = this.createArchiveImagePathname(file);
        return this.addByteContentEntry(entryName, bytes);
    }

    private void testImageBytesValid(byte[] bytes) throws IOException {
        try {
            new ImageData((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (Throwable ex) {
            throw new IOException("Not a supported image file", ex);
        }
    }

    @Override
    public Image createImage(String imagePath) throws Exception {
        if (this.byteArrayStorage.hasEntry(imagePath)) {
            return new Image((Device)Display.getCurrent(), this.byteArrayStorage.getInputStream(imagePath));
        }
        return null;
    }

    @Override
    public ImageData createImageData(String imagePath) {
        if (this.byteArrayStorage.hasEntry(imagePath)) {
            return new ImageData(this.byteArrayStorage.getInputStream(imagePath));
        }
        return null;
    }

    @Override
    public Set<String> getImagePaths() {
        HashSet<String> set = new HashSet<String>();
        TreeIterator iter = this.fModel.eAllContents();
        while (iter.hasNext()) {
            String imagePath;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IDiagramModelImageProvider) || (imagePath = ((IDiagramModelImageProvider)element).getImagePath()) == null) continue;
            set.add(imagePath);
        }
        return set;
    }

    @Override
    public Set<String> getLoadedImagePaths() {
        return this.byteArrayStorage.getEntryNames();
    }

    @Override
    public void loadImages() throws IOException {
        if (!this.fImagesLoaded && this.fModel.getFile() != null) {
            this.fImagesLoaded = IArchiveManager.FACTORY.isArchiveFile(this.fModel.getFile()) ? this.loadImagesFromModelFile(this.fModel.getFile()) : this.loadImagesFromModelFolder(this.fModel.getFile());
        }
    }

    @Override
    public boolean loadImagesFromModelFile(File file) throws IOException {
        if (file == null || !file.exists() || !IArchiveManager.FACTORY.isArchiveFile(file)) {
            return false;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enm = zipFile.entries();
            while (enm.hasMoreElements()) {
                ZipEntry zipEntry = enm.nextElement();
                String entryName = zipEntry.getName();
                if (!entryName.startsWith("images/") || this.byteArrayStorage.hasEntry(entryName)) continue;
                InputStream in = zipFile.getInputStream(zipEntry);
                this.byteArrayStorage.addStreamEntry(entryName, in);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    private boolean loadImagesFromModelFolder(File modelFile) throws IOException {
        File imagesFolder = this.getImagesFolder(modelFile);
        if (FileUtils.isFolderEmpty(imagesFolder)) {
            return false;
        }
        Set<String> paths = this.getImagePaths();
        if (paths.isEmpty()) {
            return false;
        }
        File[] fileArray = imagesFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File imageFile = fileArray[n2];
            String entryName = "images/" + imageFile.getName();
            if (paths.contains(entryName) && !this.byteArrayStorage.hasEntry(entryName)) {
                byte[] bytes = Files.readAllBytes(imageFile.toPath());
                try {
                    this.testImageBytesValid(bytes);
                    this.byteArrayStorage.addByteContentEntry(entryName, bytes);
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean hasImages() {
        Set<String> loadedImagePaths = this.getLoadedImagePaths();
        if (loadedImagePaths.isEmpty()) {
            return false;
        }
        TreeIterator iter = this.fModel.eAllContents();
        while (iter.hasNext()) {
            String imagePath;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IDiagramModelImageProvider) || (imagePath = ((IDiagramModelImageProvider)element).getImagePath()) == null || !loadedImagePaths.contains(imagePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] getBytesFromEntry(String entryName) {
        return this.byteArrayStorage.getEntry(entryName);
    }

    @Override
    public String addByteContentEntry(String imagePath, byte[] bytes) throws IOException {
        String entryName = this.byteArrayStorage.getKey(bytes);
        if (entryName == null) {
            this.testImageBytesValid(bytes);
            entryName = imagePath;
            this.byteArrayStorage.addByteContentEntry(imagePath, bytes);
        }
        return entryName;
    }

    @Override
    public String copyImageBytes(IArchiveManager archiveManager, String imagePath) throws IOException {
        byte[] bytes = archiveManager.getBytesFromEntry(imagePath);
        if (bytes != null) {
            imagePath = this.addByteContentEntry(imagePath, bytes);
        }
        return imagePath;
    }

    @Override
    public void saveModel() throws IOException {
        File file = this.fModel.getFile();
        if (file == null) {
            return;
        }
        if (!this.useArchiveFormat()) {
            FileUtils.deleteFolder(this.getImagesFolder(file));
        }
        if (this.hasImages()) {
            if (this.useArchiveFormat()) {
                this.saveModelToArchiveFile(file);
            } else {
                this.saveModelWithImagesFolder(file);
            }
        } else {
            this.saveResource(file);
        }
    }

    @Override
    public IArchiveManager clone(IArchimateModel model) {
        ArchiveManager archiveManager = new ArchiveManager(model);
        for (Map.Entry<String, byte[]> entry : this.byteArrayStorage.getEntrySet()) {
            archiveManager.byteArrayStorage.addByteContentEntry(entry.getKey(), entry.getValue());
        }
        return archiveManager;
    }

    private void saveModelToArchiveFile(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            this.saveModelWithArchiveFile(zOut);
            this.saveImages(zOut);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void saveModelWithImagesFolder(File modelFile) throws IOException {
        this.saveResource(modelFile);
        this.getImagesFolder(modelFile).mkdirs();
        for (String imagePath : this.getImagePaths()) {
            byte[] bytes = this.byteArrayStorage.getEntry(imagePath);
            if (bytes == null) continue;
            File imageFile = new File(modelFile.getParentFile(), imagePath);
            Files.write(imageFile.toPath(), bytes, StandardOpenOption.CREATE);
        }
    }

    private void saveModelWithArchiveFile(ZipOutputStream zOut) throws IOException {
        File tmpFile = File.createTempFile("archi-", null);
        tmpFile.deleteOnExit();
        this.saveResource(tmpFile);
        ZipEntry zipEntry = new ZipEntry("model.xml");
        zOut.putNextEntry(zipEntry);
        byte[] buf = new byte[8192];
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(tmpFile), 8192);){
                int bytesRead;
                while ((bytesRead = in.read(buf)) != -1) {
                    zOut.write(buf, 0, bytesRead);
                }
                zOut.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    private void saveResource(File file) throws IOException {
        Resource resource = this.fModel.eResource();
        if (resource == null) {
            resource = ArchimateResourceFactory.createNewResource((File)file);
            resource.getContents().add((Object)this.fModel);
        } else {
            resource.setURI(URI.createFileURI((String)file.getAbsolutePath()));
        }
        try {
            resource.save(null);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void saveImages(ZipOutputStream zOut) throws IOException {
        for (String imagePath : this.getImagePaths()) {
            byte[] bytes = this.byteArrayStorage.getEntry(imagePath);
            if (bytes == null) continue;
            ZipEntry zipEntry = new ZipEntry(imagePath);
            zOut.putNextEntry(zipEntry);
            zOut.write(bytes);
            zOut.closeEntry();
        }
    }

    private String createArchiveImagePathname(File file) {
        String ext = FileUtils.getFileExtension(file);
        String unique = EcoreUtil.generateUUID();
        String path = "images/" + unique;
        if (ext.length() != 0) {
            path = path + ext;
        }
        return path;
    }

    private File getImagesFolder(File modelFile) {
        return modelFile != null ? new File(modelFile.getParentFile(), "images") : null;
    }

    @Override
    public void dispose() {
        this.byteArrayStorage.dispose();
        this.byteArrayStorage = null;
        this.fModel = null;
    }
}

