/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.impl;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.util.AnimationUtil;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.model.ModelChecker;
import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.IncompatibleModelException;
import com.archimatetool.editor.model.compatibility.ModelCompatibility;
import com.archimatetool.editor.model.impl.Messages;
import com.archimatetool.editor.ui.dialog.ErrorMessageDialog;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.jdom.JDOMUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.util.IModelContentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class EditorModelManager
implements IEditorModelManager {
    private PropertyChangeSupport fListeners = new PropertyChangeSupport(this);
    private IModelContentListener fEContentListener = this::notifyChanged;
    private List<IArchimateModel> fModels;
    private File backingFile = new File(ArchiPlugin.getInstance().getWorkspaceFolder(), "models.xml");
    private IWorkbenchListener workBenchListener = new IWorkbenchListener(){

        public void postShutdown(IWorkbench workbench) {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            if (EditorModelManager.this.fModels != null) {
                for (IArchimateModel model : EditorModelManager.this.fModels) {
                    if (!EditorModelManager.this.isModelDirty(model)) continue;
                    try {
                        boolean result = EditorModelManager.this.askSaveModel(model);
                        if (result) continue;
                        return false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorModelManager_14, (String)(NLS.bind((String)Messages.EditorModelManager_15, (Object)model.getFile()) + "\n" + ex.getMessage()));
                        return false;
                    }
                }
            }
            return true;
        }
    };

    public EditorModelManager() {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().addWorkbenchListener(this.workBenchListener);
        }
    }

    @Override
    public List<IArchimateModel> getModels() {
        if (this.fModels == null) {
            this.fModels = new ArrayList<IArchimateModel>();
            try {
                this.loadState();
            }
            catch (Exception ex) {
                Logger.logError("Error loading state", ex);
                ex.printStackTrace();
            }
        }
        return this.fModels;
    }

    @Override
    public IArchimateModel createNewModel() {
        IArchimateModel model = IArchimateFactory.eINSTANCE.createArchimateModel();
        model.setName(Messages.EditorModelManager_0);
        model.setDefaults();
        IArchimateDiagramModel diagramModel = IArchimateFactory.eINSTANCE.createArchimateDiagramModel();
        diagramModel.setName(Messages.EditorModelManager_1);
        model.getFolder(FolderType.DIAGRAMS).getElements().add((Object)diagramModel);
        this.registerModel(model);
        return model;
    }

    @Override
    public void registerModel(IArchimateModel model) {
        if (model == null) {
            return;
        }
        if (!this.getModels().contains(model)) {
            this.getModels().add(model);
        }
        this.createNewCommandStack(model);
        this.createNewArchiveManager(model);
        this.firePropertyChange(this, "IEditorModelManager.model.created", null, model);
        model.addModelContentListener(this.fEContentListener);
    }

    @Override
    public IArchimateModel openModel(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        IArchimateModel model = this.locateLoadedModel(file);
        if (model != null) {
            return model;
        }
        model = this.loadModel(file);
        if (model != null) {
            if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("openDiagramsOnLoad")) {
                int max = 0;
                for (IDiagramModel dm : model.getDiagramModels()) {
                    if (max++ >= 30) continue;
                    EditorManager.openDiagramEditor(dm);
                }
            }
            this.firePropertyChange(this, "IEditorModelManager.model.opened", null, model);
        }
        return model;
    }

    @Override
    public void openModel(IArchimateModel model) {
        if (model == null || this.getModels().contains(model)) {
            return;
        }
        this.getModels().add(model);
        this.createNewCommandStack(model);
        this.createNewArchiveManager(model);
        model.addModelContentListener(this.fEContentListener);
        this.firePropertyChange(this, "IEditorModelManager.model.opened", null, model);
    }

    @Override
    public IArchimateModel loadModel(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        IArchimateModel model = this.locateLoadedModel(file);
        if (model != null) {
            return model;
        }
        Resource resource = IArchiveManager.FACTORY.createResource(file);
        ModelCompatibility modelCompatibility = new ModelCompatibility(resource);
        try {
            resource.load(null);
        }
        catch (IOException ex) {
            if (resource.getErrors().isEmpty() && PlatformUI.isWorkbenchRunning()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorModelManager_2, (String)ex.toString());
                return null;
            }
            try {
                modelCompatibility.checkErrors();
            }
            catch (IncompatibleModelException ex1) {
                if (PlatformUI.isWorkbenchRunning()) {
                    ErrorMessageDialog.open(Display.getCurrent().getActiveShell(), Messages.EditorModelManager_2, NLS.bind((String)Messages.EditorModelManager_3, (Object)file), ex1.getMessage());
                }
                return null;
            }
        }
        model = (IArchimateModel)resource.getContents().get(0);
        if (PlatformUI.isWorkbenchRunning()) {
            boolean isLaterModelVersion = modelCompatibility.isLaterModelVersion("5.0.0");
            if (isLaterModelVersion) {
                boolean answer = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorModelManager_4, (String)NLS.bind((String)Messages.EditorModelManager_5, (Object)file, (Object)model.getVersion()));
                if (!answer) {
                    return null;
                }
            } else {
                List<Resource.Diagnostic> exceptions = modelCompatibility.getAcceptableExceptions();
                if (!exceptions.isEmpty()) {
                    Object message = "";
                    for (Resource.Diagnostic diagnostic : exceptions) {
                        message = (String)message + diagnostic.getMessage() + "\n";
                    }
                    boolean answer = ErrorMessageDialog.openWithQuestion(Display.getCurrent().getActiveShell(), Messages.EditorModelManager_4, NLS.bind((String)Messages.EditorModelManager_13, (Object)file), (String)message);
                    if (!answer) {
                        return null;
                    }
                }
            }
        }
        try {
            modelCompatibility.fixCompatibility();
        }
        catch (CompatibilityHandlerException compatibilityHandlerException) {}
        model.setFile(file);
        model.setDefaults();
        this.getModels().add(model);
        model.addModelContentListener(this.fEContentListener);
        this.createNewCommandStack(model);
        this.createNewArchiveManager(model);
        this.markDiagramModelsAsSaved(model);
        this.firePropertyChange(this, "IEditorModelManager.model.loaded", null, model);
        return model;
    }

    @Override
    public IArchimateModel load(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        Resource resource = IArchiveManager.FACTORY.createResource(file);
        ModelCompatibility modelCompatibility = new ModelCompatibility(resource);
        try {
            resource.load(null);
        }
        catch (IOException ex) {
            if (resource.getErrors().isEmpty()) {
                throw ex;
            }
            try {
                modelCompatibility.checkErrors();
            }
            catch (IncompatibleModelException ex1) {
                throw new IOException(NLS.bind((String)Messages.EditorModelManager_10, (Object)file) + "\n" + ex1.getMessage());
            }
        }
        IArchimateModel model = (IArchimateModel)resource.getContents().get(0);
        try {
            modelCompatibility.fixCompatibility();
        }
        catch (CompatibilityHandlerException compatibilityHandlerException) {}
        model.setFile(file);
        model.setDefaults();
        model.setAdapter(CommandStack.class, (Object)new CommandStack());
        IArchiveManager archiveManager = IArchiveManager.FACTORY.createArchiveManager(model);
        model.setAdapter(IArchiveManager.class, (Object)archiveManager);
        archiveManager.loadImages();
        return model;
    }

    @Override
    public boolean closeModel(IArchimateModel model) throws IOException {
        return this.closeModel(model, true);
    }

    @Override
    public boolean closeModel(IArchimateModel model, boolean askSaveModel) throws IOException {
        boolean result;
        if (model == null) {
            return true;
        }
        if (PlatformUI.isWorkbenchRunning() && this.isModelDirty(model) && askSaveModel && !(result = this.askSaveModel(model))) {
            return false;
        }
        EditorManager.closeDiagramEditors(model);
        this.getModels().remove(model);
        this.firePropertyChange(this, "IEditorModelManager.model.removed", null, model);
        this.deleteCommandStack(model);
        this.deleteArchiveManager(model);
        model.dispose();
        return true;
    }

    private boolean askSaveModel(IArchimateModel model) throws IOException {
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.EditorModelManager_6, null, NLS.bind((String)Messages.EditorModelManager_7, (Object)model.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int result = dialog.open();
        if (result == 0) {
            return this.saveModel(model);
        }
        return result == 1;
    }

    @Override
    public boolean saveModel(IArchimateModel model) throws IOException {
        File file;
        ModelChecker checker = new ModelChecker(model);
        if (!checker.checkAll()) {
            if (PlatformUI.isWorkbenchRunning()) {
                checker.showErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            }
            return false;
        }
        if (model.getFile() == null) {
            file = this.askSaveModel();
            if (file == null) {
                return false;
            }
            model.setFile(file);
        }
        file = model.getFile();
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("backupOnSave") && file.exists()) {
            FileUtils.copyFile(file, new File(model.getFile().getAbsolutePath() + ".bak"), false);
        }
        model.setVersion("5.0.0");
        IArchiveManager archiveManager = (IArchiveManager)model.getAdapter(IArchiveManager.class);
        archiveManager.saveModel();
        CommandStack stack = (CommandStack)model.getAdapter(CommandStack.class);
        if (stack != null) {
            stack.markSaveLocation();
            this.firePropertyChange(model, "IEditorModelManager.model.dirty", true, false);
        }
        this.markDiagramModelsAsSaved(model);
        this.firePropertyChange(this, "IEditorModelManager.model.saved", null, model);
        return true;
    }

    @Override
    public boolean saveModelAs(IArchimateModel model) throws IOException {
        if (model == null) {
            return false;
        }
        File file = this.askSaveModel();
        if (file == null) {
            return false;
        }
        EditorManager.activateDiagramEditors(model);
        model.setFile(file);
        return this.saveModel(model);
    }

    @Override
    public boolean isModelLoaded(File file) {
        return this.locateLoadedModel(file) != null;
    }

    private IArchimateModel locateLoadedModel(File file) {
        if (file != null) {
            for (IArchimateModel model : this.getModels()) {
                if (!file.equals(model.getFile())) continue;
                return model;
            }
        }
        return null;
    }

    @Override
    public boolean isModelDirty(IArchimateModel model) {
        if (model == null) {
            return false;
        }
        CommandStack stack = (CommandStack)model.getAdapter(CommandStack.class);
        return stack != null && stack.isDirty();
    }

    private File askSaveModel() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.setActive();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(new String[]{"*.archimate", "*.*"});
        dialog.setOverwrite(true);
        Object path = dialog.open();
        if (path == null) {
            return null;
        }
        if (dialog.getFilterIndex() == 0 && !((String)path).endsWith(".archimate")) {
            path = (String)path + ".archimate";
        }
        File file = new File((String)path);
        for (IArchimateModel m : this.getModels()) {
            if (!file.equals(m.getFile())) continue;
            MessageDialog.openWarning((Shell)shell, (String)Messages.EditorModelManager_8, (String)NLS.bind((String)Messages.EditorModelManager_9, (Object)file));
            return null;
        }
        return file;
    }

    private void createNewCommandStack(IArchimateModel model) {
        CommandStack cmdStack = new CommandStack();
        if (PlatformUI.isWorkbenchRunning()) {
            cmdStack.addCommandStackEventListener(event -> {
                if (event.isPostChangeEvent()) {
                    this.firePropertyChange(model, "IEditorModelManager.model.dirty", false, true);
                }
            });
            AnimationUtil.registerCommandStack(cmdStack);
        }
        model.setAdapter(CommandStack.class, (Object)cmdStack);
    }

    private void deleteCommandStack(IArchimateModel model) {
        CommandStack stack = (CommandStack)model.getAdapter(CommandStack.class);
        if (stack != null) {
            stack.dispose();
        }
    }

    private void markDiagramModelsAsSaved(IArchimateModel model) {
        for (IDiagramModel dm : model.getDiagramModels()) {
            dm.setAdapter((Object)"saved", (Object)true);
        }
    }

    private IArchiveManager createNewArchiveManager(IArchimateModel model) {
        this.deleteArchiveManager(model);
        IArchiveManager archiveManager = IArchiveManager.FACTORY.createArchiveManager(model);
        model.setAdapter(IArchiveManager.class, (Object)archiveManager);
        try {
            archiveManager.loadImages();
        }
        catch (IOException ex) {
            Logger.logError("Could not load images", ex);
            ex.printStackTrace();
        }
        return archiveManager;
    }

    private void deleteArchiveManager(IArchimateModel model) {
        IArchiveManager archiveManager = (IArchiveManager)model.getAdapter(IArchiveManager.class);
        if (archiveManager != null) {
            archiveManager.dispose();
        }
    }

    @Override
    public void saveState() throws IOException {
        Document doc = new Document();
        Element rootElement = new Element("models");
        doc.setRootElement(rootElement);
        for (IArchimateModel model : this.getModels()) {
            File file = model.getFile();
            if (file == null) continue;
            Element modelElement = new Element("model");
            modelElement.setAttribute("file", file.getAbsolutePath());
            rootElement.addContent((Content)modelElement);
        }
        JDOMUtils.write2XMLFile((Document)doc, (File)this.backingFile);
    }

    private void loadState() throws IOException, JDOMException {
        Document doc;
        if (this.backingFile.exists() && (doc = JDOMUtils.readXMLFile((File)this.backingFile)).hasRootElement()) {
            Element rootElement = doc.getRootElement();
            for (Object e : rootElement.getChildren("model")) {
                Element modelElement = (Element)e;
                String filePath = modelElement.getAttributeValue("file");
                if (filePath == null) continue;
                this.loadModel(new File(filePath));
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void firePropertyChange(Object source, String prop, Object oldValue, Object newValue) {
        this.fListeners.firePropertyChange(new PropertyChangeEvent(source, prop, oldValue, newValue));
    }

    private void notifyChanged(Notification notification) {
        this.firePropertyChange(this, "IEditorModelManager.ecore.event", null, notification);
    }
}

