/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.p2;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.p2.DropinsPluginHandler;
import com.archimatetool.editor.p2.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class DropinsPluginDialog
extends ExtendedTitleAreaDialog {
    private static final String HELP_ID = "com.archimatetool.help.ManagePluginsDialog";
    public static final int INSTALL = 1025;
    public static final int UNINSTALL = 1026;
    private TableViewer viewer;

    public DropinsPluginDialog(Shell parentShell) {
        super(parentShell, "PluginsManagerDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/importpref_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DropinsPluginDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.DropinsPluginDialog_1);
        this.setMessage(Messages.DropinsPluginDialog_2);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite tableComp = new Composite(container, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        this.viewer = new TableViewer(tableComp, 68098);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, false));
        column.getColumn().setText(Messages.DropinsPluginDialog_3);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(8, false));
        column.getColumn().setText(Messages.DropinsPluginDialog_4);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, false));
        column.getColumn().setText(Messages.DropinsPluginDialog_5);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, false));
        column.getColumn().setText(Messages.DropinsPluginDialog_6);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, false));
        column.getColumn().setText(Messages.DropinsPluginDialog_14);
        final DropinsPluginHandler handler = new DropinsPluginHandler();
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                try {
                    return handler.getInstalledPlugins().toArray();
                }
                catch (IOException ex) {
                    Logger.logError("Error getting installed plug-in", ex);
                    return new Object[0];
                }
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Bundle b1 = (Bundle)e1;
                Bundle b2 = (Bundle)e2;
                return ((String)b1.getHeaders().get("Bundle-Name")).compareToIgnoreCase((String)b2.getHeaders().get("Bundle-Name"));
            }
        });
        class LabelCellProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private final /* synthetic */ DropinsPluginHandler val$handler;

            LabelCellProvider(DropinsPluginHandler dropinsPluginHandler) {
                this.val$handler = dropinsPluginHandler;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Bundle) {
                    Bundle bundle = (Bundle)element;
                    switch (columnIndex) {
                        case 0: {
                            return (String)bundle.getHeaders().get("Bundle-Name");
                        }
                        case 1: {
                            return bundle.getVersion().toString();
                        }
                        case 2: {
                            return bundle.getSymbolicName();
                        }
                        case 3: {
                            return (String)bundle.getHeaders().get("Bundle-Vendor");
                        }
                        case 4: {
                            try {
                                File file = this.val$handler.getDropinsBundleFile(bundle);
                                return file == null ? Messages.DropinsPluginDialog_13 : file.getParentFile().getPath();
                            }
                            catch (IOException iOException) {
                                return Messages.DropinsPluginDialog_13;
                            }
                        }
                    }
                }
                return element.toString();
            }
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelCellProvider(handler));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DropinsPluginDialog.this.getButton(1026).setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.setInput((Object)"");
        return area;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                try {
                    DropinsPluginHandler handler = new DropinsPluginHandler();
                    if (handler.install(this.getShell()) != 1) break;
                    this.restart();
                }
                catch (IOException ex) {
                    Logger.logError("Error installing plug-in", ex);
                }
                break;
            }
            case 1026: {
                try {
                    List selected = ((IStructuredSelection)this.viewer.getSelection()).toList();
                    DropinsPluginHandler handler = new DropinsPluginHandler();
                    if (handler.uninstall(this.getShell(), selected) != 1) break;
                    this.restart();
                }
                catch (IOException ex) {
                    Logger.logError("Error uninstalling plug-in", ex);
                }
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private void restart() {
        this.okPressed();
        boolean ok = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DropinsPluginDialog_7, (String)Messages.DropinsPluginDialog_9);
        if (ok) {
            PlatformUI.getWorkbench().restart();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.DropinsPluginDialog_10, false);
        this.createButton(parent, 1026, Messages.DropinsPluginDialog_11, false).setEnabled(false);
        this.createButton(parent, 0, Messages.DropinsPluginDialog_12, true);
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(670, 350);
    }
}

