/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.p2;

import com.archimatetool.editor.p2.Messages;
import com.archimatetool.editor.p2.P2Handler;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class P2InstallHandler {
    private Shell shell;
    private boolean needsRestart = false;

    public boolean execute(Shell shell) {
        this.shell = shell;
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!this.canWriteToInstallationFolder()) {
            String message = Messages.P2InstallHandler_0 + " ";
            message = PlatformUtils.isWindows() ? message + Messages.P2InstallHandler_1 : message + Messages.P2InstallHandler_2;
            this.displayErrorDialog(message);
            return false;
        }
        List<File> files = this.askOpenFiles();
        if (files.isEmpty()) {
            return false;
        }
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        try {
            for (File file : files) {
                IStatus status = this.installFile(file, (IProgressMonitor)monitor);
                stats.add(status);
            }
        }
        catch (IOException | ProvisionException ex) {
            this.displayErrorDialog(ex.getMessage());
            return false;
        }
        Object resultMessage = "";
        boolean hasError = false;
        int i = 0;
        while (i < stats.size()) {
            IStatus status = (IStatus)stats.get(i);
            if (status.isOK()) {
                this.needsRestart = true;
                resultMessage = (String)resultMessage + NLS.bind((String)(Messages.P2InstallHandler_6 + "\n"), (Object)files.get(i).getName());
            } else {
                hasError = true;
                resultMessage = status.getCode() == 666 ? (String)resultMessage + NLS.bind((String)(Messages.P2InstallHandler_10 + "\n"), (Object)files.get(i).getName()) : (status.getCode() == 10000 ? (String)resultMessage + NLS.bind((String)(Messages.P2InstallHandler_12 + "\n"), (Object)files.get(i).getName()) : (String)resultMessage + NLS.bind((String)(Messages.P2InstallHandler_14 + "\n"), (Object)files.get(i).getName()));
            }
            ++i;
        }
        if (hasError) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.P2InstallHandler_16, (String)resultMessage);
        }
        return true;
    }

    boolean needsRestart() {
        return this.needsRestart;
    }

    private IStatus installFile(File file, IProgressMonitor monitor) throws IOException, ProvisionException {
        IStatus status;
        File folder;
        block3: {
            Status status2;
            folder = null;
            status = null;
            try {
                if (this.isPluginZipFile(file)) break block3;
                status2 = new Status(4, "com.archimatetool.editor", 666, NLS.bind((String)Messages.P2InstallHandler_3, (Object)file.getAbsolutePath()), null);
            }
            catch (Throwable throwable) {
                FileUtils.deleteFolder(folder);
                throw throwable;
            }
            FileUtils.deleteFolder(folder);
            return status2;
        }
        folder = this.unpackZipFile(file);
        URI uri = folder.toURI();
        status = P2Handler.getInstance().isInstalled(uri, monitor) ? P2Handler.getInstance().update(uri, monitor) : P2Handler.getInstance().install(uri, monitor);
        FileUtils.deleteFolder(folder);
        return status;
    }

    private File unpackZipFile(File zipFile) throws IOException {
        Path tmp = Files.createTempDirectory("archi", new FileAttribute[0]);
        File tmpFolder = tmp.toFile();
        tmpFolder.deleteOnExit();
        ZipUtils.unpackZip(zipFile, tmpFolder);
        return tmpFolder;
    }

    private boolean canWriteToInstallationFolder() {
        try {
            File pluginsFolder = this.getPluginsFolder();
            return Files.isWritable(pluginsFolder.toPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean isPluginZipFile(File file) throws IOException {
        return ZipUtils.isZipFile(file) && ZipUtils.hasZipEntry(file, "artifacts.jar");
    }

    private File getPluginsFolder() throws IOException {
        URL url = Platform.getBundle((String)"com.archimatetool.editor").getEntry("/");
        url = FileLocator.resolve((URL)url);
        return new File(url.getPath()).getParentFile();
    }

    private List<File> askOpenFiles() {
        FileDialog dialog = new FileDialog(this.shell, 4098);
        dialog.setFilterExtensions(new String[]{"*.zip", "*.*"});
        String path = dialog.open();
        ArrayList<File> files = new ArrayList<File>();
        if (path != null) {
            String filterPath = dialog.getFilterPath() + File.separator;
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(filterPath, name);
                if (file.exists()) {
                    files.add(file);
                }
                ++n2;
            }
        }
        return files;
    }

    private void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.shell, (String)Messages.P2InstallHandler_4, (String)message);
    }
}

