/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.p2;

import com.archimatetool.editor.p2.Messages;
import com.archimatetool.editor.p2.P2Handler;
import com.archimatetool.editor.p2.P2InstallHandler;
import com.archimatetool.editor.p2.P2UninstallHandler;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import java.util.List;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class P2PluginDialog
extends ExtendedTitleAreaDialog {
    private static final String HELP_ID = "com.archimatetool.help.ManageP2PluginDialog";
    public static final int INSTALL = 1025;
    public static final int UNINSTALL = 1026;
    private TableViewer viewer;
    private boolean needsRestart = false;

    public P2PluginDialog(Shell parentShell) {
        super(parentShell, "PluginsManagerDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/importpref_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.P2PluginDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.P2PluginDialog_1);
        this.setMessage(Messages.P2PluginDialog_2);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite tableComp = new Composite(container, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        this.viewer = new TableViewer(tableComp, 68098);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, false));
        column.getColumn().setText(Messages.P2PluginDialog_3);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, false));
        column.getColumn().setText(Messages.P2PluginDialog_4);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, false));
        column.getColumn().setText(Messages.P2PluginDialog_5);
        column = new TableViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, false));
        column.getColumn().setText(Messages.P2PluginDialog_6);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                try {
                    return P2Handler.getInstance().getInstalledFeatures().toArray();
                }
                catch (ProvisionException ex) {
                    ex.printStackTrace();
                    return new Object[0];
                }
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IInstallableUnit u1 = (IInstallableUnit)e1;
                IInstallableUnit u2 = (IInstallableUnit)e2;
                String name1 = u1.getProperty("org.eclipse.equinox.p2.name", null);
                String name2 = u2.getProperty("org.eclipse.equinox.p2.name", null);
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return 0;
            }
        });
        class LabelCellProvider
        extends LabelProvider
        implements ITableLabelProvider {
            LabelCellProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IInstallableUnit) {
                    IInstallableUnit iu = (IInstallableUnit)element;
                    switch (columnIndex) {
                        case 0: {
                            return iu.getProperty("org.eclipse.equinox.p2.name", null);
                        }
                        case 1: {
                            return iu.getVersion().toString();
                        }
                        case 2: {
                            return iu.getId();
                        }
                        case 3: {
                            return iu.getProperty("org.eclipse.equinox.p2.provider", null);
                        }
                    }
                }
                return element.toString();
            }
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelCellProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                P2PluginDialog.this.getButton(1026).setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.setInput((Object)"");
        return area;
    }

    protected void buttonPressed(int buttonId) {
        boolean result = false;
        switch (buttonId) {
            case 1025: {
                P2InstallHandler installHandler = new P2InstallHandler();
                result = installHandler.execute(this.getShell());
                if (!installHandler.needsRestart()) break;
                this.needsRestart = true;
                break;
            }
            case 1026: {
                List selected = ((IStructuredSelection)this.viewer.getSelection()).toList();
                P2UninstallHandler uninstallHandler = new P2UninstallHandler();
                result = uninstallHandler.execute(this.getShell(), selected);
                if (!uninstallHandler.needsRestart()) break;
                this.needsRestart = true;
                break;
            }
            case 0: {
                boolean restart;
                super.buttonPressed(buttonId);
                if (this.needsRestart && (restart = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.P2PluginDialog_7, (String)Messages.P2PluginDialog_8))) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PlatformUI.getWorkbench().restart();
                        }
                    });
                }
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
        if (result) {
            this.viewer.refresh();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.P2PluginDialog_9, false);
        this.createButton(parent, 1026, Messages.P2PluginDialog_10, false).setEnabled(false);
        this.createButton(parent, 0, Messages.P2PluginDialog_11, true);
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(670, 350);
    }
}

