/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.p2;

import com.archimatetool.editor.p2.Messages;
import com.archimatetool.editor.p2.P2Handler;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class P2UninstallHandler {
    private Shell shell;
    private boolean needsRestart = false;

    public boolean execute(Shell shell, List<IInstallableUnit> selected) {
        this.shell = shell;
        if (selected.isEmpty()) {
            return false;
        }
        boolean ok = MessageDialog.openQuestion((Shell)shell, (String)Messages.P2UninstallHandler_0, (String)Messages.P2UninstallHandler_2);
        if (!ok) {
            return false;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            IStatus status = P2Handler.getInstance().uninstall(selected, (IProgressMonitor)monitor);
            if (status.isOK()) {
                this.needsRestart = true;
            } else {
                this.displayErrorDialog(Messages.P2UninstallHandler_1);
            }
        }
        catch (ProvisionException ex) {
            this.displayErrorDialog(ex.getMessage());
        }
        return true;
    }

    boolean needsRestart() {
        return this.needsRestart;
    }

    private void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.shell, (String)Messages.P2UninstallHandler_0, (String)message);
    }
}

