/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsAppearance";
    private ComboViewer fThemeComboViewer;
    private Button fUseThemes;
    private Button fUseRoundTabsButton;
    private Button fShowStatusLineButton;
    private Button fMacNativeItemHeightButton;
    private IThemeEngine themeEngine;
    private ITheme lastActiveTheme;
    private boolean highContrastMode;
    private static ITheme AUTOMATIC_THEME = new ITheme(){

        public String getId() {
            return Display.isSystemDarkTheme() ? "org.eclipse.e4.ui.css.theme.e4_dark" : "org.eclipse.e4.ui.css.theme.e4_default";
        }

        public String getLabel() {
            return Messages.AppearancePreferencePage_7;
        }
    };

    public AppearancePreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
        this.setDescription(Messages.AppearancePreferencePage_0);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        this.fUseThemes = new Button(client, 32);
        this.fUseThemes.setText(Messages.AppearancePreferencePage_4);
        this.fUseThemes.setLayoutData((Object)this.createHorizontalGridData(2));
        this.highContrastMode = parent.getDisplay().getHighContrast();
        if (this.themeEngine != null) {
            Label label = new Label(client, 0);
            label.setText(Messages.AppearancePreferencePage_1);
            this.fThemeComboViewer = new ComboViewer(client, 8);
            this.fThemeComboViewer.getCombo().setLayoutData((Object)this.createHorizontalGridData(1));
            this.fThemeComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return (Object[])inputElement;
                }
            });
            this.fThemeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((ITheme)element).getLabel();
                }
            });
            this.fThemeComboViewer.setComparator(new ViewerComparator());
            this.fThemeComboViewer.getCombo().setEnabled(!this.highContrastMode);
        }
        this.fUseRoundTabsButton = new Button(client, 32);
        this.fUseRoundTabsButton.setText(Messages.AppearancePreferencePage_3);
        this.fUseRoundTabsButton.setLayoutData((Object)this.createHorizontalGridData(2));
        this.fShowStatusLineButton = new Button(client, 32);
        this.fShowStatusLineButton.setText(Messages.AppearancePreferencePage_2);
        this.fShowStatusLineButton.setLayoutData((Object)this.createHorizontalGridData(2));
        if (PlatformUtils.isMac()) {
            this.fMacNativeItemHeightButton = new Button(client, 32);
            this.fMacNativeItemHeightButton.setText(Messages.AppearancePreferencePage_5);
            this.fMacNativeItemHeightButton.setToolTipText(Messages.AppearancePreferencePage_6);
            this.fMacNativeItemHeightButton.setLayoutData((Object)this.createHorizontalGridData(2));
        }
        this.setValues();
        if (this.themeEngine != null) {
            this.fThemeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ITheme theme = (ITheme)AppearancePreferencePage.this.fThemeComboViewer.getStructuredSelection().getFirstElement();
                    AppearancePreferencePage.this.themeEngine.setTheme(theme.getId(), false);
                }
            });
        }
        return client;
    }

    private void setValues() {
        if (this.themeEngine != null) {
            ArrayList<ITheme> themes = new ArrayList<ITheme>();
            themes.add(AUTOMATIC_THEME);
            for (ITheme theme : this.themeEngine.getThemes()) {
                if (!this.highContrastMode && !Util.isGtk() && theme.getId().equals("org.eclipse.e4.ui.css.theme.high-contrast")) continue;
                themes.add(theme);
            }
            this.fThemeComboViewer.setInput((Object)themes.toArray());
            if (!this.highContrastMode && ThemeUtils.getThemePreferences().get("themeid", null) == null) {
                this.fThemeComboViewer.setSelection((ISelection)new StructuredSelection((Object)AUTOMATIC_THEME));
            } else {
                ITheme activeTheme = this.themeEngine.getActiveTheme();
                if (activeTheme != null) {
                    this.fThemeComboViewer.setSelection((ISelection)new StructuredSelection((Object)activeTheme));
                }
            }
        }
        this.fUseThemes.setSelection(this.themeEngine != null);
        this.fShowStatusLineButton.setSelection(this.getPreferenceStore().getBoolean("showStatusLine"));
        this.fUseRoundTabsButton.setSelection(ThemeUtils.getSwtRendererPreferences().getBoolean("USE_ROUND_TABS", false));
        if (this.fMacNativeItemHeightButton != null) {
            boolean useNativeItemHeights = this.getPreferenceStore().getBoolean("org.eclipse.swt.internal.cocoa.useNativeItemHeight");
            this.fMacNativeItemHeightButton.setSelection(useNativeItemHeights);
        }
    }

    public boolean performOk() {
        if (this.themeEngine != null) {
            ITheme theme = (ITheme)this.fThemeComboViewer.getStructuredSelection().getFirstElement();
            if (theme == AUTOMATIC_THEME) {
                IEclipsePreferences themePrefs = ThemeUtils.getThemePreferences();
                themePrefs.remove("themeid");
                try {
                    themePrefs.flush();
                }
                catch (BackingStoreException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.themeEngine.setTheme(theme, !this.highContrastMode);
            }
            this.lastActiveTheme = this.themeEngine.getActiveTheme();
        }
        this.getPreferenceStore().setValue("showStatusLine", this.fShowStatusLineButton.getSelection());
        IEclipsePreferences swtPrefs = ThemeUtils.getSwtRendererPreferences();
        swtPrefs.putBoolean("themeEnabled", this.fUseThemes.getSelection());
        swtPrefs.putBoolean("USE_ROUND_TABS", this.fUseRoundTabsButton.getSelection());
        try {
            swtPrefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        if (this.fMacNativeItemHeightButton != null) {
            this.getPreferenceStore().setValue("org.eclipse.swt.internal.cocoa.useNativeItemHeight", this.fMacNativeItemHeightButton.getSelection());
        }
        return true;
    }

    protected void performDefaults() {
        if (this.themeEngine != null) {
            this.themeEngine.setTheme(ThemeUtils.getDefaultThemeName(), false);
            ITheme activeTheme = this.themeEngine.getActiveTheme();
            if (activeTheme != null) {
                this.fThemeComboViewer.setSelection((ISelection)new StructuredSelection((Object)activeTheme));
            }
        }
        this.fUseThemes.setSelection(true);
        this.fUseRoundTabsButton.setSelection(false);
        this.fShowStatusLineButton.setSelection(this.getPreferenceStore().getDefaultBoolean("showStatusLine"));
        if (this.fMacNativeItemHeightButton != null) {
            this.fMacNativeItemHeightButton.setSelection(false);
        }
        super.performDefaults();
    }

    public boolean performCancel() {
        if (this.themeEngine != null && this.lastActiveTheme != null && this.lastActiveTheme != this.themeEngine.getActiveTheme()) {
            this.themeEngine.setTheme(this.lastActiveTheme, false);
        }
        return super.performCancel();
    }

    private GridData createHorizontalGridData(int span) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        return gd;
    }

    public void init(IWorkbench workbench) {
        this.themeEngine = ThemeUtils.getThemeEngine();
        this.lastActiveTheme = this.themeEngine == null ? null : this.themeEngine.getActiveTheme();
    }
}

