/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.ConnectionPreferences;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConnectionsARMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsConnections";
    private Button fUseNestedConnectionsButton;
    private Button fCreateRelationWhenAddingNewElementButton;
    private Button fCreateRelationWhenAddingModelTreeElementButton;
    private Button fCreateRelationWhenMovingElement;
    private CheckboxTableViewer fTableViewerNewRelations;
    private CheckboxTableViewer fTableViewerReversedRelations;
    private CheckboxTableViewer fTableViewerHiddenRelations;

    public ConnectionsARMPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
        this.setDescription(Messages.ConnectionsARMPreferencePage_0);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        this.fUseNestedConnectionsButton = new Button(client, 32);
        this.fUseNestedConnectionsButton.setText(Messages.ConnectionsARMPreferencePage_1);
        GridData gd = new GridData(768);
        this.fUseNestedConnectionsButton.setLayoutData((Object)gd);
        this.fUseNestedConnectionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsARMPreferencePage.this.enableNestedConnectionComponents();
            }
        });
        this.fCreateRelationWhenAddingNewElementButton = new Button(client, 32);
        this.fCreateRelationWhenAddingNewElementButton.setText(Messages.ConnectionsARMPreferencePage_2);
        gd = new GridData(768);
        this.fCreateRelationWhenAddingNewElementButton.setLayoutData((Object)gd);
        this.fCreateRelationWhenAddingNewElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsARMPreferencePage.this.enableNestedConnectionComponents();
            }
        });
        this.fCreateRelationWhenAddingModelTreeElementButton = new Button(client, 32);
        this.fCreateRelationWhenAddingModelTreeElementButton.setText(Messages.ConnectionsARMPreferencePage_3);
        gd = new GridData(768);
        this.fCreateRelationWhenAddingModelTreeElementButton.setLayoutData((Object)gd);
        this.fCreateRelationWhenAddingModelTreeElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsARMPreferencePage.this.enableNestedConnectionComponents();
            }
        });
        this.fCreateRelationWhenMovingElement = new Button(client, 32);
        this.fCreateRelationWhenMovingElement.setText(Messages.ConnectionsARMPreferencePage_4);
        gd = new GridData(768);
        this.fCreateRelationWhenMovingElement.setLayoutData((Object)gd);
        this.fCreateRelationWhenMovingElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsARMPreferencePage.this.enableNestedConnectionComponents();
            }
        });
        Label label = new Label(client, 0);
        label.setText(Messages.ConnectionsARMPreferencePage_5);
        this.fTableViewerNewRelations = this.createRelationsTable(client);
        label = new Label(client, 0);
        label.setText(Messages.ConnectionsARMPreferencePage_6);
        this.fTableViewerReversedRelations = this.createRelationsTable(client);
        label = new Label(client, 0);
        label.setText(Messages.ConnectionsARMPreferencePage_7);
        this.fTableViewerHiddenRelations = this.createRelationsTable(client);
        Display.getCurrent().asyncExec(() -> this.setValues());
        return client;
    }

    private CheckboxTableViewer createRelationsTable(Composite parent) {
        final CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridDataFactory.create((int)768).hint(-1, 100).applyTo((Control)viewer.getTable());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ArchiLabelProvider.INSTANCE.getDefaultName((EClass)element);
            }

            public Image getImage(Object element) {
                return ArchiLabelProvider.INSTANCE.getImage(element);
            }
        });
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ConnectionPreferences.RELATION_KEYMAP.keySet().toArray();
            }
        });
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                int value = (Integer)viewer.getInput();
                return (value & ConnectionPreferences.RELATION_KEYMAP.get(element)) != 0;
            }
        });
        return viewer;
    }

    private void enableNestedConnectionComponents() {
        boolean enabled = this.fUseNestedConnectionsButton.getSelection();
        this.fCreateRelationWhenAddingNewElementButton.setEnabled(enabled);
        this.fCreateRelationWhenAddingModelTreeElementButton.setEnabled(enabled);
        this.fCreateRelationWhenMovingElement.setEnabled(enabled);
        boolean alsoEnabled = enabled && (this.fCreateRelationWhenAddingNewElementButton.getSelection() || this.fCreateRelationWhenAddingModelTreeElementButton.getSelection() || this.fCreateRelationWhenMovingElement.getSelection());
        this.fTableViewerNewRelations.getTable().setEnabled(alsoEnabled);
        this.fTableViewerReversedRelations.getTable().setEnabled(alsoEnabled);
        this.fTableViewerHiddenRelations.getTable().setEnabled(enabled);
    }

    private void setValues() {
        this.fUseNestedConnectionsButton.setSelection(this.getPreferenceStore().getBoolean("useNestedConnections"));
        this.fCreateRelationWhenAddingNewElementButton.setSelection(this.getPreferenceStore().getBoolean("createRelationWhenAddingNewElementToContainer"));
        this.fCreateRelationWhenAddingModelTreeElementButton.setSelection(this.getPreferenceStore().getBoolean("createRelationWhenAddingModelTreeElementToContainer"));
        this.fCreateRelationWhenMovingElement.setSelection(this.getPreferenceStore().getBoolean("createRelationWhenMovingElementToContainer"));
        this.fTableViewerNewRelations.setInput((Object)this.getPreferenceStore().getInt("newRelationsTypes"));
        this.fTableViewerReversedRelations.setInput((Object)this.getPreferenceStore().getInt("newReverseRelationsTypes"));
        this.fTableViewerHiddenRelations.setInput((Object)this.getPreferenceStore().getInt("hiddenRelationsTypes"));
        this.enableNestedConnectionComponents();
    }

    public boolean performOk() {
        Object checked;
        this.getPreferenceStore().setValue("useNestedConnections", this.fUseNestedConnectionsButton.getSelection());
        this.getPreferenceStore().setValue("createRelationWhenAddingNewElementToContainer", this.fCreateRelationWhenAddingNewElementButton.getSelection());
        this.getPreferenceStore().setValue("createRelationWhenAddingModelTreeElementToContainer", this.fCreateRelationWhenAddingModelTreeElementButton.getSelection());
        this.getPreferenceStore().setValue("createRelationWhenMovingElementToContainer", this.fCreateRelationWhenMovingElement.getSelection());
        int value = 0;
        Object[] objectArray = this.fTableViewerNewRelations.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            checked = objectArray[n2];
            value |= ConnectionPreferences.RELATION_KEYMAP.get(checked).intValue();
            ++n2;
        }
        this.getPreferenceStore().setValue("newRelationsTypes", value);
        value = 0;
        objectArray = this.fTableViewerReversedRelations.getCheckedElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            checked = objectArray[n2];
            value |= ConnectionPreferences.RELATION_KEYMAP.get(checked).intValue();
            ++n2;
        }
        this.getPreferenceStore().setValue("newReverseRelationsTypes", value);
        value = 0;
        objectArray = this.fTableViewerHiddenRelations.getCheckedElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            checked = objectArray[n2];
            value |= ConnectionPreferences.RELATION_KEYMAP.get(checked).intValue();
            ++n2;
        }
        this.getPreferenceStore().setValue("hiddenRelationsTypes", value);
        return true;
    }

    protected void performDefaults() {
        this.fUseNestedConnectionsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("useNestedConnections"));
        this.fCreateRelationWhenAddingNewElementButton.setSelection(this.getPreferenceStore().getDefaultBoolean("createRelationWhenAddingNewElementToContainer"));
        this.fCreateRelationWhenAddingModelTreeElementButton.setSelection(this.getPreferenceStore().getDefaultBoolean("createRelationWhenAddingModelTreeElementToContainer"));
        this.fCreateRelationWhenMovingElement.setSelection(this.getPreferenceStore().getDefaultBoolean("createRelationWhenMovingElementToContainer"));
        this.fTableViewerNewRelations.setInput((Object)this.getPreferenceStore().getDefaultInt("newRelationsTypes"));
        this.fTableViewerReversedRelations.setInput((Object)this.getPreferenceStore().getDefaultInt("newReverseRelationsTypes"));
        this.fTableViewerHiddenRelations.setInput((Object)this.getPreferenceStore().getDefaultInt("hiddenRelationsTypes"));
        this.enableNestedConnectionComponents();
        super.performDefaults();
    }
}

