/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConnectionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsConnections";
    private Button fMagicConnectorPolarity1Button;
    private Button fMagicConnectorPolarity2Button;
    private Button fDoAntiAliasButton;
    private Button fUseOrthogonalAnchorButton;
    private Button fUseLineCurvesButton;
    private Button fUseLineJumpsButton;
    private Button fHighlightSelectedConnectionsButton;
    private Combo fConnectionLabelStrategyCombo;
    private String[] CONNECTION_LABEL_STRATEGIES = new String[]{Messages.ConnectionsPreferencePage_0, Messages.ConnectionsPreferencePage_1, Messages.ConnectionsPreferencePage_2};
    private Button fShowReconnectionWarningButton;

    public ConnectionsPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Group magicConnectorGroup = new Group(client, 0);
        magicConnectorGroup.setText(Messages.ConnectionsPreferencePage_3);
        magicConnectorGroup.setLayout((Layout)new GridLayout());
        GridDataFactory.create((int)768).applyTo((Control)magicConnectorGroup);
        this.fMagicConnectorPolarity1Button = new Button((Composite)magicConnectorGroup, 16);
        this.fMagicConnectorPolarity1Button.setText(Messages.ConnectionsPreferencePage_4);
        GridDataFactory.create((int)768).applyTo((Control)this.fMagicConnectorPolarity1Button);
        this.fMagicConnectorPolarity2Button = new Button((Composite)magicConnectorGroup, 16);
        this.fMagicConnectorPolarity2Button.setText(Messages.ConnectionsPreferencePage_5);
        GridDataFactory.create((int)768).applyTo((Control)this.fMagicConnectorPolarity2Button);
        Group connectorGroup = new Group(client, 0);
        connectorGroup.setText(Messages.ConnectionsPreferencePage_6);
        connectorGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.create((int)768).applyTo((Control)connectorGroup);
        this.fDoAntiAliasButton = new Button((Composite)connectorGroup, 32);
        this.fDoAntiAliasButton.setText(Messages.ConnectionsPreferencePage_7);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fDoAntiAliasButton);
        this.fUseOrthogonalAnchorButton = new Button((Composite)connectorGroup, 32);
        this.fUseOrthogonalAnchorButton.setText(Messages.ConnectionsPreferencePage_8);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fUseOrthogonalAnchorButton);
        this.fUseLineCurvesButton = new Button((Composite)connectorGroup, 32);
        this.fUseLineCurvesButton.setText(Messages.ConnectionsPreferencePage_9);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fUseLineCurvesButton);
        this.fUseLineJumpsButton = new Button((Composite)connectorGroup, 32);
        this.fUseLineJumpsButton.setText(Messages.ConnectionsPreferencePage_10);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fUseLineJumpsButton);
        this.fHighlightSelectedConnectionsButton = new Button((Composite)connectorGroup, 32);
        this.fHighlightSelectedConnectionsButton.setText(Messages.ConnectionsPreferencePage_14);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fHighlightSelectedConnectionsButton);
        Label label = new Label((Composite)connectorGroup, 0);
        label.setText(Messages.ConnectionsPreferencePage_11);
        this.fConnectionLabelStrategyCombo = new Combo((Composite)connectorGroup, 8);
        GridDataFactory.create((int)768).applyTo((Control)this.fConnectionLabelStrategyCombo);
        this.fConnectionLabelStrategyCombo.setItems(this.CONNECTION_LABEL_STRATEGIES);
        Group generalGroup = new Group(client, 0);
        generalGroup.setText(Messages.ConnectionsPreferencePage_12);
        generalGroup.setLayout((Layout)new GridLayout());
        GridDataFactory.create((int)768).applyTo((Control)generalGroup);
        this.fShowReconnectionWarningButton = new Button((Composite)generalGroup, 32);
        this.fShowReconnectionWarningButton.setText(Messages.ConnectionsPreferencePage_13);
        this.setValues();
        return client;
    }

    private void setValues() {
        this.fMagicConnectorPolarity1Button.setSelection(this.getPreferenceStore().getBoolean("polarityMagicConnector"));
        this.fMagicConnectorPolarity2Button.setSelection(!this.getPreferenceStore().getBoolean("polarityMagicConnector"));
        this.fDoAntiAliasButton.setSelection(this.getPreferenceStore().getBoolean("antiAlias"));
        this.fUseOrthogonalAnchorButton.setSelection(this.getPreferenceStore().getBoolean("orthogonalAnchor"));
        this.fUseLineCurvesButton.setSelection(this.getPreferenceStore().getBoolean("lineCurves"));
        this.fUseLineJumpsButton.setSelection(this.getPreferenceStore().getBoolean("lineJumps"));
        this.fHighlightSelectedConnectionsButton.setSelection(this.getPreferenceStore().getBoolean("showSelectedConnections"));
        this.fConnectionLabelStrategyCombo.select(this.getPreferenceStore().getInt("connectionLabelStrategy"));
        this.fShowReconnectionWarningButton.setSelection(this.getPreferenceStore().getBoolean("showWarningOnReconnect"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("polarityMagicConnector", this.fMagicConnectorPolarity1Button.getSelection());
        this.getPreferenceStore().setValue("antiAlias", this.fDoAntiAliasButton.getSelection());
        this.getPreferenceStore().setValue("orthogonalAnchor", this.fUseOrthogonalAnchorButton.getSelection());
        this.getPreferenceStore().setValue("lineCurves", this.fUseLineCurvesButton.getSelection());
        this.getPreferenceStore().setValue("lineJumps", this.fUseLineJumpsButton.getSelection());
        this.getPreferenceStore().setValue("showSelectedConnections", this.fHighlightSelectedConnectionsButton.getSelection());
        this.getPreferenceStore().setValue("connectionLabelStrategy", this.fConnectionLabelStrategyCombo.getSelectionIndex());
        this.getPreferenceStore().setValue("showWarningOnReconnect", this.fShowReconnectionWarningButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.fMagicConnectorPolarity1Button.setSelection(this.getPreferenceStore().getDefaultBoolean("polarityMagicConnector"));
        this.fMagicConnectorPolarity2Button.setSelection(!this.getPreferenceStore().getDefaultBoolean("polarityMagicConnector"));
        this.fDoAntiAliasButton.setSelection(this.getPreferenceStore().getDefaultBoolean("antiAlias"));
        this.fUseOrthogonalAnchorButton.setSelection(this.getPreferenceStore().getDefaultBoolean("orthogonalAnchor"));
        this.fUseLineCurvesButton.setSelection(this.getPreferenceStore().getDefaultBoolean("lineCurves"));
        this.fUseLineJumpsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("lineJumps"));
        this.fHighlightSelectedConnectionsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("showSelectedConnections"));
        this.fConnectionLabelStrategyCombo.select(this.getPreferenceStore().getDefaultInt("connectionLabelStrategy"));
        this.fShowReconnectionWarningButton.setSelection(this.getPreferenceStore().getDefaultBoolean("showWarningOnReconnect"));
        super.performDefaults();
    }
}

