/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.sketch.ISketchEditor;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DiagramAppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsDiagram";
    private Combo fDefaultGradientCombo;
    private String[] GRADIENT_STYLES = new String[]{Messages.DiagramAppearancePreferencePage_16, Messages.DiagramAppearancePreferencePage_17, Messages.DiagramAppearancePreferencePage_18, Messages.DiagramAppearancePreferencePage_19, Messages.DiagramAppearancePreferencePage_20};
    private Spinner fDefaultArchimateFigureWidthSpinner;
    private Spinner fDefaultArchimateFigureHeightSpinner;
    private Combo fWordWrapStyleCombo;
    private String[] WORD_WRAP_STYLES = new String[]{Messages.DiagramAppearancePreferencePage_4, Messages.DiagramAppearancePreferencePage_5, Messages.DiagramAppearancePreferencePage_6};
    private Combo fDefaultSketchBackgroundCombo;
    private Combo fDefaultTextAlignmentCombo;
    private Combo fDefaultTextPositionCombo;
    private String[] TEXT_ALIGNMENTS = new String[]{Messages.DiagramAppearancePreferencePage_8, Messages.DiagramAppearancePreferencePage_9, Messages.DiagramAppearancePreferencePage_10};
    private int[] TEXT_ALIGNMENT_VALUES = new int[]{1, 2, 4};
    private String[] TEXT_POSITIONS = new String[]{Messages.DiagramAppearancePreferencePage_11, Messages.DiagramAppearancePreferencePage_12, Messages.DiagramAppearancePreferencePage_13};

    public DiagramAppearancePreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    public Composite createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Group globalGroup = new Group(client, 0);
        globalGroup.setText(Messages.DiagramAppearancePreferencePage_0);
        globalGroup.setLayout((Layout)new GridLayout(2, false));
        globalGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)globalGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_7);
        this.fWordWrapStyleCombo = new Combo((Composite)globalGroup, 8);
        this.fWordWrapStyleCombo.setItems(this.WORD_WRAP_STYLES);
        this.fWordWrapStyleCombo.setLayoutData((Object)new GridData(768));
        Group defaultsGroup = new Group(client, 0);
        defaultsGroup.setText(Messages.DiagramAppearancePreferencePage_1);
        defaultsGroup.setLayout((Layout)new GridLayout(2, false));
        defaultsGroup.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)defaultsGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_2);
        this.fDefaultArchimateFigureWidthSpinner = new Spinner((Composite)defaultsGroup, 2048);
        this.fDefaultArchimateFigureWidthSpinner.setMinimum(30);
        this.fDefaultArchimateFigureWidthSpinner.setMaximum(300);
        label = new Label((Composite)defaultsGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_3);
        this.fDefaultArchimateFigureHeightSpinner = new Spinner((Composite)defaultsGroup, 2048);
        this.fDefaultArchimateFigureHeightSpinner.setMinimum(30);
        this.fDefaultArchimateFigureHeightSpinner.setMaximum(300);
        label = new Label((Composite)defaultsGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_14);
        this.fDefaultTextAlignmentCombo = new Combo((Composite)defaultsGroup, 8);
        this.fDefaultTextAlignmentCombo.setItems(this.TEXT_ALIGNMENTS);
        this.fDefaultTextAlignmentCombo.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)defaultsGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_15);
        this.fDefaultTextPositionCombo = new Combo((Composite)defaultsGroup, 8);
        this.fDefaultTextPositionCombo.setItems(this.TEXT_POSITIONS);
        this.fDefaultTextPositionCombo.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)defaultsGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_21);
        this.fDefaultGradientCombo = new Combo((Composite)defaultsGroup, 8);
        this.fDefaultGradientCombo.setItems(this.GRADIENT_STYLES);
        this.fDefaultGradientCombo.setLayoutData((Object)new GridData(768));
        Group sketchGroup = new Group(client, 0);
        sketchGroup.setLayout((Layout)new GridLayout(2, false));
        sketchGroup.setText(Messages.DiagramAppearancePreferencePage_22);
        sketchGroup.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)sketchGroup, 0);
        label.setText(Messages.DiagramAppearancePreferencePage_23);
        this.fDefaultSketchBackgroundCombo = new Combo((Composite)sketchGroup, 8);
        this.fDefaultSketchBackgroundCombo.setItems(ISketchEditor.BACKGROUNDS);
        this.fDefaultSketchBackgroundCombo.setLayoutData((Object)new GridData(768));
        this.setValues();
        return client;
    }

    private void setValues() {
        this.fDefaultGradientCombo.select(this.getPreferenceStore().getInt("defaultGradient") + 1);
        this.fWordWrapStyleCombo.select(this.getPreferenceStore().getInt("archimateFigureWordWrapStyle"));
        this.fDefaultArchimateFigureWidthSpinner.setSelection(this.getPreferenceStore().getInt("defaultArchiMateFigureWidth"));
        this.fDefaultArchimateFigureHeightSpinner.setSelection(this.getPreferenceStore().getInt("defaultArchiMateFigureHeight"));
        this.fDefaultTextAlignmentCombo.select(this.getPreferenceStore().getInt("defaultArchiMateTextAlignment") / 2);
        this.fDefaultTextPositionCombo.select(this.getPreferenceStore().getInt("defaultArchiMateTextPosition"));
        this.fDefaultSketchBackgroundCombo.select(this.getPreferenceStore().getInt("sketchDefaultBackground"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("defaultGradient", this.fDefaultGradientCombo.getSelectionIndex() - 1);
        this.getPreferenceStore().setValue("archimateFigureWordWrapStyle", this.fWordWrapStyleCombo.getSelectionIndex());
        this.getPreferenceStore().setValue("defaultArchiMateFigureWidth", this.fDefaultArchimateFigureWidthSpinner.getSelection());
        this.getPreferenceStore().setValue("defaultArchiMateFigureHeight", this.fDefaultArchimateFigureHeightSpinner.getSelection());
        this.getPreferenceStore().setValue("defaultArchiMateTextAlignment", this.TEXT_ALIGNMENT_VALUES[this.fDefaultTextAlignmentCombo.getSelectionIndex()]);
        this.getPreferenceStore().setValue("defaultArchiMateTextPosition", this.fDefaultTextPositionCombo.getSelectionIndex());
        this.getPreferenceStore().setValue("sketchDefaultBackground", this.fDefaultSketchBackgroundCombo.getSelectionIndex());
        return true;
    }

    protected void performDefaults() {
        this.fDefaultGradientCombo.select(this.getPreferenceStore().getDefaultInt("defaultGradient") + 1);
        this.fWordWrapStyleCombo.select(this.getPreferenceStore().getDefaultInt("archimateFigureWordWrapStyle"));
        this.fDefaultArchimateFigureWidthSpinner.setSelection(this.getPreferenceStore().getDefaultInt("defaultArchiMateFigureWidth"));
        this.fDefaultArchimateFigureHeightSpinner.setSelection(this.getPreferenceStore().getDefaultInt("defaultArchiMateFigureHeight"));
        this.fDefaultTextAlignmentCombo.select(this.getPreferenceStore().getDefaultInt("defaultArchiMateTextAlignment") / 2);
        this.fDefaultTextPositionCombo.select(this.getPreferenceStore().getDefaultInt("defaultArchiMateTextPosition"));
        this.fDefaultSketchBackgroundCombo.select(this.getPreferenceStore().getDefaultInt("sketchDefaultBackground"));
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

