/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DiagramPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsDiagram";
    private Spinner fGridSizeSpinner;
    private Spinner fMarginWidthSpinner;
    private Button fViewTooltipsButton;
    private Button fPaletteStateButton;
    private Button fShowSpecializationsPaletteButton;
    private Button fViewpointsFilterModelTreeButton;
    private Button fViewpointsHidePaletteElementsButton;
    private Button fViewpointsGhostDiagramElementsButton;
    private Button fViewpointsHideMagicConnectorElementsButton;
    private Button fEditNameOnNewObjectButton;
    private Button[] fPasteSpecialButtons;
    private String[] PASTE_SPECIAL_BEHAVIOR = new String[]{Messages.DiagramPreferencePage_22, Messages.DiagramPreferencePage_23};
    private Button[] fResizeBehaviourButtons;
    private String[] RESIZE_BEHAVIOUR = new String[]{Messages.DiagramPreferencePage_0, Messages.DiagramPreferencePage_2};
    private Button fScaleFigureImagesButton;
    private Button fUseFigureLineOffsetButton;

    public DiagramPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Group viewGroup = new Group(client, 0);
        viewGroup.setText(Messages.DiagramPreferencePage_4);
        viewGroup.setLayout((Layout)new GridLayout(2, false));
        viewGroup.setLayoutData((Object)new GridData(768));
        new Label((Composite)viewGroup, 0).setText(Messages.DiagramPreferencePage_1);
        this.fGridSizeSpinner = new Spinner((Composite)viewGroup, 2048);
        this.fGridSizeSpinner.setMinimum(5);
        this.fGridSizeSpinner.setMaximum(100);
        new Label((Composite)viewGroup, 0).setText(Messages.DiagramPreferencePage_11);
        this.fMarginWidthSpinner = new Spinner((Composite)viewGroup, 2048);
        this.fMarginWidthSpinner.setMinimum(0);
        this.fMarginWidthSpinner.setMaximum(100);
        this.fPaletteStateButton = new Button((Composite)viewGroup, 32);
        this.fPaletteStateButton.setText(Messages.DiagramPreferencePage_6);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fPaletteStateButton);
        this.fViewTooltipsButton = new Button((Composite)viewGroup, 32);
        this.fViewTooltipsButton.setText(Messages.DiagramPreferencePage_7);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fViewTooltipsButton);
        this.fEditNameOnNewObjectButton = new Button((Composite)viewGroup, 32);
        this.fEditNameOnNewObjectButton.setText(Messages.DiagramPreferencePage_24);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fEditNameOnNewObjectButton);
        this.fShowSpecializationsPaletteButton = new Button((Composite)viewGroup, 32);
        this.fShowSpecializationsPaletteButton.setText(Messages.DiagramPreferencePage_9);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fShowSpecializationsPaletteButton);
        Group viewpointsGroup = new Group(client, 0);
        viewpointsGroup.setText(Messages.DiagramPreferencePage_13);
        viewpointsGroup.setLayout((Layout)new GridLayout(2, false));
        viewpointsGroup.setLayoutData((Object)new GridData(768));
        this.fViewpointsFilterModelTreeButton = new Button((Composite)viewpointsGroup, 32);
        this.fViewpointsFilterModelTreeButton.setText(Messages.DiagramPreferencePage_14);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fViewpointsFilterModelTreeButton);
        this.fViewpointsHidePaletteElementsButton = new Button((Composite)viewpointsGroup, 32);
        this.fViewpointsHidePaletteElementsButton.setText(Messages.DiagramPreferencePage_15);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fViewpointsHidePaletteElementsButton);
        this.fViewpointsHideMagicConnectorElementsButton = new Button((Composite)viewpointsGroup, 32);
        this.fViewpointsHideMagicConnectorElementsButton.setText(Messages.DiagramPreferencePage_16);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fViewpointsHideMagicConnectorElementsButton);
        this.fViewpointsGhostDiagramElementsButton = new Button((Composite)viewpointsGroup, 32);
        this.fViewpointsGhostDiagramElementsButton.setText(Messages.DiagramPreferencePage_17);
        GridDataFactory.create((int)768).applyTo((Control)this.fViewpointsGhostDiagramElementsButton);
        Group pasteSpecialGroup = new Group(client, 0);
        pasteSpecialGroup.setText(Messages.DiagramPreferencePage_21);
        pasteSpecialGroup.setLayout((Layout)new GridLayout());
        pasteSpecialGroup.setLayoutData((Object)new GridData(768));
        this.fPasteSpecialButtons = new Button[2];
        int i = 0;
        while (i < this.fPasteSpecialButtons.length) {
            this.fPasteSpecialButtons[i] = new Button((Composite)pasteSpecialGroup, 16);
            this.fPasteSpecialButtons[i].setText(this.PASTE_SPECIAL_BEHAVIOR[i]);
            GridDataFactory.create((int)768).applyTo((Control)this.fPasteSpecialButtons[i]);
            ++i;
        }
        Group resizeGroup = new Group(client, 0);
        resizeGroup.setText(Messages.DiagramPreferencePage_10);
        resizeGroup.setLayout((Layout)new GridLayout());
        resizeGroup.setLayoutData((Object)new GridData(768));
        this.fResizeBehaviourButtons = new Button[2];
        int i2 = 0;
        while (i2 < this.fResizeBehaviourButtons.length) {
            this.fResizeBehaviourButtons[i2] = new Button((Composite)resizeGroup, 16);
            this.fResizeBehaviourButtons[i2].setText(this.RESIZE_BEHAVIOUR[i2]);
            GridDataFactory.create((int)768).applyTo((Control)this.fResizeBehaviourButtons[i2]);
            ++i2;
        }
        Group otherGroup = new Group(client, 0);
        otherGroup.setText(Messages.DiagramPreferencePage_3);
        otherGroup.setLayout((Layout)new GridLayout(2, false));
        otherGroup.setLayoutData((Object)new GridData(768));
        this.fScaleFigureImagesButton = new Button((Composite)otherGroup, 32);
        this.fScaleFigureImagesButton.setText(Messages.DiagramPreferencePage_5);
        this.fScaleFigureImagesButton.setLayoutData((Object)this.createHorizontalGridData(2));
        this.fUseFigureLineOffsetButton = new Button((Composite)otherGroup, 32);
        this.fUseFigureLineOffsetButton.setText(Messages.DiagramPreferencePage_8);
        this.fUseFigureLineOffsetButton.setLayoutData((Object)this.createHorizontalGridData(2));
        this.setValues();
        return client;
    }

    private GridData createHorizontalGridData(int span) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        return gd;
    }

    private void setValues() {
        this.setSpinnerValues();
        this.fPaletteStateButton.setSelection(this.getPreferenceStore().getBoolean("palette_state"));
        this.fViewTooltipsButton.setSelection(this.getPreferenceStore().getBoolean("viewTooltips"));
        this.fShowSpecializationsPaletteButton.setSelection(this.getPreferenceStore().getBoolean("showSpecializationsInPalette"));
        this.fViewpointsFilterModelTreeButton.setSelection(this.getPreferenceStore().getBoolean("viewpointsFilterModelTree"));
        this.fViewpointsHidePaletteElementsButton.setSelection(this.getPreferenceStore().getBoolean("viewpointsHidePaletteElements"));
        this.fViewpointsHideMagicConnectorElementsButton.setSelection(this.getPreferenceStore().getBoolean("viewpointsHideMagicConnectorElements"));
        this.fViewpointsGhostDiagramElementsButton.setSelection(this.getPreferenceStore().getBoolean("viewpointsGhostDiagramElements"));
        this.fEditNameOnNewObjectButton.setSelection(this.getPreferenceStore().getBoolean("editNameOnNewObject"));
        int i = 0;
        while (i < this.fPasteSpecialButtons.length) {
            this.fPasteSpecialButtons[i].setSelection(this.getPreferenceStore().getInt("pasteSpecialBehavior") == i);
            ++i;
        }
        i = 0;
        while (i < this.fResizeBehaviourButtons.length) {
            this.fResizeBehaviourButtons[i].setSelection(this.getPreferenceStore().getInt("resizeBehaviour") == i);
            ++i;
        }
        this.fScaleFigureImagesButton.setSelection(this.getPreferenceStore().getBoolean("scaledImages"));
        this.fUseFigureLineOffsetButton.setSelection(this.getPreferenceStore().getBoolean("figureLineOffset"));
    }

    private void setSpinnerValues() {
        this.fGridSizeSpinner.setSelection(this.getPreferenceStore().getInt("gridSize"));
        this.fMarginWidthSpinner.setSelection(this.getPreferenceStore().getInt("marginWidth"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("gridSize", this.fGridSizeSpinner.getSelection());
        this.getPreferenceStore().setValue("marginWidth", this.fMarginWidthSpinner.getSelection());
        this.getPreferenceStore().setValue("palette_state", this.fPaletteStateButton.getSelection());
        this.getPreferenceStore().setValue("viewTooltips", this.fViewTooltipsButton.getSelection());
        this.getPreferenceStore().setValue("showSpecializationsInPalette", this.fShowSpecializationsPaletteButton.getSelection());
        this.getPreferenceStore().setValue("viewpointsFilterModelTree", this.fViewpointsFilterModelTreeButton.getSelection());
        this.getPreferenceStore().setValue("viewpointsHidePaletteElements", this.fViewpointsHidePaletteElementsButton.getSelection());
        this.getPreferenceStore().setValue("viewpointsHideMagicConnectorElements", this.fViewpointsHideMagicConnectorElementsButton.getSelection());
        this.getPreferenceStore().setValue("viewpointsGhostDiagramElements", this.fViewpointsGhostDiagramElementsButton.getSelection());
        this.getPreferenceStore().setValue("editNameOnNewObject", this.fEditNameOnNewObjectButton.getSelection());
        int i = 0;
        while (i < this.fPasteSpecialButtons.length) {
            if (this.fPasteSpecialButtons[i].getSelection()) {
                this.getPreferenceStore().setValue("pasteSpecialBehavior", i);
            }
            ++i;
        }
        i = 0;
        while (i < this.fResizeBehaviourButtons.length) {
            if (this.fResizeBehaviourButtons[i].getSelection()) {
                this.getPreferenceStore().setValue("resizeBehaviour", i);
            }
            ++i;
        }
        this.getPreferenceStore().setValue("scaledImages", this.fScaleFigureImagesButton.getSelection());
        this.getPreferenceStore().setValue("figureLineOffset", this.fUseFigureLineOffsetButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.fGridSizeSpinner.setSelection(this.getPreferenceStore().getDefaultInt("gridSize"));
        this.fMarginWidthSpinner.setSelection(this.getPreferenceStore().getDefaultInt("marginWidth"));
        this.fPaletteStateButton.setSelection(this.getPreferenceStore().getDefaultBoolean("palette_state"));
        this.fViewTooltipsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("viewTooltips"));
        this.fShowSpecializationsPaletteButton.setSelection(this.getPreferenceStore().getDefaultBoolean("showSpecializationsInPalette"));
        this.fViewpointsFilterModelTreeButton.setSelection(this.getPreferenceStore().getDefaultBoolean("viewpointsFilterModelTree"));
        this.fViewpointsHidePaletteElementsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("viewpointsHidePaletteElements"));
        this.fViewpointsHideMagicConnectorElementsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("viewpointsHideMagicConnectorElements"));
        this.fViewpointsGhostDiagramElementsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("viewpointsGhostDiagramElements"));
        this.fEditNameOnNewObjectButton.setSelection(this.getPreferenceStore().getDefaultBoolean("editNameOnNewObject"));
        int i = 0;
        while (i < this.fPasteSpecialButtons.length) {
            this.fPasteSpecialButtons[i].setSelection(this.getPreferenceStore().getDefaultInt("pasteSpecialBehavior") == i);
            ++i;
        }
        i = 0;
        while (i < this.fResizeBehaviourButtons.length) {
            this.fResizeBehaviourButtons[i].setSelection(this.getPreferenceStore().getDefaultInt("resizeBehaviour") == i);
            ++i;
        }
        this.fScaleFigureImagesButton.setSelection(this.getPreferenceStore().getDefaultBoolean("scaledImages"));
        this.fUseFigureLineOffsetButton.setSelection(this.getPreferenceStore().getDefaultBoolean("figureLineOffset"));
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

