/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.preferences.PrefUtils;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class FontsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    public static String ID = "com.archimatetool.editor.prefsFonts";
    public static String HELPID = "com.archimatetool.help.prefsAppearance";
    private TableViewer fTableViewer;
    private List<FontInfo> fontInfos = new ArrayList<FontInfo>();
    private Button fScaleFontsButton;
    private Button fEditFontButton;
    private Button fDefaultFontButton;
    private Label fDescriptionLabel;
    private Label fFontPreviewLabel;
    private IWorkbench workbench;

    public FontsPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    public Composite createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELPID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        client.addDisposeListener(e -> this.disposeLabelFont());
        if (PlatformUtils.isMac()) {
            this.fScaleFontsButton = new Button(client, 32);
            this.fScaleFontsButton.setText(Messages.FontsPreferencePage_22);
            this.fScaleFontsButton.setToolTipText(Messages.FontsPreferencePage_23);
            this.fScaleFontsButton.setSelection(this.getPreferenceStore().getBoolean("fontScaling"));
            this.fScaleFontsButton.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.fScaleFontsButton).span(2, 1).create());
            this.fScaleFontsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                this.fontInfos.get(0).performDefault();
                this.fTableViewer.setSelection(this.fTableViewer.getSelection());
            }));
        }
        this.createTable(client);
        this.createButtonPanel(client);
        this.createDescriptionPanel(client);
        this.createPreviewPanel(client);
        this.addFontOptions();
        this.fTableViewer.setInput(this.fontInfos);
        return client;
    }

    private void createTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FontsPreferencePage_21);
        label.setLayoutData((Object)GridDataFactory.create((int)0).span(2, 1).create());
        this.fTableViewer = new TableViewer(parent);
        GridDataFactory.create((int)1808).hint(-1, 200).applyTo((Control)this.fTableViewer.getTable());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FontInfo fontInfo;
                FontData fd;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && (fd = FontsPreferencePage.this.openFontDialog(fontInfo = (FontInfo)selection.getFirstElement())) != null) {
                    fontInfo.fontData = fd;
                    FontsPreferencePage.this.fTableViewer.update((Object)fontInfo, null);
                    FontsPreferencePage.this.updatePreview(fontInfo);
                }
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                FontsPreferencePage.this.fEditFontButton.setEnabled(!selection.isEmpty());
                FontsPreferencePage.this.fDefaultFontButton.setEnabled(!selection.isEmpty());
                if (!selection.isEmpty()) {
                    FontInfo fontInfo = (FontInfo)selection.getFirstElement();
                    FontsPreferencePage.this.updateDescription(fontInfo);
                    FontsPreferencePage.this.updatePreview(fontInfo);
                }
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return FontsPreferencePage.this.fontInfos.toArray();
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){
            private int tableHeight;
            private Map<FontInfo, Font> fontCache;
            {
                this.tableHeight = FontsPreferencePage.this.fTableViewer.getTable().getFont().getFontData()[0].getHeight();
                this.fontCache = new HashMap<FontInfo, Font>();
            }

            public void update(ViewerCell cell) {
                FontInfo fontInfo = (FontInfo)cell.getElement();
                cell.setText(fontInfo.text);
                cell.setImage(IArchiImages.ImageFactory.getImage("img/font.png"));
                cell.setFont(this.getFont(fontInfo));
            }

            private Font getFont(FontInfo fontInfo) {
                Font font = this.fontCache.get(fontInfo);
                if (font != null) {
                    font.dispose();
                }
                FontData fd = new FontData(fontInfo.getFontData().toString());
                fd.setHeight(this.tableHeight);
                font = new Font(null, fd);
                this.fontCache.put(fontInfo, font);
                return font;
            }

            public void dispose() {
                for (Map.Entry<FontInfo, Font> entry : this.fontCache.entrySet()) {
                    entry.getValue().dispose();
                }
                super.dispose();
            }
        });
    }

    private void createButtonPanel(Composite parent) {
        Composite buttonClient = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 128).applyTo((Control)buttonClient);
        buttonClient.setLayout((Layout)new GridLayout());
        this.fEditFontButton = new Button(buttonClient, 8);
        this.fEditFontButton.setText(Messages.FontsPreferencePage_2);
        this.setButtonLayoutData(this.fEditFontButton);
        this.fEditFontButton.setEnabled(false);
        this.fEditFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontData fd;
                IStructuredSelection selection = FontsPreferencePage.this.fTableViewer.getStructuredSelection();
                if (!selection.isEmpty() && (fd = FontsPreferencePage.this.openFontDialog((FontInfo)selection.getFirstElement())) != null) {
                    for (Object object : selection.toList()) {
                        ((FontInfo)object).fontData = fd;
                    }
                    FontsPreferencePage.this.updatePreview((FontInfo)selection.getFirstElement());
                    FontsPreferencePage.this.fTableViewer.refresh();
                }
            }
        });
        this.fDefaultFontButton = new Button(buttonClient, 8);
        this.fDefaultFontButton.setText(Messages.FontsPreferencePage_7);
        this.setButtonLayoutData(this.fDefaultFontButton);
        this.fDefaultFontButton.setEnabled(false);
        this.fDefaultFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = FontsPreferencePage.this.fTableViewer.getStructuredSelection();
                if (!selection.isEmpty()) {
                    for (Object object : selection.toList()) {
                        ((FontInfo)object).performDefault();
                    }
                    FontsPreferencePage.this.updatePreview((FontInfo)selection.getFirstElement());
                    FontsPreferencePage.this.fTableViewer.refresh();
                }
            }
        });
    }

    private void createDescriptionPanel(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.FontsPreferencePage_11);
        group.setLayout((Layout)new GridLayout());
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)group);
        this.fDescriptionLabel = new Label((Composite)group, 64);
        GridDataFactory.create((int)768).applyTo((Control)this.fDescriptionLabel);
    }

    private void updateDescription(FontInfo fontInfo) {
        this.fDescriptionLabel.setText(fontInfo.description);
    }

    private void createPreviewPanel(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.FontsPreferencePage_8);
        group.setLayout((Layout)new GridLayout());
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)group);
        this.fFontPreviewLabel = new Label((Composite)group, 0);
        GridDataFactory.create((int)768).applyTo((Control)this.fFontPreviewLabel);
    }

    private void updatePreview(FontInfo fontInfo) {
        FontData fd = fontInfo.getFontData();
        this.fFontPreviewLabel.setText(fd.getName() + " " + fd.getHeight() + " " + ((fd.getStyle() & 1) == 1 ? Messages.FontsPreferencePage_5 : "") + " " + ((fd.getStyle() & 2) == 2 ? Messages.FontsPreferencePage_6 : ""));
        Font font = new Font(null, fd);
        this.fFontPreviewLabel.setFont(font);
        this.disposeLabelFont();
        this.fFontPreviewLabel.setData((Object)font);
        GC gc = new GC((Drawable)this.getControl());
        gc.setFont(font);
        ((GridData)this.fFontPreviewLabel.getLayoutData()).heightHint = gc.getFontMetrics().getHeight();
        gc.dispose();
        this.fFontPreviewLabel.getParent().getParent().layout();
    }

    private void addFontOptions() {
        this.fontInfos.add(new ViewFontInfo());
        this.fontInfos.add(new FontInfo(Messages.FontsPreferencePage_10, Messages.FontsPreferencePage_13, "com.archimatetool.editor.SINGLE_LINE_TEXT_FONT"));
        this.fontInfos.add(new FontInfo(Messages.FontsPreferencePage_4, Messages.FontsPreferencePage_14, "com.archimatetool.editor.MULTI_LINE_TEXT_FONT"));
        this.fontInfos.add(new FontInfo(Messages.FontsPreferencePage_0, Messages.FontsPreferencePage_15, "com.archimatetool.editor.MODEL_TREE_FONT"));
        this.fontInfos.add(new FontInfo(Messages.FontsPreferencePage_9, Messages.FontsPreferencePage_16, "com.archimatetool.editor.NAVIGATOR_TREE_FONT"));
        this.fontInfos.add(new FontInfo(Messages.FontsPreferencePage_17, Messages.FontsPreferencePage_18, "com.archimatetool.editor.PROPERTIES_TABLE_FONT"));
        this.fontInfos.add(new FontInfo(Messages.FontsPreferencePage_19, Messages.FontsPreferencePage_20, "com.archimatetool.editor.ANALYSIS_TABLE_FONT"));
    }

    private FontData openFontDialog(FontInfo fontInfo) {
        FontDialog dialog = new FontDialog(this.fTableViewer.getControl().getShell());
        dialog.setEffectsVisible(false);
        dialog.setText(Messages.FontsPreferencePage_3);
        dialog.setFontList(new FontData[]{fontInfo.getFontData()});
        return dialog.open();
    }

    public void performDefaults() {
        if (this.fScaleFontsButton != null) {
            this.fScaleFontsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("fontScaling"));
        }
        for (FontInfo info : this.fontInfos) {
            info.performDefault();
        }
        this.fTableViewer.refresh();
        FontInfo fontInfo = (FontInfo)this.fTableViewer.getStructuredSelection().getFirstElement();
        if (fontInfo != null) {
            this.updatePreview((FontInfo)this.fTableViewer.getStructuredSelection().getFirstElement());
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IEventBroker eventBroker;
        if (this.fScaleFontsButton != null) {
            this.getPreferenceStore().setValue("fontScaling", this.fScaleFontsButton.getSelection());
        }
        for (FontInfo info : this.fontInfos) {
            info.performOK();
        }
        if (ThemeUtils.isCssThemingEnabled() && (eventBroker = (IEventBroker)this.workbench.getService(IEventBroker.class)) != null) {
            eventBroker.send("org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryModified", null);
        }
        PrefUtils.savePrefs();
        return true;
    }

    private void disposeLabelFont() {
        Font labelFont = (Font)this.fFontPreviewLabel.getData();
        if (labelFont != null) {
            labelFont.dispose();
        }
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    private class FontInfo {
        String fontDefinitionId;
        String text;
        String description;
        FontData fontData;

        FontInfo(String text, String description, String fontDefinitionId) {
            this.text = text;
            this.description = description;
            this.fontDefinitionId = fontDefinitionId;
        }

        void performDefault() {
            this.fontData = this.getDefaultFontData();
        }

        FontData getFontData() {
            if (this.fontData == null) {
                this.fontData = ThemeUtils.getCurrentThemeFontData(this.fontDefinitionId);
                if (this.fontData == null) {
                    this.fontData = this.getDefaultFontData();
                }
            }
            return this.fontData;
        }

        FontData getDefaultFontData() {
            FontData fontData = ThemeUtils.getDefaultThemeFontData(this.fontDefinitionId);
            return fontData != null ? fontData : this.getSystemFontData();
        }

        void performOK() {
            ThemeUtils.setCurrentThemeFont(this.fontDefinitionId, this.getFontData(), this.getSystemFontData());
        }

        FontData getSystemFontData() {
            return FontsPreferencePage.this.getShell().getDisplay().getSystemFont().getFontData()[0];
        }

        FontData getSafeFontData(String fontDetails) {
            try {
                return new FontData(fontDetails);
            }
            catch (Exception exception) {
                return this.getSystemFontData();
            }
        }
    }

    private class ViewFontInfo
    extends FontInfo {
        public ViewFontInfo() {
            super(Messages.FontsPreferencePage_1, Messages.FontsPreferencePage_12, "defaultViewFont");
        }

        @Override
        void performDefault() {
            if (FontsPreferencePage.this.fScaleFontsButton != null) {
                boolean currentValue = FontsPreferencePage.this.getPreferenceStore().getBoolean("fontScaling");
                FontsPreferencePage.this.getPreferenceStore().setValue("fontScaling", FontsPreferencePage.this.fScaleFontsButton.getSelection());
                this.fontData = this.getDefaultFontData();
                FontsPreferencePage.this.getPreferenceStore().setValue("fontScaling", currentValue);
            } else {
                this.fontData = this.getDefaultFontData();
            }
        }

        @Override
        FontData getFontData() {
            if (this.fontData == null) {
                String fontDetails = FontsPreferencePage.this.getPreferenceStore().getString(this.fontDefinitionId);
                this.fontData = StringUtils.isSet(fontDetails) ? this.getSafeFontData(fontDetails) : this.getDefaultFontData();
            }
            return this.fontData;
        }

        @Override
        FontData getDefaultFontData() {
            String fontDetails = FontsPreferencePage.this.getPreferenceStore().getDefaultString(this.fontDefinitionId);
            if (StringUtils.isSet(fontDetails)) {
                return this.getSafeFontData(fontDetails);
            }
            return this.getSystemFontData();
        }

        @Override
        void performOK() {
            FontFactory.setDefaultUserViewFont(this.getFontData());
        }

        @Override
        FontData getSystemFontData() {
            return FontFactory.getDefaultViewOSFontData();
        }
    }
}

