/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.util.AnimationUtil;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class GeneralPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsGeneral";
    private Button fOpenDiagramsOnLoadButton;
    private Button fBackupOnSaveButton;
    private Spinner fMRUSizeSpinner;
    private Button fShowUnusedElementsInModelTreeButton;
    private Button fAutoSearchButton;
    private Button fWarnOnDeleteButton;
    private Button fShowSpecializationsModelTreeButton;
    private Text fTreeDisplayIncrementText;
    private Button fAddDocumentationNoteButton;
    private Button fScaleImagesButton;
    private Button fUseEdgeBrowserButton;
    private Button fEnableJSHintsButton;
    private Button fEnableExternalHostsHintsButton;
    private Button fUseLabelExpressionsButton;
    private Button fDoAnimationViewButton;
    private Spinner fAnimationViewTimeSpinner;
    private Button fAnimateVisualiserNodesButton;
    private Spinner fAnimationVisualiserTimeSpinner;

    public GeneralPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(client);
        Group fileGroup = new Group(client, 0);
        fileGroup.setText(Messages.GeneralPreferencePage_0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)fileGroup);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)fileGroup);
        this.fOpenDiagramsOnLoadButton = new Button((Composite)fileGroup, 32);
        this.fOpenDiagramsOnLoadButton.setText(Messages.GeneralPreferencePage_1);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fOpenDiagramsOnLoadButton);
        this.fBackupOnSaveButton = new Button((Composite)fileGroup, 32);
        this.fBackupOnSaveButton.setText(Messages.GeneralPreferencePage_5);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fBackupOnSaveButton);
        Label label = new Label((Composite)fileGroup, 0);
        label.setText(Messages.GeneralPreferencePage_2);
        this.fMRUSizeSpinner = new Spinner((Composite)fileGroup, 2048);
        this.fMRUSizeSpinner.setMinimum(3);
        this.fMRUSizeSpinner.setMaximum(15);
        Group modelTreeGroup = new Group(client, 0);
        modelTreeGroup.setText(Messages.GeneralPreferencePage_10);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)modelTreeGroup);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)modelTreeGroup);
        this.fShowUnusedElementsInModelTreeButton = new Button((Composite)modelTreeGroup, 32);
        this.fShowUnusedElementsInModelTreeButton.setText(Messages.GeneralPreferencePage_11);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fShowUnusedElementsInModelTreeButton);
        this.fAutoSearchButton = new Button((Composite)modelTreeGroup, 32);
        this.fAutoSearchButton.setText(Messages.GeneralPreferencePage_6);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fAutoSearchButton);
        this.fAutoSearchButton.setToolTipText(Messages.GeneralPreferencePage_7);
        this.fWarnOnDeleteButton = new Button((Composite)modelTreeGroup, 32);
        this.fWarnOnDeleteButton.setText(Messages.GeneralPreferencePage_16);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fWarnOnDeleteButton);
        this.fShowSpecializationsModelTreeButton = new Button((Composite)modelTreeGroup, 32);
        this.fShowSpecializationsModelTreeButton.setText(Messages.GeneralPreferencePage_24);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fShowSpecializationsModelTreeButton);
        label = new Label((Composite)modelTreeGroup, 0);
        label.setText(Messages.GeneralPreferencePage_25);
        this.fTreeDisplayIncrementText = UIUtils.createSingleTextControl((Composite)modelTreeGroup, 2048, false);
        GridDataFactory.create((int)768).span(1, 1).applyTo((Control)this.fTreeDisplayIncrementText);
        UIUtils.applyNumberVerifyListener(this.fTreeDisplayIncrementText, 0, 1000000);
        Group expressionsGroup = new Group(client, 0);
        expressionsGroup.setText(Messages.GeneralPreferencePage_17);
        GridLayoutFactory.swtDefaults().applyTo((Composite)expressionsGroup);
        GridDataFactory.create((int)768).applyTo((Control)expressionsGroup);
        this.fUseLabelExpressionsButton = new Button((Composite)expressionsGroup, 32);
        this.fUseLabelExpressionsButton.setText(Messages.GeneralPreferencePage_18);
        Group otherGroup = new Group(client, 0);
        otherGroup.setText(Messages.GeneralPreferencePage_12);
        GridLayoutFactory.swtDefaults().applyTo((Composite)otherGroup);
        GridDataFactory.create((int)768).applyTo((Control)otherGroup);
        this.fAddDocumentationNoteButton = new Button((Composite)otherGroup, 32);
        this.fAddDocumentationNoteButton.setText(Messages.GeneralPreferencePage_20);
        this.fAddDocumentationNoteButton.setToolTipText(Messages.GeneralPreferencePage_23);
        this.fScaleImagesButton = new Button((Composite)otherGroup, 32);
        this.fScaleImagesButton.setText(Messages.GeneralPreferencePage_13);
        this.fScaleImagesButton.setToolTipText(Messages.GeneralPreferencePage_14);
        Group browserGroup = new Group(client, 0);
        browserGroup.setText(Messages.GeneralPreferencePage_19);
        GridLayoutFactory.swtDefaults().applyTo((Composite)browserGroup);
        GridDataFactory.create((int)768).applyTo((Control)browserGroup);
        if (PlatformUtils.isWindows()) {
            this.fUseEdgeBrowserButton = new Button((Composite)browserGroup, 32);
            this.fUseEdgeBrowserButton.setText(Messages.GeneralPreferencePage_15);
        }
        this.fEnableJSHintsButton = new Button((Composite)browserGroup, 32);
        this.fEnableJSHintsButton.setText(Messages.GeneralPreferencePage_21);
        this.fEnableExternalHostsHintsButton = new Button((Composite)browserGroup, 32);
        this.fEnableExternalHostsHintsButton.setText(Messages.GeneralPreferencePage_22);
        if (AnimationUtil.supportsAnimation()) {
            Group animationGroup = new Group(client, 0);
            animationGroup.setText(Messages.GeneralPreferencePage_3);
            GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(true).applyTo((Composite)animationGroup);
            GridDataFactory.create((int)768).applyTo((Control)animationGroup);
            this.fDoAnimationViewButton = new Button((Composite)animationGroup, 32);
            this.fDoAnimationViewButton.setText(Messages.GeneralPreferencePage_4);
            GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fDoAnimationViewButton);
            label = new Label((Composite)animationGroup, 0);
            label.setText(Messages.GeneralPreferencePage_8);
            this.fAnimationViewTimeSpinner = new Spinner((Composite)animationGroup, 2048);
            this.fAnimationViewTimeSpinner.setMinimum(10);
            this.fAnimationViewTimeSpinner.setMaximum(500);
            this.fAnimateVisualiserNodesButton = new Button((Composite)animationGroup, 32);
            this.fAnimateVisualiserNodesButton.setText(Messages.GeneralPreferencePage_9);
            GridDataFactory.create((int)768).span(2, 1).applyTo((Control)this.fAnimateVisualiserNodesButton);
            label = new Label((Composite)animationGroup, 0);
            label.setText(Messages.GeneralPreferencePage_8);
            this.fAnimationVisualiserTimeSpinner = new Spinner((Composite)animationGroup, 2048);
            this.fAnimationVisualiserTimeSpinner.setMinimum(10);
            this.fAnimationVisualiserTimeSpinner.setMaximum(500);
        }
        this.setValues();
        return client;
    }

    private void setValues() {
        this.fMRUSizeSpinner.setSelection(this.getPreferenceStore().getInt("mruMax"));
        this.fBackupOnSaveButton.setSelection(this.getPreferenceStore().getBoolean("backupOnSave"));
        this.fOpenDiagramsOnLoadButton.setSelection(this.getPreferenceStore().getBoolean("openDiagramsOnLoad"));
        this.fShowUnusedElementsInModelTreeButton.setSelection(this.getPreferenceStore().getBoolean("highlightUnusedElementsInModelTree"));
        this.fAutoSearchButton.setSelection(this.getPreferenceStore().getBoolean("treeSearchAuto"));
        this.fWarnOnDeleteButton.setSelection(this.getPreferenceStore().getBoolean("showWarningOnDeleteFromTree"));
        this.fShowSpecializationsModelTreeButton.setSelection(this.getPreferenceStore().getBoolean("showSpecializationsInModelTree"));
        this.fTreeDisplayIncrementText.setText(Integer.toString(this.getPreferenceStore().getInt("treeDisplayNodeIncrement")));
        this.fUseLabelExpressionsButton.setSelection(this.getPreferenceStore().getBoolean("useLabelExpressionInAnalysisTable"));
        this.fScaleImagesButton.setSelection(this.getPreferenceStore().getBoolean("scaleImageExport"));
        this.fAddDocumentationNoteButton.setSelection(this.getPreferenceStore().getBoolean("addDocumentationNoteOnRelationChange"));
        if (this.fUseEdgeBrowserButton != null) {
            this.fUseEdgeBrowserButton.setSelection(this.getPreferenceStore().getBoolean("edgeBrowser"));
        }
        this.fEnableJSHintsButton.setSelection(this.getPreferenceStore().getBoolean("hintsJSEnabled"));
        this.fEnableExternalHostsHintsButton.setSelection(this.getPreferenceStore().getBoolean("hintsExternalHostsEnabled"));
        if (AnimationUtil.supportsAnimation()) {
            this.fDoAnimationViewButton.setSelection(this.getPreferenceStore().getBoolean("animateView"));
            this.fAnimationViewTimeSpinner.setSelection(this.getPreferenceStore().getInt("animationViewTime"));
            this.fAnimateVisualiserNodesButton.setSelection(this.getPreferenceStore().getBoolean("animateVisualiserNodes"));
            this.fAnimationVisualiserTimeSpinner.setSelection(this.getPreferenceStore().getInt("animationVisualiserTime"));
        }
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("backupOnSave", this.fBackupOnSaveButton.getSelection());
        this.getPreferenceStore().setValue("openDiagramsOnLoad", this.fOpenDiagramsOnLoadButton.getSelection());
        this.getPreferenceStore().setValue("mruMax", this.fMRUSizeSpinner.getSelection());
        this.getPreferenceStore().setValue("highlightUnusedElementsInModelTree", this.fShowUnusedElementsInModelTreeButton.getSelection());
        this.getPreferenceStore().setValue("treeSearchAuto", this.fAutoSearchButton.getSelection());
        this.getPreferenceStore().setValue("showWarningOnDeleteFromTree", this.fWarnOnDeleteButton.getSelection());
        this.getPreferenceStore().setValue("showSpecializationsInModelTree", this.fShowSpecializationsModelTreeButton.getSelection());
        this.getPreferenceStore().setValue("treeDisplayNodeIncrement", this.fTreeDisplayIncrementText.getText());
        this.getPreferenceStore().setValue("useLabelExpressionInAnalysisTable", this.fUseLabelExpressionsButton.getSelection());
        this.getPreferenceStore().setValue("scaleImageExport", this.fScaleImagesButton.getSelection());
        this.getPreferenceStore().setValue("addDocumentationNoteOnRelationChange", this.fAddDocumentationNoteButton.getSelection());
        if (this.fUseEdgeBrowserButton != null) {
            this.getPreferenceStore().setValue("edgeBrowser", this.fUseEdgeBrowserButton.getSelection());
        }
        this.getPreferenceStore().setValue("hintsJSEnabled", this.fEnableJSHintsButton.getSelection());
        this.getPreferenceStore().setValue("hintsExternalHostsEnabled", this.fEnableExternalHostsHintsButton.getSelection());
        if (AnimationUtil.supportsAnimation()) {
            this.getPreferenceStore().setValue("animateView", this.fDoAnimationViewButton.getSelection());
            this.getPreferenceStore().setValue("animationViewTime", this.fAnimationViewTimeSpinner.getSelection());
            this.getPreferenceStore().setValue("animateVisualiserNodes", this.fAnimateVisualiserNodesButton.getSelection());
            this.getPreferenceStore().setValue("animationVisualiserTime", this.fAnimationVisualiserTimeSpinner.getSelection());
        }
        return true;
    }

    protected void performDefaults() {
        this.fBackupOnSaveButton.setSelection(this.getPreferenceStore().getDefaultBoolean("backupOnSave"));
        this.fOpenDiagramsOnLoadButton.setSelection(this.getPreferenceStore().getDefaultBoolean("openDiagramsOnLoad"));
        this.fMRUSizeSpinner.setSelection(this.getPreferenceStore().getDefaultInt("mruMax"));
        this.fShowUnusedElementsInModelTreeButton.setSelection(this.getPreferenceStore().getDefaultBoolean("highlightUnusedElementsInModelTree"));
        this.fAutoSearchButton.setSelection(this.getPreferenceStore().getDefaultBoolean("treeSearchAuto"));
        this.fWarnOnDeleteButton.setSelection(this.getPreferenceStore().getDefaultBoolean("showWarningOnDeleteFromTree"));
        this.fShowSpecializationsModelTreeButton.setSelection(this.getPreferenceStore().getDefaultBoolean("showSpecializationsInModelTree"));
        this.fTreeDisplayIncrementText.setText(Integer.toString(this.getPreferenceStore().getDefaultInt("treeDisplayNodeIncrement")));
        this.fUseLabelExpressionsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("useLabelExpressionInAnalysisTable"));
        this.fScaleImagesButton.setSelection(this.getPreferenceStore().getDefaultBoolean("scaleImageExport"));
        this.fAddDocumentationNoteButton.setSelection(this.getPreferenceStore().getDefaultBoolean("addDocumentationNoteOnRelationChange"));
        if (this.fUseEdgeBrowserButton != null) {
            this.fUseEdgeBrowserButton.setSelection(this.getPreferenceStore().getDefaultBoolean("edgeBrowser"));
        }
        this.fEnableJSHintsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("hintsJSEnabled"));
        this.fEnableExternalHostsHintsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("hintsExternalHostsEnabled"));
        if (AnimationUtil.supportsAnimation()) {
            this.fDoAnimationViewButton.setSelection(this.getPreferenceStore().getDefaultBoolean("animateView"));
            this.fAnimationViewTimeSpinner.setSelection(this.getPreferenceStore().getDefaultInt("animationViewTime"));
            this.fAnimateVisualiserNodesButton.setSelection(this.getPreferenceStore().getDefaultBoolean("animateVisualiserNodes"));
            this.fAnimationVisualiserTimeSpinner.setSelection(this.getPreferenceStore().getDefaultInt("animationVisualiserTime"));
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

