/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.SecureStorageUtils;
import java.io.IOException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class NetworkConnectionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static final String HELP_ID = "com.archimatetool.help.prefsNetwork";
    private Button fUseProxyButton;
    private Button fRequiresProxyAuthenticationButton;
    private Text fProxyHostTextField;
    private Text fProxyPortTextField;
    private Text fProxyUserNameTextField;
    private Text fProxyUserPasswordTextField;
    private boolean proxyPasswordChanged;
    private boolean proxyUserNameChanged;

    public NetworkConnectionsPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Group proxyGroup = new Group(client, 0);
        proxyGroup.setText(Messages.NetworkConnectionsPreferencePage_0);
        proxyGroup.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.create((int)768).applyTo((Control)proxyGroup);
        this.fUseProxyButton = new Button((Composite)proxyGroup, 32);
        this.fUseProxyButton.setText(Messages.NetworkConnectionsPreferencePage_1);
        GridDataFactory.create((int)768).span(4, 1).applyTo((Control)this.fUseProxyButton);
        this.fUseProxyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkConnectionsPreferencePage.this.updateProxyControls();
            }
        });
        new Label((Composite)proxyGroup, 0).setText(Messages.NetworkConnectionsPreferencePage_2);
        this.fProxyHostTextField = UIUtils.createSingleTextControl((Composite)proxyGroup, 2048, false);
        this.fProxyHostTextField.setLayoutData((Object)new GridData(768));
        this.fProxyHostTextField.setEnabled(false);
        new Label((Composite)proxyGroup, 0).setText(Messages.NetworkConnectionsPreferencePage_3);
        this.fProxyPortTextField = UIUtils.createSingleTextControl((Composite)proxyGroup, 2048, false);
        this.fProxyPortTextField.setLayoutData((Object)new GridData(768));
        this.fProxyPortTextField.setEnabled(false);
        this.fProxyPortTextField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                block3: {
                    String currentText = ((Text)e.widget).getText();
                    String port = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
                    try {
                        int portNum = Integer.valueOf(port);
                        if (portNum < 0 || portNum > 65535) {
                            e.doit = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (port.equals("")) break block3;
                        e.doit = false;
                    }
                }
            }
        });
        this.fRequiresProxyAuthenticationButton = new Button((Composite)proxyGroup, 32);
        this.fRequiresProxyAuthenticationButton.setText(Messages.NetworkConnectionsPreferencePage_4);
        GridDataFactory.create((int)768).span(4, 1).applyTo((Control)this.fRequiresProxyAuthenticationButton);
        this.fRequiresProxyAuthenticationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkConnectionsPreferencePage.this.updateProxyControls();
            }
        });
        new Label((Composite)proxyGroup, 0).setText(Messages.NetworkConnectionsPreferencePage_5);
        this.fProxyUserNameTextField = UIUtils.createSingleTextControl((Composite)proxyGroup, 2048, false);
        this.fProxyUserNameTextField.setLayoutData((Object)new GridData(768));
        this.fProxyUserNameTextField.setEnabled(false);
        new Label((Composite)proxyGroup, 0).setText(Messages.NetworkConnectionsPreferencePage_6);
        this.fProxyUserPasswordTextField = UIUtils.createSingleTextControl((Composite)proxyGroup, 0x400800, false);
        this.fProxyUserPasswordTextField.setLayoutData((Object)new GridData(768));
        this.fProxyUserPasswordTextField.setEnabled(false);
        this.setValues();
        return client;
    }

    private void setValues() {
        this.fUseProxyButton.setSelection(this.getPreferenceStore().getBoolean("proxyEnabled"));
        this.fProxyHostTextField.setText(this.getPreferenceStore().getString("proxyHost"));
        this.fProxyPortTextField.setText(this.getPreferenceStore().getString("proxyPort"));
        this.fRequiresProxyAuthenticationButton.setSelection(this.getPreferenceStore().getBoolean("proxyAuthenticate"));
        try {
            ISecurePreferences archiNode = SecurePreferencesFactory.getDefault().node("com.archimatetool.editor");
            this.fProxyUserNameTextField.setText(archiNode.get("proxyUserName", ""));
            this.fProxyUserPasswordTextField.setText(archiNode.get("proxyPassword", "").isEmpty() ? "" : "********");
        }
        catch (StorageException ex) {
            ex.printStackTrace();
            this.showErrorDialog((Object)ex);
        }
        this.fProxyUserNameTextField.addModifyListener(event -> {
            this.proxyUserNameChanged = true;
        });
        this.fProxyUserPasswordTextField.addModifyListener(event -> {
            this.proxyPasswordChanged = true;
        });
        this.updateProxyControls();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("proxyEnabled", this.fUseProxyButton.getSelection());
        this.getPreferenceStore().setValue("proxyHost", this.fProxyHostTextField.getText());
        this.getPreferenceStore().setValue("proxyPort", this.fProxyPortTextField.getText());
        this.getPreferenceStore().setValue("proxyAuthenticate", this.fRequiresProxyAuthenticationButton.getSelection());
        try {
            ISecurePreferences archiNode;
            if (this.proxyUserNameChanged) {
                archiNode = SecureStorageUtils.getSecurePreferences(ArchiPlugin.getInstance().getBundle());
                SecureStorageUtils.putOrRemove(archiNode, "proxyUserName", this.fProxyUserNameTextField.getText(), true);
            }
            if (this.proxyPasswordChanged) {
                archiNode = SecureStorageUtils.getSecurePreferences(ArchiPlugin.getInstance().getBundle());
                SecureStorageUtils.putOrRemove(archiNode, "proxyPassword", this.fProxyUserPasswordTextField.getText(), true);
            }
        }
        catch (IOException | StorageException ex) {
            ex.printStackTrace();
            this.showErrorDialog(ex);
        }
        return true;
    }

    protected void performDefaults() {
        this.fUseProxyButton.setSelection(this.getPreferenceStore().getDefaultBoolean("proxyEnabled"));
        this.fProxyHostTextField.setText(this.getPreferenceStore().getDefaultString("proxyHost"));
        this.fProxyPortTextField.setText(this.getPreferenceStore().getDefaultString("proxyPort"));
        this.fRequiresProxyAuthenticationButton.setSelection(this.getPreferenceStore().getDefaultBoolean("proxyAuthenticate"));
        this.updateProxyControls();
        super.performDefaults();
    }

    private void updateProxyControls() {
        this.fProxyHostTextField.setEnabled(this.fUseProxyButton.getSelection());
        this.fProxyPortTextField.setEnabled(this.fUseProxyButton.getSelection());
        this.fRequiresProxyAuthenticationButton.setEnabled(this.fUseProxyButton.getSelection());
        this.fProxyUserNameTextField.setEnabled(this.fUseProxyButton.getSelection() && this.fRequiresProxyAuthenticationButton.getSelection());
        this.fProxyUserPasswordTextField.setEnabled(this.fUseProxyButton.getSelection() && this.fRequiresProxyAuthenticationButton.getSelection());
    }

    public void init(IWorkbench workbench) {
    }

    private void showErrorDialog(Object obj) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.NetworkConnectionsPreferencePage_7, (String)obj.toString());
    }
}

