/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.propertysections.AbstractArchiPropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.PropertySectionTextControl;
import com.archimatetool.editor.ui.components.StyledTextControl;
import com.archimatetool.model.IAdapter;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.ILockable;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractECorePropertySection
extends AbstractArchiPropertySection {
    protected boolean fIsExecutingCommand;
    private List<IArchimateModelObject> fObjects;
    private LightweightEContentAdapter eAdapter = new LightweightEContentAdapter(this::notifyChanged, new Class[]{IFeature.class});

    @Override
    protected void handleSelection(IStructuredSelection selection) {
        if (selection != this.getSelection()) {
            this.removeAdapter();
            this.fObjects = this.getFilteredObjects(selection.toList());
            this.update();
            this.addAdapter();
        }
    }

    protected abstract void update();

    protected void notifyChanged(Notification msg) {
        if (msg.getFeature() == IArchimatePackage.Literals.NAMEABLE__NAME && msg.getNotifier() == this.getFirstSelectedObject()) {
            this.updatePropertiesLabel();
        }
    }

    protected List<IArchimateModelObject> getEObjects() {
        return this.fObjects;
    }

    protected IArchimateModelObject getFirstSelectedObject() {
        return this.fObjects == null || this.fObjects.isEmpty() ? null : this.fObjects.get(0);
    }

    private List<IArchimateModelObject> getFilteredObjects(List<?> objects) {
        ArrayList<IArchimateModelObject> list = new ArrayList<IArchimateModelObject>();
        IObjectFilter filter = this.getFilter();
        for (Object object : objects) {
            if (filter != null) {
                object = filter.adaptObject(object);
            }
            if (!(object instanceof IArchimateModelObject)) continue;
            list.add((IArchimateModelObject)object);
        }
        if (!list.isEmpty()) {
            IArchimateModel firstModel = list.get(0).getArchimateModel();
            int i = list.size() - 1;
            while (i >= 1) {
                IArchimateModelObject eObject = list.get(i);
                if (eObject.getArchimateModel() != firstModel) {
                    list.remove(eObject);
                }
                --i;
            }
        }
        return list;
    }

    protected IObjectFilter getFilter() {
        return null;
    }

    protected void executeCommand(Command command) {
        CommandStack commandStack;
        this.fIsExecutingCommand = true;
        IArchimateModelObject eObject = this.getFirstSelectedObject();
        if (eObject != null && eObject instanceof IAdapter && (commandStack = (CommandStack)((IAdapter)eObject).getAdapter(CommandStack.class)) != null) {
            commandStack.execute(command);
        }
        this.fIsExecutingCommand = false;
    }

    protected boolean isAlive(EObject eObject) {
        return eObject != null && (eObject instanceof IArchimateModel || eObject.eContainer() != null);
    }

    protected void addAdapter() {
        IArchimateModelObject selected = this.getFirstSelectedObject();
        Adapter adapter = this.getECoreAdapter();
        if (selected != null && adapter != null && !selected.eAdapters().contains((Object)adapter)) {
            selected.eAdapters().add((Object)adapter);
        }
    }

    protected void removeAdapter() {
        IArchimateModelObject selected = this.getFirstSelectedObject();
        Adapter adapter = this.getECoreAdapter();
        if (selected != null && adapter != null) {
            selected.eAdapters().remove((Object)adapter);
        }
    }

    protected Adapter getECoreAdapter() {
        return this.eAdapter;
    }

    protected boolean isFeatureNotification(Notification msg, String name) {
        return IFeatures.isFeatureNotification((Notification)msg, (String)name);
    }

    protected boolean isLocked(Object object) {
        return object instanceof ILockable && ((ILockable)object).isLocked();
    }

    public void dispose() {
        this.removeAdapter();
        this.fObjects = null;
    }

    protected PropertySectionTextControl createNameControl(Composite parent, String hint) {
        this.createLabel(parent, Messages.AbstractECorePropertySection_0, 115, 0x1000000);
        Text textControl = this.createSingleTextControl(parent, 0);
        textControl.setMessage(hint);
        PropertySectionTextControl textName = new PropertySectionTextControl((Control)textControl, IArchimatePackage.Literals.NAMEABLE__NAME){

            @Override
            protected void textChanged(String oldText, String newText) {
                if (AbstractECorePropertySection.this.fObjects != null) {
                    NonNotifyingCompoundCommand result = new NonNotifyingCompoundCommand(Messages.AbstractECorePropertySection_1);
                    for (EObject eObject : AbstractECorePropertySection.this.fObjects) {
                        EObjectFeatureCommand cmd;
                        if (!AbstractECorePropertySection.this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(Messages.AbstractECorePropertySection_1, eObject, (EStructuralFeature)IArchimatePackage.Literals.NAMEABLE__NAME, newText)).canExecute()) continue;
                        result.add(cmd);
                    }
                    AbstractECorePropertySection.this.executeCommand(result.unwrap());
                }
            }
        };
        return textName;
    }

    protected PropertySectionTextControl createDocumentationControl(Composite parent, String hint) {
        this.createLabel(parent, Messages.AbstractECorePropertySection_2, 115, 0);
        StyledTextControl styledTextControl = this.createStyledTextControl(parent, 0);
        styledTextControl.setMessage(hint);
        PropertySectionTextControl textDoc = new PropertySectionTextControl((Control)styledTextControl.getControl(), IArchimatePackage.Literals.DOCUMENTABLE__DOCUMENTATION){

            @Override
            protected void textChanged(String oldText, String newText) {
                if (AbstractECorePropertySection.this.fObjects != null) {
                    CompoundCommand result = new CompoundCommand(Messages.AbstractECorePropertySection_3);
                    for (EObject eObject : AbstractECorePropertySection.this.fObjects) {
                        EObjectFeatureCommand cmd;
                        if (!AbstractECorePropertySection.this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(Messages.AbstractECorePropertySection_3, eObject, (EStructuralFeature)IArchimatePackage.Literals.DOCUMENTABLE__DOCUMENTATION, newText)).canExecute()) continue;
                        result.add((Command)cmd);
                    }
                    AbstractECorePropertySection.this.executeCommand(result.unwrap());
                }
            }
        };
        return textDoc;
    }
}

