/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.ConnectionLineTypeCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelConnection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class DiagramConnectionLineStyleSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private StyleSelector fLineStyleSelector;
    private StyleSelector fSourceArrowSelector;
    private StyleSelector fTargetArrowSelector;

    @Override
    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.DiagramConnectionLineStyleSection_0, 115, 0x1000000);
        Composite client = this.createComposite(parent, 3);
        this.fSourceArrowSelector = new SourceArrowSelector(client);
        this.fLineStyleSelector = new LineStyleSelector(client);
        this.fTargetArrowSelector = new TargetArrowSelector(client);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    protected int getLineTypeValue() {
        int value = 0;
        value |= this.fLineStyleSelector.getValue();
        value |= this.fSourceArrowSelector.getValue();
        return value |= this.fTargetArrowSelector.getValue();
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL_CONNECTION__TYPE || feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        this.fLineStyleSelector.update();
        this.fSourceArrowSelector.update();
        this.fTargetArrowSelector.update();
        boolean enabled = !this.isLocked(this.getFirstSelectedObject());
        this.fLineStyleSelector.setEnabled(enabled);
        this.fSourceArrowSelector.setEnabled(enabled);
        this.fTargetArrowSelector.setEnabled(enabled);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IDiagramModelConnection && !(object instanceof IDiagramModelArchimateConnection);
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelConnection.class;
        }
    }

    protected class LineStyleSelector
    extends StyleSelector {
        public LineStyleSelector(Composite parent) {
            super(parent, Messages.DiagramConnectionLineStyleSection_1);
        }

        @Override
        protected void addActions(MenuManager menuManager) {
            IAction action = this.createAction(Messages.DiagramConnectionLineStyleSection_2, 0, IArchiImages.ImageFactory.getImageDescriptor("img/line-solid.png"));
            menuManager.add(action);
            IDiagramModelConnection lastSelectedConnection = (IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject();
            action.setChecked((lastSelectedConnection.getType() & 2) == 0 & (lastSelectedConnection.getType() & 4) == 0);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_3, 2, IArchiImages.ImageFactory.getImageDescriptor("img/line-dashed.png"));
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_4, 4, IArchiImages.ImageFactory.getImageDescriptor("img/line-dotted.png"));
            menuManager.add(action);
        }

        @Override
        protected void update() {
            int connectionType = ((IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject()).getType();
            if ((connectionType & 2) != 0) {
                this.fValue = 2;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/line-dashed.png"));
            } else if ((connectionType & 4) != 0) {
                this.fValue = 4;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/line-dotted.png"));
            } else {
                this.fValue = 0;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/line-solid.png"));
            }
        }
    }

    protected class SourceArrowSelector
    extends StyleSelector {
        public SourceArrowSelector(Composite parent) {
            super(parent, Messages.DiagramConnectionLineStyleSection_5);
        }

        @Override
        protected void addActions(MenuManager menuManager) {
            IDiagramModelConnection lastSelectedConnection = (IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject();
            IAction action = this.createAction(Messages.DiagramConnectionLineStyleSection_6, 0, IArchiImages.ImageFactory.getImageDescriptor("img/line-solid.png"));
            action.setChecked((lastSelectedConnection.getType() & 8) == 0 & (lastSelectedConnection.getType() & 0x20) == 0 & (lastSelectedConnection.getType() & 0x80) == 0);
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_7, 8, IArchiImages.ImageFactory.getImageDescriptor("img/arrow-source-fill.png"));
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_8, 32, IArchiImages.ImageFactory.getImageDescriptor("img/arrow-source-hollow.png"));
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_9, 128, IArchiImages.ImageFactory.getImageDescriptor("img/arrow-source-line.png"));
            menuManager.add(action);
        }

        @Override
        protected void update() {
            int connectionType = ((IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject()).getType();
            if ((connectionType & 8) != 0) {
                this.fValue = 8;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/arrow-source-fill.png"));
            } else if ((connectionType & 0x20) != 0) {
                this.fValue = 32;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/arrow-source-hollow.png"));
            } else if ((connectionType & 0x80) != 0) {
                this.fValue = 128;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/arrow-source-line.png"));
            } else {
                this.fValue = 0;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/line-solid.png"));
            }
        }
    }

    protected abstract class StyleSelector {
        protected Button fButton;
        protected int fValue = 0;

        public StyleSelector(Composite parent, String buttonText) {
            this.fButton = DiagramConnectionLineStyleSection.this.getWidgetFactory().createButton(parent, null, 8);
            this.fButton.setToolTipText(buttonText);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuManager menuManager = new MenuManager();
                    StyleSelector.this.addActions(menuManager);
                    Menu menu = menuManager.createContextMenu((Control)StyleSelector.this.fButton.getShell());
                    Point p = StyleSelector.this.fButton.getParent().toDisplay(StyleSelector.this.fButton.getBounds().x, StyleSelector.this.fButton.getBounds().y + StyleSelector.this.fButton.getBounds().height);
                    menu.setLocation(p);
                    menu.setVisible(true);
                }
            });
        }

        public void setEnabled(boolean enabled) {
            this.fButton.setEnabled(enabled);
        }

        protected IAction createAction(String text, final int value, final ImageDescriptor imageDesc) {
            Action action = new Action(text, 8){

                public void run() {
                    StyleSelector.this.fValue = value;
                    CompoundCommand result = new CompoundCommand();
                    for (EObject eObject : DiagramConnectionLineStyleSection.this.getEObjects()) {
                        ConnectionLineTypeCommand cmd;
                        if (!DiagramConnectionLineStyleSection.this.isAlive(eObject) || !(cmd = new ConnectionLineTypeCommand((IDiagramModelConnection)eObject, DiagramConnectionLineStyleSection.this.getLineTypeValue())).canExecute()) continue;
                        result.add((Command)cmd);
                    }
                    DiagramConnectionLineStyleSection.this.executeCommand(result.unwrap());
                }

                public ImageDescriptor getImageDescriptor() {
                    return imageDesc;
                }
            };
            action.setChecked((((IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject()).getType() & value) != 0);
            return action;
        }

        public int getValue() {
            return this.fValue;
        }

        protected abstract void addActions(MenuManager var1);

        protected abstract void update();
    }

    protected class TargetArrowSelector
    extends StyleSelector {
        public TargetArrowSelector(Composite parent) {
            super(parent, Messages.DiagramConnectionLineStyleSection_10);
        }

        @Override
        protected void addActions(MenuManager menuManager) {
            IDiagramModelConnection lastSelectedConnection = (IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject();
            IAction action = this.createAction(Messages.DiagramConnectionLineStyleSection_11, 0, IArchiImages.ImageFactory.getImageDescriptor("img/line-solid.png"));
            action.setChecked((lastSelectedConnection.getType() & 1) == 0 & (lastSelectedConnection.getType() & 0x10) == 0 & (lastSelectedConnection.getType() & 0x40) == 0);
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_12, 1, IArchiImages.ImageFactory.getImageDescriptor("img/arrow-target-fill.png"));
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_13, 16, IArchiImages.ImageFactory.getImageDescriptor("img/arrow-target-hollow.png"));
            menuManager.add(action);
            action = this.createAction(Messages.DiagramConnectionLineStyleSection_14, 64, IArchiImages.ImageFactory.getImageDescriptor("img/arrow-target-line.png"));
            menuManager.add(action);
        }

        @Override
        protected void update() {
            int connectionType = ((IDiagramModelConnection)DiagramConnectionLineStyleSection.this.getFirstSelectedObject()).getType();
            if ((connectionType & 1) != 0) {
                this.fValue = 1;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/arrow-target-fill.png"));
            } else if ((connectionType & 0x10) != 0) {
                this.fValue = 16;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/arrow-target-hollow.png"));
            } else if ((connectionType & 0x40) != 0) {
                this.fValue = 64;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/arrow-target-line.png"));
            } else {
                this.fValue = 0;
                this.fButton.setImage(IArchiImages.ImageFactory.getImage("img/line-solid.png"));
            }
        }
    }
}

