/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.ConnectionTextPositionCommand;
import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IFeatures;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class DiagramConnectionSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private Combo fComboTextPosition;
    private Button fButtonDisplayName;
    public static final String[] comboTextPositionItems = new String[]{Messages.DiagramConnectionSection_0, Messages.DiagramConnectionSection_1, Messages.DiagramConnectionSection_2};

    @Override
    protected void createControls(Composite parent) {
        this.createDisplayNameControl(parent);
        this.createTextPositionComboControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createTextPositionComboControl(Composite parent) {
        this.createLabel(parent, Messages.DiagramConnectionSection_6, 115, 0x1000000);
        this.fComboTextPosition = new Combo(parent, 8);
        this.getWidgetFactory().adapt((Control)this.fComboTextPosition, true, true);
        this.fComboTextPosition.setItems(comboTextPositionItems);
        GridData gd = new GridData(0, 0, true, false);
        this.fComboTextPosition.setLayoutData((Object)gd);
        this.fComboTextPosition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : DiagramConnectionSection.this.getEObjects()) {
                    ConnectionTextPositionCommand cmd;
                    if (!DiagramConnectionSection.this.isAlive(eObject) || !(cmd = new ConnectionTextPositionCommand((IDiagramModelConnection)eObject, DiagramConnectionSection.this.fComboTextPosition.getSelectionIndex())).canExecute()) continue;
                    result.add((Command)cmd);
                }
                DiagramConnectionSection.this.executeCommand(result.unwrap());
            }
        });
    }

    private void createDisplayNameControl(Composite parent) {
        this.createLabel(parent, Messages.DiagramConnectionSection_8 + ":", 115, 0x1000000);
        this.fButtonDisplayName = this.getWidgetFactory().createButton(parent, null, 32);
        this.fButtonDisplayName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : DiagramConnectionSection.this.getEObjects()) {
                    FeatureCommand cmd;
                    if (!DiagramConnectionSection.this.isAlive(eObject) || !(cmd = new FeatureCommand(Messages.DiagramConnectionSection_8, (IFeatures)eObject, "nameVisible", DiagramConnectionSection.this.fButtonDisplayName.getSelection(), true)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                DiagramConnectionSection.this.executeCommand(result.unwrap());
            }
        });
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL_CONNECTION__TEXT_POSITION) {
            this.refreshTextPositionCombo();
        } else if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        } else if (this.isFeatureNotification(msg, "nameVisible")) {
            this.refreshNameVisibleButton();
        }
    }

    @Override
    protected void update() {
        this.refreshNameVisibleButton();
        this.refreshTextPositionCombo();
    }

    protected void refreshTextPositionCombo() {
        if (this.fIsExecutingCommand) {
            return;
        }
        IDiagramModelConnection lastSelectedConnection = (IDiagramModelConnection)this.getFirstSelectedObject();
        int pos = lastSelectedConnection.getTextPosition();
        this.fComboTextPosition.select(pos);
        this.fComboTextPosition.setEnabled(!this.isLocked(lastSelectedConnection));
    }

    protected void refreshNameVisibleButton() {
        if (this.fIsExecutingCommand) {
            return;
        }
        IDiagramModelConnection lastSelectedConnection = (IDiagramModelConnection)this.getFirstSelectedObject();
        this.fButtonDisplayName.setSelection(lastSelectedConnection.isNameVisible());
        this.fButtonDisplayName.setEnabled(!this.isLocked(lastSelectedConnection));
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IDiagramModelConnection;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelConnection.class;
        }
    }
}

