/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.FillColorCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.ColorChooser;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

class FillColorComposite {
    private ColorChooser fColorChooser;
    private AbstractECorePropertySection section;
    private Composite composite;
    private IPropertyChangeListener colorListener = event -> {
        CompoundCommand result = new CompoundCommand();
        if (event.getProperty() == "colorValue") {
            RGB rGB = this.fColorChooser.getColorValue();
            String newColor = ColorFactory.convertRGBToString(rGB);
            for (EObject eObject : this.section.getEObjects()) {
                FillColorCommand cmd;
                if (!this.isValidObject(eObject) || !(cmd = new FillColorCommand((IDiagramModelObject)eObject, newColor)).canExecute()) continue;
                result.add((Command)cmd);
            }
        } else if (event.getProperty() == "colorDefault") {
            for (EObject eObject : this.section.getEObjects()) {
                void var5_10;
                FillColorCommand cmd;
                if (!this.isValidObject(eObject)) continue;
                Object var5_11 = null;
                if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("saveUserDefaultFillColorInFile")) {
                    Color color = ColorFactory.getDefaultFillColor(eObject);
                    String string = ColorFactory.convertColorToString(color);
                }
                if (!(cmd = new FillColorCommand((IDiagramModelObject)eObject, (String)var5_10)).canExecute()) continue;
                result.add((Command)cmd);
            }
        }
        this.section.executeCommand(result.unwrap());
    };
    private IPropertyChangeListener prefsListener = event -> {
        if (event.getProperty().startsWith("defaultFillColour_") || event.getProperty().equals("saveUserDefaultFillColorInFile")) {
            this.updateControl();
        }
    };

    FillColorComposite(AbstractECorePropertySection section, Composite parent) {
        this.section = section;
        this.composite = section.createComposite(parent, 2, false);
        this.createColorControl(this.composite);
        this.addListeners();
    }

    Composite getComposite() {
        return this.composite;
    }

    private boolean isValidObject(EObject eObject) {
        return this.section.isAlive(eObject) && !this.section.isLocked(eObject) && this.section.getFilter().shouldExposeFeature(eObject, IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__FILL_COLOR.getName());
    }

    private void createColorControl(Composite parent) {
        this.section.createLabel(parent, Messages.FillColorSection_0, 115, 0x1000000);
        this.fColorChooser = new ColorChooser(parent, (FormToolkit)this.section.getWidgetFactory());
    }

    void updateControl() {
        IDiagramModelObject firstSelected = (IDiagramModelObject)this.section.getFirstSelectedObject();
        RGB rgb = ColorFactory.convertStringToRGB(firstSelected.getFillColor());
        if (rgb == null) {
            rgb = ColorFactory.getDefaultFillColor(firstSelected).getRGB();
        }
        this.fColorChooser.setColorValue(rgb);
        this.fColorChooser.setEnabled(!this.section.isLocked(firstSelected));
        boolean isDefaultColor = true;
        boolean saveUserDefaultColor = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("saveUserDefaultFillColorInFile");
        for (IArchimateModelObject object : this.section.getEObjects()) {
            if (!(object instanceof IDiagramModelObject)) continue;
            IDiagramModelObject dmo = (IDiagramModelObject)object;
            if (saveUserDefaultColor) {
                isDefaultColor &= dmo.getFillColor() != null && rgb.equals((Object)ColorFactory.getDefaultFillColor(dmo).getRGB());
                continue;
            }
            isDefaultColor &= dmo.getFillColor() == null;
        }
        this.fColorChooser.setIsDefaultColor(isDefaultColor);
    }

    void dispose() {
        this.removeListeners();
        this.composite = null;
        this.section = null;
        this.fColorChooser = null;
    }

    private void addListeners() {
        if (this.fColorChooser != null) {
            this.fColorChooser.addListener(this.colorListener);
        }
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
    }

    private void removeListeners() {
        if (this.fColorChooser != null) {
            this.fColorChooser.removeListener(this.colorListener);
        }
        ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
    }
}

