/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.FontColorCommand;
import com.archimatetool.editor.diagram.commands.FontCompoundCommand;
import com.archimatetool.editor.diagram.commands.FontStyleCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.GridLayoutColumnHandler;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.ColorChooser;
import com.archimatetool.editor.ui.components.FontChooser;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IFontAttribute;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FontSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private IPropertyChangeListener fontListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            CompoundCommand result = new CompoundCommand();
            if (event.getProperty() == "fontValue") {
                FontData fontData = FontSection.this.fFontChooser.getFontData();
                RGB rgb = FontSection.this.fFontChooser.getFontRGB();
                for (EObject eObject : FontSection.this.getEObjects()) {
                    FontCompoundCommand cmd;
                    if (!FontSection.this.isAlive(eObject) || !(cmd = new FontCompoundCommand((IFontAttribute)eObject, fontData.toString(), rgb)).canExecute()) continue;
                    result.add((Command)cmd);
                }
            } else if (event.getProperty() == "fontDefault") {
                for (EObject eObject : FontSection.this.getEObjects()) {
                    FontStyleCommand fontStyleCommand;
                    if (!FontSection.this.isAlive(eObject) || !(fontStyleCommand = new FontStyleCommand((IFontAttribute)eObject, null)).canExecute()) continue;
                    result.add((Command)fontStyleCommand);
                }
            }
            FontSection.this.executeCommand(result.unwrap());
        }
    };
    private IPropertyChangeListener colorListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            CompoundCommand result = new CompoundCommand();
            if (event.getProperty() == "colorValue") {
                RGB rGB = FontSection.this.fColorChooser.getColorValue();
                String newColor = ColorFactory.convertRGBToString(rGB);
                for (EObject eObject : FontSection.this.getEObjects()) {
                    FontColorCommand cmd;
                    if (!FontSection.this.isAlive(eObject) || !(cmd = new FontColorCommand((IFontAttribute)eObject, newColor)).canExecute()) continue;
                    result.add((Command)cmd);
                }
            } else if (event.getProperty() == "colorDefault") {
                for (EObject eObject : FontSection.this.getEObjects()) {
                    FontColorCommand fontColorCommand;
                    if (!FontSection.this.isAlive(eObject) || !(fontColorCommand = new FontColorCommand((IFontAttribute)eObject, null)).canExecute()) continue;
                    result.add((Command)fontColorCommand);
                }
            }
            FontSection.this.executeCommand(result.unwrap());
        }
    };
    private IPropertyChangeListener prefsListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().startsWith("defaultViewFont")) {
                FontSection.this.update();
            }
        }
    };
    private FontChooser fFontChooser;
    private ColorChooser fColorChooser;

    @Override
    protected void createControls(Composite parent) {
        ((GridLayout)parent.getLayout()).horizontalSpacing = 30;
        Composite group1 = this.createComposite(parent, 2, false);
        this.createFontControl(group1);
        Composite group2 = this.createComposite(parent, 2, false);
        this.createColorControl(group2);
        GridLayoutColumnHandler.create(parent, 2).updateColumns();
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createFontControl(Composite parent) {
        this.createLabel(parent, Messages.FontSection_0, 115, 0x1000000);
        this.fFontChooser = new FontChooser(parent, (FormToolkit)this.getWidgetFactory());
        this.fFontChooser.addListener(this.fontListener);
    }

    private void createColorControl(Composite parent) {
        this.createLabel(parent, Messages.FontColorSection_0, 115, 0x1000000);
        this.fColorChooser = new ColorChooser(parent, (FormToolkit)this.getWidgetFactory());
        this.fColorChooser.setDoShowPreferencesMenuItem(false);
        this.fColorChooser.addListener(this.colorListener);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.FONT_ATTRIBUTE__FONT || feature == IArchimatePackage.Literals.FONT_ATTRIBUTE__FONT_COLOR || feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        this.updateFontControl();
        this.updateColorControl();
    }

    private void updateFontControl() {
        IFontAttribute lastSelected = (IFontAttribute)this.getFirstSelectedObject();
        this.fFontChooser.setFontObject(lastSelected);
        this.fFontChooser.setEnabled(!this.isLocked(lastSelected));
        this.fFontChooser.setIsDefaultFont(lastSelected.getFont() == null);
    }

    private void updateColorControl() {
        IFontAttribute firstSelected = (IFontAttribute)this.getFirstSelectedObject();
        RGB rgb = ColorFactory.convertStringToRGB(firstSelected.getFontColor());
        this.fColorChooser.setColorValue(rgb != null ? rgb : new RGB(0, 0, 0));
        this.fColorChooser.setEnabled(!this.isLocked(firstSelected));
        boolean isDefaultColor = true;
        for (IArchimateModelObject object : this.getEObjects()) {
            if (!(object instanceof IFontAttribute)) continue;
            IFontAttribute fontObject = (IFontAttribute)object;
            isDefaultColor &= fontObject.getFontColor() == null;
        }
        this.fColorChooser.setIsDefaultColor(isDefaultColor);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fFontChooser != null) {
            this.fFontChooser.removeListener(this.fontListener);
        }
        if (this.fColorChooser != null) {
            this.fColorChooser.removeListener(this.colorListener);
        }
        ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IFontAttribute && (this.shouldExposeFeature((EObject)object, IArchimatePackage.Literals.FONT_ATTRIBUTE__FONT.getName()) || this.shouldExposeFeature((EObject)object, IArchimatePackage.Literals.FONT_ATTRIBUTE__FONT_COLOR.getName()));
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelComponent.class;
        }
    }
}

