/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFeatures;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class GradientComposite {
    private static String[] GRADIENT_STYLES = new String[]{Messages.GradientSection_2, Messages.GradientSection_3, Messages.GradientSection_4, Messages.GradientSection_5, Messages.GradientSection_6};
    private Combo fGradientCombo;
    private AbstractECorePropertySection section;
    private Composite composite;

    GradientComposite(AbstractECorePropertySection section, Composite parent) {
        this.section = section;
        this.composite = section.createComposite(parent, 2, false);
        this.createGradientControl(this.composite);
    }

    Composite getComposite() {
        return this.composite;
    }

    private void createGradientControl(Composite parent) {
        this.section.createLabel(parent, Messages.GradientSection_0, 115, 0x1000000);
        this.fGradientCombo = new Combo(parent, 8);
        this.section.getWidgetFactory().adapt((Control)this.fGradientCombo, true, true);
        this.fGradientCombo.setItems(GRADIENT_STYLES);
        this.fGradientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : GradientComposite.this.section.getEObjects()) {
                    FeatureCommand cmd;
                    if (!GradientComposite.this.isValidObject(eObject) || !(cmd = new FeatureCommand(Messages.GradientSection_1, (IFeatures)eObject, "gradient", GradientComposite.this.fGradientCombo.getSelectionIndex() - 1, -1)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                GradientComposite.this.section.executeCommand(result.unwrap());
            }
        });
    }

    private boolean isValidObject(EObject eObject) {
        return this.section.isAlive(eObject) && this.section.getFilter().shouldExposeFeature(eObject, "gradient");
    }

    void updateControl() {
        IDiagramModelObject lastSelected = (IDiagramModelObject)this.section.getFirstSelectedObject();
        this.fGradientCombo.select(lastSelected.getGradient() + 1);
        this.fGradientCombo.setEnabled(!this.section.isLocked(lastSelected));
    }

    void dispose() {
        this.composite.dispose();
        this.composite = null;
        this.section = null;
        this.fGradientCombo = null;
    }
}

