/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.figures.IconicDelegate;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.ImageChooserSection;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.io.File;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class IconSection
extends ImageChooserSection {
    private Image fImage;
    private Canvas fCanvas;
    private Combo fComboPosition;
    private static final int IMAGE_SIZE = 100;
    private static final String[] fComboPositionItems = new String[]{Messages.IconSection_0, Messages.IconSection_1, Messages.IconSection_2, Messages.IconSection_3, Messages.IconSection_4, Messages.IconSection_5, Messages.IconSection_6, Messages.IconSection_7, Messages.IconSection_8, Messages.IconSection_13};
    private LightweightEContentAdapter eAdapter = new LightweightEContentAdapter(this::notifyChanged, new Class[]{IProfile.class});
    private IArchimateModel fModel;

    @Override
    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.IconSection_9, 115, 0);
        this.fCanvas = new Canvas(parent, 2048);
        this.getWidgetFactory().adapt((Composite)this.fCanvas);
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 100;
        gd.heightHint = 100;
        this.fCanvas.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fCanvas.setLayout((Layout)layout);
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconSection.this.disposeImage();
            }
        });
        this.fCanvas.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (IconSection.this.fImageButton.isEnabled()) {
                    IconSection.this.chooseImage();
                }
            }
        });
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (IconSection.this.fImage != null) {
                    e.gc.setAntialias(1);
                    e.gc.setInterpolation(2);
                    Rectangle imageBounds = IconSection.this.fImage.getBounds();
                    Rectangle newSize = ImageFactory.getScaledImageSize(IconSection.this.fImage, 100);
                    int x = (100 - newSize.width) / 2;
                    int y = (100 - newSize.height) / 2;
                    e.gc.drawImage(IconSection.this.fImage, 0, 0, imageBounds.width, imageBounds.height, x, y, newSize.width, newSize.height);
                }
            }
        });
        String tooltip = Messages.IconSection_10;
        this.fCanvas.setToolTipText(tooltip);
        DropTarget target = new DropTarget((Control)this.fCanvas, 19);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String[] && IconSection.this.fImageButton.isEnabled()) {
                    File file = new File(((String[])event.data)[0]);
                    IconSection.this.setImage(file);
                }
            }
        });
        this.createImageButton(parent);
        this.createLabel(parent, Messages.IconSection_11, 115, 0x1000000);
        this.fComboPosition = new Combo(parent, 8);
        this.fComboPosition.setItems(fComboPositionItems);
        this.getWidgetFactory().adapt((Control)this.fComboPosition, true, true);
        gd = new GridData(0, 0, false, false);
        this.fComboPosition.setLayoutData((Object)gd);
        this.fComboPosition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : IconSection.this.getEObjects()) {
                    EObjectFeatureCommand cmd;
                    if (!IconSection.this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(Messages.IconSection_12, eObject, (EStructuralFeature)IArchimatePackage.Literals.ICONIC__IMAGE_POSITION, IconSection.this.fComboPosition.getSelectionIndex())).canExecute()) continue;
                    result.add((Command)cmd);
                }
                IconSection.this.executeCommand(result.unwrap());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.elementPropertySection");
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.ARCHIMATE_MODEL__PROFILES || feature == IArchimatePackage.Literals.PROFILES__PROFILES || feature == IArchimatePackage.Literals.DIAGRAM_MODEL_IMAGE_PROVIDER__IMAGE_PATH || this.isFeatureNotification(msg, "imageSource")) {
            this.refreshPreviewImage();
        }
        if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED || feature == IArchimatePackage.Literals.ICONIC__IMAGE_POSITION || this.isFeatureNotification(msg, "imageSource")) {
            this.refreshButton();
        }
    }

    @Override
    protected void addAdapter() {
        super.addAdapter();
        IArchimateModelObject selected = this.getFirstSelectedObject();
        if (selected instanceof IDiagramModelArchimateObject) {
            IArchimateElement element = ((IDiagramModelArchimateObject)selected).getArchimateElement();
            if (!element.eAdapters().contains((Object)this.eAdapter)) {
                element.eAdapters().add((Object)this.eAdapter);
            }
            if (element.getArchimateModel() != null && !element.getArchimateModel().eAdapters().contains((Object)this.eAdapter)) {
                this.fModel = element.getArchimateModel();
                this.fModel.eAdapters().add((Object)this.eAdapter);
            }
        }
    }

    @Override
    protected void removeAdapter() {
        super.removeAdapter();
        IArchimateModelObject selected = this.getFirstSelectedObject();
        if (selected instanceof IDiagramModelArchimateObject) {
            IArchimateElement element = ((IDiagramModelArchimateObject)selected).getArchimateElement();
            element.eAdapters().remove((Object)this.eAdapter);
        }
        if (this.fModel != null) {
            this.fModel.eAdapters().remove((Object)this.eAdapter);
            this.fModel = null;
        }
    }

    @Override
    protected void update() {
        this.refreshPreviewImage();
        this.refreshButton();
    }

    private void refreshPreviewImage() {
        if (this.isAlive((EObject)this.getFirstSelectedObject())) {
            this.disposeImage();
            IconicDelegate iconicDelegate = new IconicDelegate((IIconic)this.getFirstSelectedObject());
            iconicDelegate.updateImage();
            this.fImage = iconicDelegate.getImage();
            this.fCanvas.redraw();
        }
    }

    @Override
    protected void refreshButton() {
        int position;
        super.refreshButton();
        IArchimateModelObject selected = this.getFirstSelectedObject();
        if (selected instanceof IDiagramModelArchimateObject) {
            int source = ((IDiagramModelArchimateObject)selected).getImageSource();
            this.fImageButton.setEnabled(source == 1 && !this.isLocked(selected));
        }
        if ((position = ((IIconic)selected).getImagePosition()) < 0 || position > 9) {
            position = 2;
        }
        if (!this.fIsExecutingCommand) {
            this.fComboPosition.select(position);
            this.fComboPosition.setEnabled(!this.isLocked(selected));
        }
    }

    private void disposeImage() {
        if (this.fImage != null && !this.fImage.isDisposed()) {
            this.fImage.dispose();
            this.fImage = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeImage();
        this.eAdapter = null;
        this.fModel = null;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IIconic && this.shouldExposeFeature((EObject)object, IArchimatePackage.Literals.DIAGRAM_MODEL_IMAGE_PROVIDER__IMAGE_PATH.getName());
        }

        @Override
        public Class<?> getAdaptableType() {
            return IIconic.class;
        }
    }
}

