/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.ImageManagerDialog;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelImageProvider;
import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public abstract class ImageChooserSection
extends AbstractECorePropertySection {
    protected static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    protected Button fImageButton;
    protected Label fLabel;

    protected void createImageButton(Composite parent) {
        this.fLabel = this.createLabel(parent, Messages.DiagramModelImageSection_0, 115, 0x1000000);
        this.fImageButton = new Button(parent, 8);
        this.fImageButton.setText(" " + Messages.DiagramModelImageSection_1);
        this.getWidgetFactory().adapt((Control)this.fImageButton, true, true);
        GridData gd = new GridData(0, 0, true, false);
        gd.minimumWidth = 100;
        this.fImageButton.setLayoutData((Object)gd);
        this.fImageButton.setAlignment(16384);
        this.fImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuManager menuManager = new MenuManager();
                Action actionChoose = new Action(Messages.DiagramModelImageSection_2){

                    public void run() {
                        ImageChooserSection.this.chooseImage();
                    }
                };
                menuManager.add((IAction)actionChoose);
                Action actionClear = new Action(Messages.DiagramModelImageSection_3){

                    public void run() {
                        ImageChooserSection.this.doImagePathCommand(null);
                    }
                };
                actionClear.setEnabled(((IDiagramModelImageProvider)ImageChooserSection.this.getFirstSelectedObject()).getImagePath() != null);
                menuManager.add((IAction)actionClear);
                Menu menu = menuManager.createContextMenu((Control)ImageChooserSection.this.fImageButton.getShell());
                Point p = ImageChooserSection.this.fImageButton.getParent().toDisplay(ImageChooserSection.this.fImageButton.getBounds().x, ImageChooserSection.this.fImageButton.getBounds().y + ImageChooserSection.this.fImageButton.getBounds().height);
                menu.setLocation(p);
                menu.setVisible(true);
            }
        });
    }

    @Override
    protected void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.refreshButton();
        }
    }

    @Override
    protected void update() {
        this.refreshButton();
    }

    protected void refreshButton() {
        IArchimateModelObject selected = this.getFirstSelectedObject();
        this.fLabel.setText(selected instanceof IDiagramModelArchimateObject ? Messages.ImageChooserSection_0 : Messages.ImageChooserSection_1);
        this.fImageButton.setEnabled(!this.isLocked(this.getFirstSelectedObject()));
    }

    protected void chooseImage() {
        IDiagramModelImageProvider dmo = (IDiagramModelImageProvider)this.getFirstSelectedObject();
        if (this.isAlive((EObject)dmo)) {
            ImageManagerDialog dialog = new ImageManagerDialog(this.getPart().getSite().getShell());
            dialog.setSelected(((IArchimateModelObject)dmo).getArchimateModel(), dmo.getImagePath());
            if (dialog.open() == 0) {
                if (dialog.getUserSelectedFile() != null) {
                    this.setImage(dialog.getUserSelectedFile());
                } else if (dialog.getUserSelectedImagePath() != null) {
                    this.setImagePath(dialog.getUserSelectedModel(), dialog.getUserSelectedImagePath());
                }
            }
        }
    }

    protected void setImagePath(IArchimateModel selectedModel, String imagePath) {
        if (selectedModel != this.getFirstSelectedObject().getArchimateModel()) {
            try {
                IArchiveManager selectedArchiveManager = (IArchiveManager)selectedModel.getAdapter(IArchiveManager.class);
                imagePath = this.getArchiveManager().copyImageBytes(selectedArchiveManager, imagePath);
                this.doImagePathCommand(imagePath);
            }
            catch (IOException ex) {
                this.showError(ex);
            }
        } else {
            this.doImagePathCommand(imagePath);
        }
    }

    protected void setImage(File file) {
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            String path = this.getArchiveManager().addImageFromFile(file);
            this.doImagePathCommand(path);
        }
        catch (IOException ex) {
            this.showError(ex);
        }
    }

    protected void doImagePathCommand(String path) {
        CompoundCommand result = new CompoundCommand();
        for (EObject eObject : this.getEObjects()) {
            EObjectFeatureCommand cmd;
            if (!this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(path == null ? Messages.DiagramModelImageSection_4 : Messages.DiagramModelImageSection_7, eObject, (EStructuralFeature)IArchimatePackage.Literals.DIAGRAM_MODEL_IMAGE_PROVIDER__IMAGE_PATH, path)).canExecute()) continue;
            result.add((Command)cmd);
        }
        this.executeCommand(result.unwrap());
    }

    protected IArchiveManager getArchiveManager() {
        return (IArchiveManager)this.getFirstSelectedObject().getAdapter(IArchiveManager.class);
    }

    protected void showError(Throwable ex) {
        ex.printStackTrace();
        MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)Messages.DiagramModelImageSection_5, (String)(Messages.DiagramModelImageSection_6 + " " + ex.getMessage()));
    }
}

