/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.INameable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ImageManagerDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.ImageManagerDialog";
    protected static final String OPEN = Messages.ImageManagerDialog_0;
    protected int DEFAULT_GALLERY_ITEM_SIZE = 128;
    protected int MIN_GALLERY_ITEM_SIZE = 64;
    protected int MAX_GALLERY_ITEM_SIZE = 256;
    protected Gallery fGallery;
    protected GalleryItem fGalleryRoot;
    protected Scale fScale;
    protected ModelsViewer fModelsViewer;
    private IArchimateModel fUserSelectedModel;
    private String fUserSelectedImagePath;
    private File fUserSelectedFile;
    private Map<String, Image> fImageCache = new HashMap<String, Image>();

    public ImageManagerDialog(Shell parentShell) {
        super(parentShell, "ImageManagerDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setSelected(IArchimateModel model, String imagePath) {
        this.fUserSelectedModel = model;
        this.fUserSelectedImagePath = imagePath;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImageManagerDialog_1);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.ImageManagerDialog_1);
        this.setMessage(Messages.ImageManagerDialog_2);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        SashForm sash = new SashForm(client, 256);
        sash.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.widthHint = 580;
        gd.heightHint = 300;
        sash.setLayoutData((Object)gd);
        Composite tableComp = new Composite((Composite)sash, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComp.setLayout((Layout)layout);
        CLabel label = new CLabel(tableComp, 0);
        label.setText(Messages.ImageManagerDialog_3);
        Composite tableComp2 = new Composite(tableComp, 0);
        tableComp2.setLayout((Layout)new TableColumnLayout());
        tableComp2.setLayoutData((Object)new GridData(1808));
        this.fModelsViewer = new ModelsViewer(tableComp2);
        this.fModelsViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fModelsViewer.setInput("");
        this.fModelsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (o instanceof IArchimateModel) {
                    ImageManagerDialog.this.fScale.setEnabled(true);
                    ImageManagerDialog.this.clearGallery();
                    ImageManagerDialog.this.updateGallery((IArchimateModel)o);
                }
            }
        });
        this.fModelsViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object o = ((IStructuredSelection)ImageManagerDialog.this.fModelsViewer.getSelection()).getFirstElement();
                if (o == OPEN) {
                    ImageManagerDialog.this.handleOpenAction();
                }
            }
        });
        Composite galleryComposite = new Composite((Composite)sash, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        galleryComposite.setLayout((Layout)layout);
        this.fGallery = new Gallery(galleryComposite, 2560);
        this.fGallery.setLayoutData((Object)new GridData(1808));
        final NoGroupRenderer groupRenderer = new NoGroupRenderer();
        groupRenderer.setItemSize(this.DEFAULT_GALLERY_ITEM_SIZE, this.DEFAULT_GALLERY_ITEM_SIZE);
        groupRenderer.setAutoMargin(true);
        groupRenderer.setMinMargin(10);
        this.fGallery.setGroupRenderer((AbstractGalleryGroupRenderer)groupRenderer);
        final DefaultGalleryItemRenderer itemRenderer = new DefaultGalleryItemRenderer();
        itemRenderer.setShowRoundedSelectionCorners(true);
        this.fGallery.setItemRenderer((AbstractGalleryItemRenderer)itemRenderer);
        this.fGalleryRoot = new GalleryItem(this.fGallery, 0);
        this.fScale = new Scale(galleryComposite, 256);
        gd = new GridData(0x1000008, 0, false, false);
        gd.widthHint = 120;
        this.fScale.setLayoutData((Object)gd);
        this.fScale.setMinimum(this.MIN_GALLERY_ITEM_SIZE);
        this.fScale.setMaximum(this.MAX_GALLERY_ITEM_SIZE);
        this.fScale.setIncrement(8);
        this.fScale.setPageIncrement(32);
        this.fScale.setSelection(this.DEFAULT_GALLERY_ITEM_SIZE);
        this.fScale.setEnabled(false);
        this.fScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int inc = ImageManagerDialog.this.fScale.getSelection();
                itemRenderer.setDropShadows(inc >= 96);
                groupRenderer.setItemSize(inc, inc);
            }
        });
        this.fGallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof GalleryItem) {
                    ImageManagerDialog.this.fUserSelectedImagePath = (String)e.item.getData("imagepath");
                    ImageManagerDialog.this.fUserSelectedModel = (IArchimateModel)e.item.getData("model");
                } else {
                    ImageManagerDialog.this.fUserSelectedImagePath = null;
                    ImageManagerDialog.this.fUserSelectedModel = null;
                }
            }
        });
        this.fGallery.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                GalleryItem item = ImageManagerDialog.this.fGallery.getItem(new Point(event.x, event.y));
                if (item != null) {
                    ImageManagerDialog.this.okPressed();
                }
            }
        });
        this.fGallery.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageManagerDialog.this.disposeImages();
            }
        });
        sash.setWeights(new int[]{30, 70});
        if (this.fUserSelectedModel != null && ((ModelsViewerContentProvider)this.fModelsViewer.getContentProvider()).getModels().contains(this.fUserSelectedModel)) {
            this.fModelsViewer.setSelection((ISelection)new StructuredSelection((Object)this.fUserSelectedModel));
            if (this.fUserSelectedImagePath != null) {
                GalleryItem[] galleryItemArray = this.fGalleryRoot.getItems();
                int n = galleryItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GalleryItem item = galleryItemArray[n2];
                    String imagePath = (String)item.getData("imagepath");
                    if (imagePath != null && this.fUserSelectedImagePath.equals(imagePath)) {
                        this.fGallery.setSelection(new GalleryItem[]{item});
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            Object element = this.fModelsViewer.getElementAt(0);
            if (element != null) {
                this.fModelsViewer.setSelection((ISelection)new StructuredSelection(element), true);
            }
        }
        return composite;
    }

    private void clearGallery() {
        if (this.fGalleryRoot != null && !this.fGallery.isDisposed() && this.fGallery.getItemCount() > 0) {
            while (this.fGalleryRoot.getItemCount() > 0) {
                GalleryItem item = this.fGalleryRoot.getItem(0);
                this.fGalleryRoot.remove(item);
            }
        }
    }

    private void updateGallery(final IArchimateModel model) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                IArchiveManager archiveManager = (IArchiveManager)model.getAdapter(IArchiveManager.class);
                for (String path : archiveManager.getImagePaths()) {
                    Image thumbnail;
                    block4: {
                        thumbnail = ImageManagerDialog.this.fImageCache.get(path);
                        if (thumbnail == null) {
                            try {
                                thumbnail = archiveManager.createImage(path);
                                if (thumbnail == null) break block4;
                                ImageManagerDialog.this.fImageCache.put(path, thumbnail);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                continue;
                            }
                        }
                    }
                    if (thumbnail == null) continue;
                    GalleryItem item = new GalleryItem(ImageManagerDialog.this.fGalleryRoot, 0);
                    item.setImage(thumbnail);
                    item.setData("imagepath", (Object)path);
                    item.setData("model", (Object)model);
                }
                ImageManagerDialog.this.fGallery.redraw();
            }
        });
    }

    private void handleOpenAction() {
        this.getShell().setVisible(false);
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.png;*.jpg;*.jpeg;*.gif;*.tif;*.tiff;*.bmp;*.ico", "*.*"});
        String path = dialog.open();
        if (path != null) {
            this.fUserSelectedFile = new File(path);
            this.fUserSelectedImagePath = null;
            this.fUserSelectedModel = null;
            this.okPressed();
        } else {
            this.getShell().setVisible(true);
        }
    }

    public File getUserSelectedFile() {
        return this.fUserSelectedFile;
    }

    public String getUserSelectedImagePath() {
        return this.fUserSelectedImagePath;
    }

    public IArchimateModel getUserSelectedModel() {
        return this.fUserSelectedModel;
    }

    private void disposeImages() {
        for (Map.Entry<String, Image> entry : this.fImageCache.entrySet()) {
            Image image = entry.getValue();
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
    }

    private class ModelsViewer
    extends TableViewer {
        public ModelsViewer(Composite parent) {
            super(parent, 65536);
            this.setColumns();
            this.setContentProvider((IContentProvider)new ModelsViewerContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new ModelsViewerLabelProvider());
            this.setComparator(new ViewerComparator(){

                public int category(Object element) {
                    if (element == OPEN) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        private void setColumns() {
            Table table = this.getTable();
            table.setHeaderVisible(false);
            TableColumnLayout layout = (TableColumnLayout)this.getControl().getParent().getLayout();
            TableViewerColumn column = new TableViewerColumn((TableViewer)this, 0);
            layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
        }
    }

    private class ModelsViewerContentProvider
    implements IStructuredContentProvider {
        private List<IArchimateModel> models;

        private ModelsViewerContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IArchimateModel> list = new ArrayList<IArchimateModel>(this.getModels());
            list.add((IArchimateModel)OPEN);
            return list.toArray();
        }

        public List<IArchimateModel> getModels() {
            if (this.models == null) {
                this.models = new ArrayList<IArchimateModel>();
                for (IArchimateModel model : IEditorModelManager.INSTANCE.getModels()) {
                    IArchiveManager archiveManager = (IArchiveManager)model.getAdapter(IArchiveManager.class);
                    if (archiveManager == null || !archiveManager.hasImages()) continue;
                    this.models.add(model);
                }
            }
            return this.models;
        }
    }

    private class ModelsViewerLabelProvider
    extends LabelProvider {
        private ModelsViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INameable) {
                return ((INameable)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return ArchiLabelProvider.INSTANCE.getImage(element);
        }
    }
}

