/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.LineColorCommand;
import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.ColorChooser;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.ILineObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

class LineColorComposite {
    private ColorChooser fColorChooser;
    private Action fDeriveLineColorAction;
    private AbstractECorePropertySection section;
    private Composite composite;
    private IPropertyChangeListener colorListener = event -> {
        CompoundCommand result = new CompoundCommand();
        if (event.getProperty() == "colorValue") {
            RGB rGB = this.fColorChooser.getColorValue();
            String newColor = ColorFactory.convertRGBToString(rGB);
            for (EObject eObject : this.section.getEObjects()) {
                LineColorCommand cmd;
                if (!this.isValidLineColorObject(eObject) || !(cmd = new LineColorCommand((ILineObject)eObject, newColor)).canExecute()) continue;
                result.add((Command)cmd);
            }
        } else if (event.getProperty() == "colorDefault") {
            for (EObject eObject : this.section.getEObjects()) {
                void var5_10;
                LineColorCommand cmd;
                if (!this.isValidLineColorObject(eObject)) continue;
                Object var5_11 = null;
                if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("saveUserDefaultFillColorInFile")) {
                    Color color = ColorFactory.getDefaultLineColor(eObject);
                    String string = ColorFactory.convertColorToString(color);
                }
                if (!(cmd = new LineColorCommand((ILineObject)eObject, (String)var5_10)).canExecute()) continue;
                result.add((Command)cmd);
            }
        }
        this.section.executeCommand(result.unwrap());
    };
    private IPropertyChangeListener prefsListener = event -> {
        if (event.getProperty().equals("defaultElementLineColor") || event.getProperty().equals("defaultConnectionLineColor") || event.getProperty().equals("saveUserDefaultFillColorInFile")) {
            this.updateControl();
        }
    };

    LineColorComposite(AbstractECorePropertySection section, Composite parent) {
        this.section = section;
        this.composite = section.createComposite(parent, 2, false);
        this.createColorControl(this.composite);
        this.addListeners();
    }

    Composite getComposite() {
        return this.composite;
    }

    private void createColorControl(Composite parent) {
        this.section.createLabel(parent, Messages.LineColorSection_0, 115, 0x1000000);
        this.fColorChooser = new ColorChooser(parent, (FormToolkit)this.section.getWidgetFactory());
        this.fDeriveLineColorAction = new Action(Messages.LineColorSection_3, 2){

            public void run() {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : LineColorComposite.this.section.getEObjects()) {
                    FeatureCommand cmd;
                    if (!LineColorComposite.this.isValidDerivedLineColorObject(eObject) || !(cmd = new FeatureCommand(Messages.LineColorSection_4, (IFeatures)eObject, "deriveElementLineColor", LineColorComposite.this.fDeriveLineColorAction.isChecked(), true)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                LineColorComposite.this.section.executeCommand(result.unwrap());
            }
        };
    }

    void updateControl() {
        ILineObject firstSelected = (ILineObject)this.section.getFirstSelectedObject();
        RGB rgb = ColorFactory.convertStringToRGB(firstSelected.getLineColor());
        if (rgb == null) {
            rgb = ColorFactory.getDefaultLineColor(firstSelected).getRGB();
        }
        this.fColorChooser.setColorValue(rgb);
        this.fColorChooser.setEnabled(!this.section.isLocked(firstSelected));
        boolean isDefaultColor = true;
        boolean saveUserDefaultColor = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("saveUserDefaultFillColorInFile");
        for (IArchimateModelObject object : this.section.getEObjects()) {
            if (!(object instanceof ILineObject)) continue;
            ILineObject lo = (ILineObject)object;
            if (saveUserDefaultColor) {
                isDefaultColor &= lo.getLineColor() != null && rgb.equals((Object)ColorFactory.getDefaultLineColor(lo).getRGB());
                continue;
            }
            isDefaultColor &= lo.getLineColor() == null;
        }
        this.fColorChooser.setIsDefaultColor(isDefaultColor);
        if (firstSelected instanceof IDiagramModelObject) {
            IDiagramModelObject dmo = (IDiagramModelObject)firstSelected;
            boolean deriveElementLineColor = dmo.getDeriveElementLineColor();
            this.fColorChooser.setDoShowColorImage(!deriveElementLineColor);
            this.fColorChooser.getColorButton().setEnabled(!deriveElementLineColor);
            this.fColorChooser.setDoShowDefaultMenuItem(!deriveElementLineColor);
            this.fColorChooser.addMenuAction((IAction)this.fDeriveLineColorAction);
            this.fDeriveLineColorAction.setChecked(deriveElementLineColor);
        } else {
            this.fColorChooser.setDoShowColorImage(true);
            this.fColorChooser.getColorButton().setEnabled(true);
            this.fColorChooser.setDoShowDefaultMenuItem(true);
        }
    }

    private boolean isValidLineColorObject(EObject eObject) {
        return this.section.isAlive(eObject) && this.section.getFilter().shouldExposeFeature(eObject, IArchimatePackage.Literals.LINE_OBJECT__LINE_COLOR.getName());
    }

    private boolean isValidDerivedLineColorObject(EObject eObject) {
        return this.isValidLineColorObject(eObject) && eObject instanceof IDiagramModelObject && this.section.getFilter().shouldExposeFeature(eObject, "deriveElementLineColor");
    }

    void dispose() {
        this.removeListeners();
        this.composite = null;
        this.section = null;
        this.fColorChooser = null;
    }

    private void addListeners() {
        if (this.fColorChooser != null) {
            this.fColorChooser.addListener(this.colorListener);
        }
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
    }

    private void removeListeners() {
        if (this.fColorChooser != null) {
            this.fColorChooser.removeListener(this.colorListener);
        }
        ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
    }
}

