/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.DiagramModelObjectOutlineAlphaCommand;
import com.archimatetool.editor.propertysections.AbstractMultiControlSection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.LineStyleComposite;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.propertysections.OpacityComposite;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class LineSection2
extends AbstractMultiControlSection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private OpacityComposite opacityComposite;
    private LineStyleComposite linestyleComposite;

    @Override
    protected void createControls(Composite parent) {
        this.init(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (this.isFeatureNotification(msg, "lineAlpha")) {
            if (!this.fIsExecutingCommand) {
                this.updateOpacityControl();
            }
        } else if (this.isFeatureNotification(msg, "lineStyle")) {
            this.updateLineStyleControl();
        } else if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        this.updateOpacityControl();
        this.updateLineStyleControl();
    }

    private void updateOpacityControl() {
        boolean show = this.shouldShowControl("lineAlpha");
        if (show) {
            if (this.opacityComposite == null) {
                this.opacityComposite = new OpacityComposite(this, this.parentComposite, Messages.LineOpacitySection_0){

                    @Override
                    Command getCommand(IDiagramModelObject dmo, int newValue) {
                        return new DiagramModelObjectOutlineAlphaCommand(dmo, newValue);
                    }

                    @Override
                    int getValue() {
                        IDiagramModelObject lastSelected = (IDiagramModelObject)LineSection2.this.getFirstSelectedObject();
                        return lastSelected.getLineAlpha();
                    }

                    @Override
                    boolean isValidObject(EObject eObject) {
                        return LineSection2.this.getFilter().shouldExposeFeature(eObject, "lineAlpha");
                    }
                };
                if (this.linestyleComposite != null) {
                    this.opacityComposite.getComposite().moveAbove((Control)this.linestyleComposite.getComposite());
                    this.layout();
                }
            }
            this.opacityComposite.updateControl();
        } else if (this.opacityComposite != null) {
            this.opacityComposite.dispose();
            this.opacityComposite = null;
            this.layout();
        }
    }

    private void updateLineStyleControl() {
        boolean show = this.shouldShowControl("lineStyle");
        if (show) {
            if (this.linestyleComposite == null) {
                this.linestyleComposite = new LineStyleComposite(this, this.parentComposite);
                this.layout();
            }
            this.linestyleComposite.updateControl();
        } else if (this.linestyleComposite != null) {
            this.linestyleComposite.dispose();
            this.linestyleComposite = null;
            this.layout();
        }
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.opacityComposite != null) {
            this.opacityComposite.dispose();
            this.opacityComposite = null;
        }
        if (this.linestyleComposite != null) {
            this.linestyleComposite.dispose();
            this.linestyleComposite = null;
        }
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            IDiagramModelObject dmo;
            return object instanceof IDiagramModelObject && (this.shouldExposeFeature((EObject)(dmo = (IDiagramModelObject)object), "lineAlpha") || this.shouldExposeFeature((EObject)dmo, "lineStyle"));
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelObject.class;
        }
    }
}

