/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.DiagramModelObjectLineStyleCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

class LineStyleComposite {
    private Button button;
    private AbstractECorePropertySection section;
    private Composite composite;

    LineStyleComposite(AbstractECorePropertySection section, Composite parent) {
        this.section = section;
        this.composite = section.createComposite(parent, 2, false);
        this.createControls(this.composite);
    }

    Composite getComposite() {
        return this.composite;
    }

    private void createControls(Composite parent) {
        this.section.createLabel(parent, Messages.LineStyleComposite_0, 115, 0x1000000);
        this.button = this.section.getWidgetFactory().createButton(parent, null, 8);
        this.button.setLayoutData((Object)GridDataFactory.swtDefaults().hint(50, -1).create());
        this.button.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            MenuManager menuManager = new MenuManager();
            menuManager.add(this.createAction(Messages.LineStyleComposite_1, 0, IArchiImages.ImageFactory.getImageDescriptor("img/line-solid.png")));
            menuManager.add(this.createAction(Messages.LineStyleComposite_2, 1, IArchiImages.ImageFactory.getImageDescriptor("img/line-dashed.png")));
            menuManager.add(this.createAction(Messages.LineStyleComposite_3, 2, IArchiImages.ImageFactory.getImageDescriptor("img/line-dotted.png")));
            menuManager.add(this.createAction(Messages.LineStyleComposite_4, 3, IArchiImages.ImageFactory.getImageDescriptor("img/line-none.png")));
            Menu menu = menuManager.createContextMenu((Control)this.button.getShell());
            Rectangle buttonBounds = this.button.getBounds();
            Point p = this.button.getParent().toDisplay(buttonBounds.x, buttonBounds.y + buttonBounds.height);
            menu.setLocation(p);
            menu.setVisible(true);
        }));
    }

    private IAction createAction(String text, final int value, final ImageDescriptor imageDesc) {
        Action action = new Action(text, 8){

            public void run() {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : LineStyleComposite.this.section.getEObjects()) {
                    IDiagramModelObject dmo;
                    DiagramModelObjectLineStyleCommand cmd;
                    if (!LineStyleComposite.this.isValidObject(eObject) || !(eObject instanceof IDiagramModelObject) || !(cmd = new DiagramModelObjectLineStyleCommand(dmo = (IDiagramModelObject)eObject, value)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                LineStyleComposite.this.section.executeCommand(result.unwrap());
            }

            public ImageDescriptor getImageDescriptor() {
                return imageDesc;
            }
        };
        int lineStyle = this.getLineStyle((IDiagramModelObject)this.section.getFirstSelectedObject());
        action.setChecked(lineStyle == value);
        return action;
    }

    private boolean isValidObject(EObject eObject) {
        return this.section.isAlive(eObject) && this.section.getFilter().shouldExposeFeature(eObject, "lineStyle");
    }

    private int getLineStyle(IDiagramModelObject dmo) {
        return (Integer)ObjectUIFactory.INSTANCE.getProvider((EObject)dmo).getFeatureValue("lineStyle");
    }

    void updateControl() {
        IDiagramModelObject dmo = (IDiagramModelObject)this.section.getFirstSelectedObject();
        int lineStyle = this.getLineStyle(dmo);
        switch (lineStyle) {
            default: {
                this.button.setImage(IArchiImages.ImageFactory.getImage("img/line-solid.png"));
                break;
            }
            case 1: {
                this.button.setImage(IArchiImages.ImageFactory.getImage("img/line-dashed.png"));
                break;
            }
            case 2: {
                this.button.setImage(IArchiImages.ImageFactory.getImage("img/line-dotted.png"));
                break;
            }
            case 3: {
                this.button.setImage(IArchiImages.ImageFactory.getImage("img/line-none.png"));
            }
        }
        this.button.setEnabled(!this.section.isLocked(dmo));
    }

    void dispose() {
        this.composite.dispose();
        this.composite = null;
        this.section = null;
        this.button = null;
    }
}

