/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.LineWidthCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ILineObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class LineWidthComposite {
    private static final String[] comboLineWidthItems = new String[]{Messages.LineWidthSection_1, Messages.LineWidthSection_2, Messages.LineWidthSection_3};
    private Combo fComboLineWidth;
    private AbstractECorePropertySection section;
    private Composite composite;

    LineWidthComposite(AbstractECorePropertySection section, Composite parent) {
        this.section = section;
        this.composite = section.createComposite(parent, 2, false);
        this.createLineWidthControl(this.composite);
    }

    Composite getComposite() {
        return this.composite;
    }

    private void createLineWidthControl(Composite parent) {
        this.section.createLabel(parent, Messages.LineWidthSection_0, 115, 0x1000000);
        this.fComboLineWidth = new Combo(parent, 8);
        this.section.getWidgetFactory().adapt((Control)this.fComboLineWidth, true, true);
        this.fComboLineWidth.setItems(comboLineWidthItems);
        this.fComboLineWidth.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            CompoundCommand result = new CompoundCommand();
            for (EObject eObject : this.section.getEObjects()) {
                LineWidthCommand cmd;
                if (!this.isValidObject(eObject) || !(cmd = new LineWidthCommand((ILineObject)eObject, this.fComboLineWidth.getSelectionIndex() + 1)).canExecute()) continue;
                result.add((Command)cmd);
            }
            this.section.executeCommand(result.unwrap());
        }));
    }

    void updateControl() {
        ILineObject lineObject = (ILineObject)this.section.getFirstSelectedObject();
        int lineWidth = lineObject.getLineWidth();
        lineWidth = lineWidth < 1 ? 1 : (lineWidth > 3 ? 3 : lineWidth);
        this.fComboLineWidth.select(lineWidth - 1);
        this.fComboLineWidth.setEnabled(!this.section.isLocked(lineObject));
    }

    private boolean isValidObject(EObject eObject) {
        return this.section.isAlive(eObject) && this.section.getFilter().shouldExposeFeature(eObject, IArchimatePackage.Literals.LINE_OBJECT__LINE_WIDTH.getName());
    }

    void dispose() {
        this.composite.dispose();
        this.composite = null;
        this.section = null;
        this.fComboLineWidth = null;
    }
}

