/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.LockObjectCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ILockable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class LockedSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private Button fButtonLocked;

    @Override
    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.LockedSection_0, 115, 0x1000000);
        this.fButtonLocked = this.getWidgetFactory().createButton(parent, null, 32);
        this.fButtonLocked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : LockedSection.this.getEObjects()) {
                    LockObjectCommand cmd;
                    if (!LockedSection.this.isAlive(eObject) || !(cmd = new LockObjectCommand((ILockable)eObject, LockedSection.this.fButtonLocked.getSelection())).canExecute()) continue;
                    result.add((Command)cmd);
                }
                LockedSection.this.executeCommand(result.unwrap());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        if (this.fIsExecutingCommand) {
            return;
        }
        this.fButtonLocked.setSelection(((ILockable)this.getFirstSelectedObject()).isLocked());
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof ILockable;
        }

        @Override
        public Class<?> getAdaptableType() {
            return ILockable.class;
        }
    }
}

