/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

abstract class OpacityComposite {
    private Spinner fSpinner;
    private AbstractECorePropertySection section;
    private Composite composite;

    OpacityComposite(AbstractECorePropertySection section, Composite parent, String label) {
        this.section = section;
        this.composite = section.createComposite(parent, 2, false);
        this.createSpinnerControl(this.composite, label);
    }

    Composite getComposite() {
        return this.composite;
    }

    private void createSpinnerControl(Composite parent, String label) {
        this.section.createLabel(parent, label, 115, 0x1000000);
        this.fSpinner = new Spinner(parent, 2048);
        this.fSpinner.setMinimum(0);
        this.fSpinner.setMaximum(255);
        this.fSpinner.setIncrement(5);
        this.section.getWidgetFactory().adapt((Control)this.fSpinner, true, true);
        Listener listener = event -> {
            int newValue = this.fSpinner.getSelection();
            CompoundCommand result = new CompoundCommand();
            for (EObject eObject : this.section.getEObjects()) {
                Command cmd;
                if (!this.section.isAlive(eObject) || !this.isValidObject(eObject) || !(cmd = this.getCommand((IDiagramModelObject)eObject, newValue)).canExecute()) continue;
                result.add(cmd);
            }
            this.section.executeCommand(result.unwrap());
        };
        this.fSpinner.addListener(4, listener);
        this.fSpinner.addListener(16, listener);
        this.fSpinner.addListener(14, listener);
        this.fSpinner.addDisposeListener(event -> {
            if (this.fSpinner != null && !this.fSpinner.isDisposed()) {
                this.fSpinner.removeListener(4, listener);
                this.fSpinner.removeListener(16, listener);
                this.fSpinner.removeListener(14, listener);
            }
        });
    }

    abstract Command getCommand(IDiagramModelObject var1, int var2);

    abstract int getValue();

    abstract boolean isValidObject(EObject var1);

    void updateControl() {
        IDiagramModelObject lastSelected = (IDiagramModelObject)this.section.getFirstSelectedObject();
        this.fSpinner.setSelection(this.getValue());
        this.fSpinner.setEnabled(!this.section.isLocked(lastSelected));
    }

    void dispose() {
        this.composite.dispose();
        this.composite = null;
        this.fSpinner = null;
        this.section = null;
    }
}

