/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateRelationship;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class PropertiesLabelProvider
implements ILabelProvider {
    /*
     * WARNING - void declaration
     */
    public Image getImage(Object object) {
        void selection;
        if (!(object instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
        if (selection.size() > 1) {
            Object[] objects = selection.toArray();
            int i = 0;
            while (i < objects.length - 1) {
                if (this.getImageFromLabelProvider(objects[i]) != this.getImageFromLabelProvider(objects[i + 1])) {
                    return null;
                }
                ++i;
            }
        }
        return this.getImageFromLabelProvider(selection.getFirstElement());
    }

    protected Image getImageFromLabelProvider(Object object) {
        Image image = ArchiLabelProvider.INSTANCE.getImage(object);
        if (image != null) {
            return image;
        }
        ILabelProvider labelProvider = (ILabelProvider)Adapters.adapt((Object)object, ILabelProvider.class);
        return labelProvider != null ? labelProvider.getImage(object) : null;
    }

    /*
     * WARNING - void declaration
     */
    public String getText(Object object) {
        void selection;
        if (!(object instanceof IStructuredSelection)) {
            return " ";
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
        if (selection.size() > 1) {
            return Messages.PropertiesLabelProvider_0;
        }
        Object object2 = ArchiLabelProvider.INSTANCE.getAdaptableObject(selection.getFirstElement());
        if (object2 instanceof IArchimateConcept) {
            IArchimateConcept concept = (IArchimateConcept)object2;
            return this.getArchimateConceptText(concept);
        }
        return this.getTextFromLabelProvider(selection.getFirstElement());
    }

    protected String getTextFromLabelProvider(Object object) {
        String text = ArchiLabelProvider.INSTANCE.getLabel(object);
        if (StringUtils.isSet(text)) {
            return this.normalise(text);
        }
        ILabelProvider labelProvider = (ILabelProvider)Adapters.adapt((Object)object, ILabelProvider.class);
        if (labelProvider != null && StringUtils.isSet(text = labelProvider.getText(object))) {
            return this.normalise(text);
        }
        return " ";
    }

    protected String getArchimateConceptText(IArchimateConcept concept) {
        Object text = "";
        String name = this.normalise(concept.getName());
        String typeName = ArchiLabelProvider.INSTANCE.getDefaultName(concept.eClass());
        text = StringUtils.isSet(name) ? name + " (" + typeName + ")" : typeName;
        if (concept instanceof IArchimateRelationship) {
            IArchimateRelationship relationship = (IArchimateRelationship)concept;
            text = (String)text + " (";
            text = (String)text + this.normalise(ArchiLabelProvider.INSTANCE.getLabel(relationship.getSource()));
            text = (String)text + " - ";
            text = (String)text + this.normalise(ArchiLabelProvider.INSTANCE.getLabel(relationship.getTarget()));
            text = (String)text + ")";
        }
        return text;
    }

    protected String normalise(String text) {
        return StringUtils.normaliseNewLineCharacters(StringUtils.escapeAmpersandsInText(text));
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

