/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IFeatures;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class PropertySectionTextControl {
    private Control fTextControl;
    private EObject fDataElement;
    private EAttribute fEAttribute;
    private String fFeatureName;
    private Listener eventListener = this::handleEvent;

    public PropertySectionTextControl(Control textControl, EAttribute eAttribute) {
        this.init(textControl);
        this.fEAttribute = eAttribute;
    }

    public PropertySectionTextControl(Control textControl, String featureName) {
        this.init(textControl);
        this.fFeatureName = featureName;
    }

    private void init(Control textControl) {
        this.fTextControl = textControl;
        textControl.addListener(16, this.eventListener);
        textControl.addListener(14, this.eventListener);
        textControl.addDisposeListener(event -> {
            textControl.removeListener(16, this.eventListener);
            textControl.removeListener(14, this.eventListener);
            this.fDataElement = null;
        });
    }

    @Deprecated
    public void setHint(String hint) {
    }

    public Control getTextControl() {
        return this.fTextControl;
    }

    public void setEditable(boolean editable) {
        if (this.isStyledTextControl()) {
            ((StyledText)this.getTextControl()).setEditable(editable);
        } else {
            ((Text)this.getTextControl()).setEditable(editable);
        }
    }

    public void refresh(EObject dataElement) {
        this.fDataElement = dataElement;
        this.setText(this.getTextFromDataElement());
    }

    private void handleEvent(Event event) {
        String oldText;
        String newText = this.getText();
        if (!newText.equals(oldText = this.getTextFromDataElement())) {
            this.textChanged(oldText, newText);
        }
    }

    private String getTextFromDataElement() {
        if (this.fDataElement != null && this.fEAttribute != null) {
            return StringUtils.safeString((String)this.fDataElement.eGet((EStructuralFeature)this.fEAttribute));
        }
        if (this.fDataElement instanceof IFeatures && this.fFeatureName != null) {
            return StringUtils.safeString(((IFeatures)this.fDataElement).getFeatures().getString(this.fFeatureName, ""));
        }
        return "";
    }

    private String getText() {
        if (this.isStyledTextControl()) {
            return ((StyledText)this.getTextControl()).getText();
        }
        return ((Text)this.getTextControl()).getText();
    }

    private void setText(String s) {
        if (this.isStyledTextControl()) {
            ((StyledText)this.getTextControl()).setText(s);
        } else {
            ((Text)this.getTextControl()).setText(s);
        }
    }

    private boolean isSingleTextControl() {
        return (this.getTextControl().getStyle() & 4) != 0;
    }

    private boolean isStyledTextControl() {
        return this.getTextControl() instanceof StyledText;
    }

    protected void textChanged(String oldText, String newText) {
    }
}

