/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.TextAlignmentCommand;
import com.archimatetool.editor.diagram.commands.TextPositionCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.GridLayoutColumnHandler;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.ITextAlignment;
import com.archimatetool.model.ITextPosition;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TextAlignmentSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private Composite parentComposite;
    private Composite textPositionComposite;
    private Button[] fAlignmentButtons = new Button[3];
    private Button[] fPositionButtons = new Button[3];

    @Override
    protected void createControls(Composite parent) {
        this.parentComposite = parent;
        ((GridLayout)parent.getLayout()).horizontalSpacing = 30;
        Composite textAlignmentComposite = this.createComposite(parent, 2, false);
        this.createTextAlignmentControls(textAlignmentComposite);
        this.textPositionComposite = this.createComposite(parent, 2, false);
        this.createTextPositionControls(this.textPositionComposite);
        GridLayoutColumnHandler.create(parent, 2).updateColumns();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createTextAlignmentControls(Composite parent) {
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < TextAlignmentSection.this.fAlignmentButtons.length) {
                    TextAlignmentSection.this.fAlignmentButtons[i].setSelection(e.widget == TextAlignmentSection.this.fAlignmentButtons[i]);
                    if (TextAlignmentSection.this.fAlignmentButtons[i] == e.widget) {
                        int alignment = (Integer)TextAlignmentSection.this.fAlignmentButtons[i].getData();
                        CompoundCommand result = new CompoundCommand();
                        for (EObject eObject : TextAlignmentSection.this.getEObjects()) {
                            TextAlignmentCommand cmd;
                            if (((ITextAlignment)eObject).getTextAlignment() == alignment || !TextAlignmentSection.this.isAlive(eObject) || !(cmd = new TextAlignmentCommand((ITextAlignment)eObject, alignment)).canExecute()) continue;
                            result.add((Command)cmd);
                        }
                        TextAlignmentSection.this.executeCommand(result.unwrap());
                    }
                    ++i;
                }
            }
        };
        this.createLabel(parent, Messages.TextAlignmentSection_0, 115, 0x1000000);
        Composite client = this.createComposite(parent, 3);
        int i = 0;
        while (i < this.fAlignmentButtons.length) {
            this.fAlignmentButtons[i] = new Button(client, 0x800002);
            if (!PlatformUtils.isLinux()) {
                this.getWidgetFactory().adapt((Control)this.fAlignmentButtons[i], true, true);
            }
            this.fAlignmentButtons[i].addSelectionListener((SelectionListener)adapter);
            ++i;
        }
        this.fAlignmentButtons[0].setImage(IArchiImages.ImageFactory.getImage("img/alignleft.png"));
        this.fAlignmentButtons[0].setData((Object)1);
        this.fAlignmentButtons[1].setImage(IArchiImages.ImageFactory.getImage("img/aligncenter.png"));
        this.fAlignmentButtons[1].setData((Object)2);
        this.fAlignmentButtons[2].setImage(IArchiImages.ImageFactory.getImage("img/alignright.png"));
        this.fAlignmentButtons[2].setData((Object)4);
    }

    private void createTextPositionControls(Composite parent) {
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < TextAlignmentSection.this.fPositionButtons.length) {
                    TextAlignmentSection.this.fPositionButtons[i].setSelection(e.widget == TextAlignmentSection.this.fPositionButtons[i]);
                    if (TextAlignmentSection.this.fPositionButtons[i] == e.widget) {
                        int position = (Integer)TextAlignmentSection.this.fPositionButtons[i].getData();
                        CompoundCommand result = new CompoundCommand();
                        for (EObject eObject : TextAlignmentSection.this.getEObjects()) {
                            TextPositionCommand cmd;
                            ITextPosition textPosition;
                            if (!(eObject instanceof ITextPosition) || (textPosition = (ITextPosition)eObject).getTextPosition() == position || !TextAlignmentSection.this.isAlive((EObject)textPosition) || !(cmd = new TextPositionCommand(textPosition, position)).canExecute()) continue;
                            result.add((Command)cmd);
                        }
                        TextAlignmentSection.this.executeCommand(result.unwrap());
                    }
                    ++i;
                }
            }
        };
        this.createLabel(parent, Messages.TextPositionSection_3 + ":", 115, 0x1000000);
        Composite client = this.createComposite(parent, 3);
        int i = 0;
        while (i < this.fPositionButtons.length) {
            this.fPositionButtons[i] = new Button(client, 0x800002);
            if (!PlatformUtils.isLinux()) {
                this.getWidgetFactory().adapt((Control)this.fPositionButtons[i], true, true);
            }
            this.fPositionButtons[i].addSelectionListener((SelectionListener)adapter);
            ++i;
        }
        this.fPositionButtons[0].setImage(IArchiImages.ImageFactory.getImage("img/aligntop.png"));
        this.fPositionButtons[0].setData((Object)0);
        this.fPositionButtons[1].setImage(IArchiImages.ImageFactory.getImage("img/alignmiddle.png"));
        this.fPositionButtons[1].setData((Object)1);
        this.fPositionButtons[2].setImage(IArchiImages.ImageFactory.getImage("img/alignbottom.png"));
        this.fPositionButtons[2].setData((Object)2);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.TEXT_ALIGNMENT__TEXT_ALIGNMENT) {
            this.updateTextAlignmentControls();
        } else if (feature == IArchimatePackage.Literals.TEXT_POSITION__TEXT_POSITION) {
            this.updateTextPositionControls();
        } else if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        this.updateTextAlignmentControls();
        this.updateTextPositionControls();
    }

    private void updateTextAlignmentControls() {
        if (this.fIsExecutingCommand) {
            return;
        }
        IArchimateModelObject firstSelected = this.getFirstSelectedObject();
        if (firstSelected instanceof ITextAlignment) {
            int i = 0;
            while (i < this.fAlignmentButtons.length) {
                this.fAlignmentButtons[i].setSelection(this.fAlignmentButtons[i] == this.getAlignmentButton());
                this.fAlignmentButtons[i].setEnabled(!this.isLocked(firstSelected));
                ++i;
            }
        }
    }

    private void updateTextPositionControls() {
        if (this.fIsExecutingCommand) {
            return;
        }
        boolean shouldShow = true;
        for (IArchimateModelObject eObject : this.getEObjects()) {
            if (eObject instanceof ITextPosition) continue;
            shouldShow = false;
            break;
        }
        if (shouldShow) {
            if (this.textPositionComposite == null) {
                this.textPositionComposite = this.createComposite(this.parentComposite, 2, false);
                this.createTextPositionControls(this.textPositionComposite);
            }
            int i = 0;
            while (i < this.fPositionButtons.length) {
                this.fPositionButtons[i].setSelection(this.fPositionButtons[i] == this.getPositionButton());
                this.fPositionButtons[i].setEnabled(!this.isLocked(this.getFirstSelectedObject()));
                ++i;
            }
        } else if (this.textPositionComposite != null) {
            this.textPositionComposite.dispose();
            this.textPositionComposite = null;
        }
    }

    private Button getAlignmentButton() {
        int alignment = ((ITextAlignment)this.getFirstSelectedObject()).getTextAlignment();
        switch (alignment) {
            case 1: {
                return this.fAlignmentButtons[0];
            }
            case 2: {
                return this.fAlignmentButtons[1];
            }
            case 4: {
                return this.fAlignmentButtons[2];
            }
        }
        return this.fAlignmentButtons[1];
    }

    private Button getPositionButton() {
        int position = ((ITextPosition)this.getFirstSelectedObject()).getTextPosition();
        switch (position) {
            case 0: {
                return this.fPositionButtons[0];
            }
            case 1: {
                return this.fPositionButtons[1];
            }
            case 2: {
                return this.fPositionButtons[2];
            }
        }
        return this.fPositionButtons[1];
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof ITextAlignment && this.shouldExposeFeature((EObject)object, IArchimatePackage.Literals.TEXT_ALIGNMENT__TEXT_ALIGNMENT.getName()) || object instanceof ITextPosition && this.shouldExposeFeature((EObject)object, IArchimatePackage.Literals.TEXT_POSITION__TEXT_POSITION.getName());
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelComponent.class;
        }
    }
}

