/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.propertysections.PropertySectionTextControl;
import com.archimatetool.editor.ui.components.StyledTextControl;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ITextContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TextContentSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private PropertySectionTextControl fTextContentControl;

    @Override
    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.TextContentSection_0, 115, 0);
        StyledTextControl styledTextControl = this.createStyledTextControl(parent, 0);
        styledTextControl.setMessage(Messages.TextContentSection_2);
        this.fTextContentControl = new PropertySectionTextControl((Control)styledTextControl.getControl(), IArchimatePackage.Literals.TEXT_CONTENT__CONTENT){

            @Override
            protected void textChanged(String oldText, String newText) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : TextContentSection.this.getEObjects()) {
                    EObjectFeatureCommand cmd;
                    if (!TextContentSection.this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(Messages.TextContentSection_1, eObject, (EStructuralFeature)IArchimatePackage.Literals.TEXT_CONTENT__CONTENT, newText)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                TextContentSection.this.executeCommand(result.unwrap());
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fTextContentControl.getTextControl(), HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.TEXT_CONTENT__CONTENT || feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        if (this.fIsExecutingCommand) {
            return;
        }
        this.fTextContentControl.refresh((EObject)this.getFirstSelectedObject());
        this.fTextContentControl.setEditable(!this.isLocked(this.getFirstSelectedObject()));
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof ITextContent;
        }

        @Override
        public Class<?> getAdaptableType() {
            return ITextContent.class;
        }
    }
}

