/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class UsedInRelationshipsSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.usedInRelationshipsSection";
    private IArchimateConcept fArchimateConcept;
    private TableViewer fTableViewer;

    @Override
    protected void createControls(Composite parent) {
        this.createTableControl(parent);
    }

    private void createTableControl(Composite parent) {
        this.createLabel(parent, Messages.UsedInRelationshipsSection_0, 115, 0);
        Composite tableComp = this.createTableComposite(parent, 0);
        TableColumnLayout tableLayout = (TableColumnLayout)tableComp.getLayout();
        this.fTableViewer = new TableViewer(tableComp, 67586);
        ThemeUtils.registerCssId((Control)this.fTableViewer.getTable(), "AnalysisTable");
        ThemeUtils.setFontIfCssThemingDisabled((Control)this.fTableViewer.getTable(), "com.archimatetool.editor.ANALYSIS_TABLE_FONT");
        TableViewerColumn column = new TableViewerColumn(this.fTableViewer, 0, 0);
        tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
        this.fTableViewer.getTable().setLinesVisible(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fTableViewer.getTable(), HELP_ID);
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)((IArchimateConcept)inputElement)).toArray();
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new UsedInRelationshipsTableLabelProvider());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeModelView view;
                IArchimateRelationship relation;
                Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (object instanceof IArchimateRelationship && UsedInRelationshipsSection.this.isAlive((EObject)(relation = (IArchimateRelationship)object)) && (view = (ITreeModelView)ViewManager.findViewPart("com.archimatetool.editor.treeModelView")) != null) {
                    view.getViewer().setSelection((ISelection)new StructuredSelection((Object)relation), true);
                }
            }
        });
        this.fTableViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        this.fTableViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(UsedInRelationshipsSection.this.fTableViewer.getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        });
    }

    @Override
    protected void update() {
        this.fArchimateConcept = (IArchimateConcept)this.getFirstSelectedObject();
        this.fTableViewer.setInput((Object)this.fArchimateConcept);
        Display.getCurrent().asyncExec(() -> {
            if (!this.fTableViewer.getTable().isDisposed()) {
                this.fTableViewer.getTable().getParent().layout();
            }
        });
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IArchimateConcept;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IArchimateConcept.class;
        }
    }

    private static class UsedInRelationshipsTableLabelProvider
    extends LabelProvider
    implements IFontProvider {
        Font fontItalic = FontFactory.SystemFontItalic;

        private UsedInRelationshipsTableLabelProvider() {
        }

        public String getText(Object element) {
            IArchimateRelationship relationship = (IArchimateRelationship)element;
            String name = ArchiLabelProvider.INSTANCE.getLabel(relationship) + " (";
            name = name + ArchiLabelProvider.INSTANCE.getLabel(relationship.getSource());
            name = name + " - ";
            name = name + ArchiLabelProvider.INSTANCE.getLabel(relationship.getTarget());
            name = name + ")";
            return name;
        }

        public Image getImage(Object element) {
            return ArchiLabelProvider.INSTANCE.getImage(element);
        }

        public Font getFont(Object element) {
            if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("highlightUnusedElementsInModelTree") && element instanceof IArchimateConcept && !DiagramModelUtils.isArchimateConceptReferencedInDiagrams((IArchimateConcept)element)) {
                return this.fontItalic;
            }
            return null;
        }
    }
}

