/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModel;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class UsedInViewsSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.usedInViewsSection";
    private IArchimateConcept fArchimateConcept;
    private TableViewer fTableViewer;

    @Override
    protected void createControls(Composite parent) {
        this.createTableControl(parent);
    }

    private void createTableControl(Composite parent) {
        this.createLabel(parent, Messages.UsedInViewsSection_0, 115, 0);
        Composite tableComp = this.createTableComposite(parent, 0);
        TableColumnLayout tableLayout = (TableColumnLayout)tableComp.getLayout();
        this.fTableViewer = new TableViewer(tableComp, 67584);
        ThemeUtils.registerCssId((Control)this.fTableViewer.getTable(), "AnalysisTable");
        ThemeUtils.setFontIfCssThemingDisabled((Control)this.fTableViewer.getTable(), "com.archimatetool.editor.ANALYSIS_TABLE_FONT");
        TableViewerColumn column = new TableViewerColumn(this.fTableViewer, 0, 0);
        tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
        this.fTableViewer.getTable().setLinesVisible(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fTableViewer.getTable(), HELP_ID);
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DiagramModelUtils.findReferencedDiagramsForArchimateConcept((IArchimateConcept)inputElement).toArray();
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text;
                String expression;
                IDiagramModel dm = (IDiagramModel)element;
                if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("useLabelExpressionInAnalysisTable") && (expression = TextRenderer.getDefault().getFormatExpressionFromAncestorFolder((IArchimateModelObject)dm)) != null && (text = StringUtils.normaliseNewLineCharacters(TextRenderer.getDefault().renderWithExpression((IArchimateModelObject)dm, expression))) != null) {
                    return text;
                }
                return dm.getName();
            }

            public Image getImage(Object element) {
                return IArchiImages.ImageFactory.getImage("img/diagram.png");
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IDiagramModelEditor editor;
                if (!UsedInViewsSection.this.isAlive((EObject)UsedInViewsSection.this.fArchimateConcept)) {
                    return;
                }
                IDiagramModel diagramModel = (IDiagramModel)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (diagramModel != null && (editor = EditorManager.openDiagramEditor(diagramModel, false)) != null) {
                    UsedInViewsSection.this.getPart().getSite().getShell().getDisplay().asyncExec(() -> editor.selectObjects(new Object[]{UsedInViewsSection.this.fArchimateConcept}));
                }
            }
        });
        this.fTableViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
    }

    @Override
    protected void update() {
        this.fArchimateConcept = (IArchimateConcept)this.getFirstSelectedObject();
        this.fTableViewer.setInput((Object)this.fArchimateConcept);
        Display.getCurrent().asyncExec(() -> {
            if (!this.fTableViewer.getTable().isDisposed()) {
                this.fTableViewer.getTable().getParent().layout();
            }
        });
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IArchimateConcept;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IArchimateConcept.class;
        }
    }
}

