/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.model.commands.EObjectNonNotifyingCompoundCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.propertysections.UserPropertiesManagerDialog;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.components.GlobalActionDisablementHandler;
import com.archimatetool.editor.ui.components.StringComboBoxCellEditor;
import com.archimatetool.editor.ui.dialog.UserPropertiesKeySelectionDialog;
import com.archimatetool.editor.utils.HTMLUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.net.MalformedURLException;
import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class UserPropertiesSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.userProperties";
    private List<IProperties> fPropertiesElements = new ArrayList<IProperties>();
    private TableViewer fTableViewer;
    private IAction fActionNewProperty;
    private IAction fActionNewMultipleProperties;
    private IAction fActionRemoveProperties;
    private IAction fActionShowKeyEditor;
    private boolean ignoreMessages;
    private static final String multipleValuesIndicator = UUID.randomUUID().toString();
    private static final int MAX_ITEMS_COMBO = 20000;
    private static final int MAX_ITEMS_ALL = -1;
    private boolean fDragSourceValid;

    @Override
    protected void createControls(Composite parent) {
        this.createTableControl(parent);
        this.createActionsAndToolbar(parent);
        ((LightweightEContentAdapter)this.getECoreAdapter()).addClass(IProperty.class);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
        if (msg.getEventType() == 999) {
            this.ignoreMessages = true;
            return;
        }
        if (msg.getEventType() == 1000) {
            this.ignoreMessages = false;
            this.fTableViewer.refresh();
        }
        if (!this.ignoreMessages) {
            Object feature = msg.getFeature();
            if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
                this.updateLocked();
            }
            if (feature == IArchimatePackage.Literals.PROPERTIES__PROPERTIES) {
                this.fTableViewer.refresh();
            }
            if (feature == IArchimatePackage.Literals.PROPERTY__KEY || feature == IArchimatePackage.Literals.PROPERTY__VALUE) {
                if (this.isMultiSelection()) {
                    this.fTableViewer.refresh();
                } else {
                    this.fTableViewer.update(msg.getNotifier(), null);
                }
            }
        }
    }

    @Override
    protected void addAdapter() {
        if (this.getEObjects() != null && this.getECoreAdapter() != null) {
            for (IArchimateModelObject eObject : this.getEObjects()) {
                if (eObject.eAdapters().contains((Object)this.getECoreAdapter())) continue;
                eObject.eAdapters().add((Object)this.getECoreAdapter());
            }
        }
    }

    @Override
    protected void removeAdapter() {
        if (this.getEObjects() != null && this.getECoreAdapter() != null) {
            for (IArchimateModelObject eObject : this.getEObjects()) {
                eObject.eAdapters().remove((Object)this.getECoreAdapter());
            }
        }
    }

    @Override
    protected void update() {
        this.fPropertiesElements = new ArrayList<IProperties>();
        for (IArchimateModelObject obj : this.getEObjects()) {
            if (!(obj instanceof IProperties)) continue;
            IProperties p = (IProperties)obj;
            this.fPropertiesElements.add(p);
        }
        this.fTableViewer.setInput(this.fPropertiesElements);
        this.fTableViewer.getTable().getParent().layout();
        this.updateLocked();
    }

    private void updateLocked() {
        boolean locked = this.isLocked(this.getFirstSelectedObject());
        this.fTableViewer.getTable().setEnabled(!locked);
        this.fActionNewProperty.setEnabled(!locked);
        this.fActionRemoveProperties.setEnabled(!locked && !this.fTableViewer.getSelection().isEmpty());
        this.fActionNewMultipleProperties.setEnabled(!locked);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void createTableControl(Composite parent) {
        Composite tableComp = this.createTableComposite(parent, 0);
        TableColumnLayout tableLayout = (TableColumnLayout)tableComp.getLayout();
        this.fTableViewer = new TableViewer(tableComp, 67586);
        ThemeUtils.registerCssId((Control)this.fTableViewer.getTable(), "UserPropertiesTable");
        ThemeUtils.setFontIfCssThemingDisabled((Control)this.fTableViewer.getTable(), "com.archimatetool.editor.PROPERTIES_TABLE_FONT");
        TableViewerEditor.create((TableViewer)this.fTableViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return super.isEditorActivationEvent(event) || event.eventType == 3;
            }
        }, (int)122);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        this.addDragSupport();
        this.addDropSupport();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fTableViewer.getTable(), HELP_ID);
        TableViewerColumn columnBlank = new TableViewerColumn(this.fTableViewer, 0, 0);
        tableLayout.setColumnData((Widget)columnBlank.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, false));
        columnBlank.getColumn().setWidth(38);
        TableViewerColumn columnKey = new TableViewerColumn(this.fTableViewer, 0, 1);
        columnKey.getColumn().setText(Messages.UserPropertiesSection_0);
        tableLayout.setColumnData((Widget)columnKey.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, true));
        columnKey.setEditingSupport((EditingSupport)new KeyEditingSupport((ColumnViewer)this.fTableViewer));
        columnKey.getColumn().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UserPropertiesSection.this.sortKeys();
            }
        });
        TableViewerColumn columnValue = new TableViewerColumn(this.fTableViewer, 0, 2);
        columnValue.getColumn().setText(Messages.UserPropertiesSection_1);
        tableLayout.setColumnData((Widget)columnValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(67, true));
        columnValue.setEditingSupport((EditingSupport)new ValueEditingSupport((ColumnViewer)this.fTableViewer));
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelCellProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTableViewer);
        this.fTableViewer.addSelectionChangedListener(e -> this.fActionRemoveProperties.setEnabled(!e.getSelection().isEmpty()));
        this.fTableViewer.getTable().addMouseListener(MouseListener.mouseDoubleClickAdapter(e -> {
            Rectangle rect;
            Point pt = new Point(e.x, e.y);
            TableItem item = this.fTableViewer.getTable().getItem(pt);
            if (item == null) {
                this.fActionNewProperty.run();
            } else if (item.getData() instanceof IProperty && (rect = item.getBounds(0)).contains(pt)) {
                this.handleDoubleClick((IProperty)item.getData());
            }
        }));
        this.fTableViewer.getTable().addKeyListener(KeyListener.keyPressedAdapter(e -> {
            Object selected;
            if (e.keyCode == 13 && (selected = this.fTableViewer.getStructuredSelection().getFirstElement()) != null) {
                this.fTableViewer.editElement(selected, 1);
            }
        }));
    }

    private void createActionsAndToolbar(Composite parent) {
        this.fActionNewProperty = new NewPropertyAction();
        this.fActionNewMultipleProperties = new NewMultiplePropertiesAction();
        this.fActionRemoveProperties = new RemovePropertiesAction();
        this.fActionShowKeyEditor = new ShowKeyEditorAction();
        ToolBar toolBar = new ToolBar(parent, 0x800200);
        this.getWidgetFactory().adapt((Composite)toolBar);
        GridDataFactory.fillDefaults().align(0x1000008, 128).applyTo((Control)toolBar);
        ToolBarManager toolBarmanager = new ToolBarManager(toolBar);
        toolBarmanager.add(this.fActionNewProperty);
        toolBarmanager.add(this.fActionNewMultipleProperties);
        toolBarmanager.add(this.fActionRemoveProperties);
        toolBarmanager.add(this.fActionShowKeyEditor);
        toolBarmanager.update(true);
        MenuManager menuMgr = new MenuManager("#PropertiesPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            manager.add(this.fActionNewProperty);
            manager.add(this.fActionNewMultipleProperties);
            manager.add((IContributionItem)new Separator());
            manager.add(this.fActionRemoveProperties);
            manager.add((IContributionItem)new Separator());
            manager.add(this.fActionShowKeyEditor);
        });
        Menu menu = menuMgr.createContextMenu(this.fTableViewer.getControl());
        this.fTableViewer.getControl().setMenu(menu);
    }

    private void sortKeys() {
        if (!this.isMultiSelection() && this.isAlive((EObject)this.getFirstSelectedElement())) {
            this.executeCommand(new SortPropertiesCommand((EList<IProperty>)this.getFirstSelectedElement().getProperties()));
        }
    }

    private void handleDoubleClick(IProperty selected) {
        Matcher matcher = HTMLUtils.HTML_LINK_PATTERN.matcher(selected.getValue());
        if (matcher.find()) {
            String href = matcher.group();
            try {
                HTMLUtils.openLinkInBrowser(href);
            }
            catch (MalformedURLException | PartInitException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean isMultiSelection() {
        return this.fPropertiesElements.size() > 1;
    }

    private IProperties getFirstSelectedElement() {
        return this.fPropertiesElements.size() == 0 ? null : this.fPropertiesElements.get(0);
    }

    private List<IProperty> getCommonProperties() {
        ArrayList<IProperty> properties = new ArrayList<IProperty>();
        LinkedHashMap map = new LinkedHashMap();
        for (IProperties iProperties : this.fPropertiesElements) {
            for (IProperty property : iProperties.getProperties()) {
                property = this.getFirstMatchingProperty((List<IProperty>)iProperties.getProperties(), property);
                AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)map.get(property.getKey());
                if (entry == null) {
                    entry = new AbstractMap.SimpleEntry(new HashSet(), new HashSet());
                    map.put(property.getKey(), entry);
                }
                ((Set)entry.getKey()).add(property.getValue());
                ((Set)entry.getValue()).add(iProperties);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            IProperty property;
            if (((Set)((Map.Entry)entry.getValue()).getValue()).size() != this.fPropertiesElements.size()) continue;
            property = IArchimateFactory.eINSTANCE.createProperty((String)entry.getKey(), ((Set)((Map.Entry)entry.getValue()).getKey()).size() == 1 ? (String)((Set)((Map.Entry)entry.getValue()).getKey()).iterator().next() : multipleValuesIndicator);
            properties.add(property);
        }
        return properties;
    }

    private IProperty getFirstMatchingProperty(List<IProperty> properties, IProperty property) {
        for (IProperty p : properties) {
            if (!Objects.equals(p.getKey(), property.getKey())) continue;
            return p;
        }
        return null;
    }

    private IArchimateModel getArchimateModel() {
        if (this.getFirstSelectedElement() instanceof IArchimateModelObject) {
            return ((IArchimateModelObject)this.getFirstSelectedElement()).getArchimateModel();
        }
        return null;
    }

    private String[] getAllUniquePropertyKeysForModel(int maxSize) {
        IArchimateModel model = this.getArchimateModel();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof IProperty)) continue;
            IProperty p = (IProperty)element;
            if (maxSize != -1 && set.size() > maxSize) break;
            String key = p.getKey();
            if (!StringUtils.isSetAfterTrim(key)) continue;
            set.add(key);
        }
        String[] items = set.toArray(new String[set.size()]);
        Arrays.sort(items, (s1, s2) -> s1.compareToIgnoreCase((String)s2));
        return items;
    }

    private String[] getAllUniquePropertyValuesForKeyForModel(String key, int maxSize) {
        IArchimateModel model = this.getArchimateModel();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            String value;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IProperty)) continue;
            IProperty p = (IProperty)element;
            if (maxSize != -1 && set.size() > maxSize) break;
            if (!p.getKey().equals(key) || !StringUtils.isSetAfterTrim(value = p.getValue())) continue;
            set.add(value);
        }
        String[] items = set.toArray(new String[set.size()]);
        Arrays.sort(items, (s1, s2) -> s1.compareToIgnoreCase((String)s2));
        return items;
    }

    private void hookCellEditorGlobalActionHandler(CellEditor cellEditor) {
        Listener listener = new Listener(){
            GlobalActionDisablementHandler propertiesViewGlobalActionHandler;
            GlobalActionDisablementHandler globalActionHandler;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 26: {
                        IActionBars actionBars = UserPropertiesSection.this.fPage.getSite().getActionBars();
                        this.propertiesViewGlobalActionHandler = new GlobalActionDisablementHandler(actionBars);
                        this.propertiesViewGlobalActionHandler.clearGlobalActions();
                        this.globalActionHandler = new GlobalActionDisablementHandler();
                        this.globalActionHandler.update();
                        break;
                    }
                    case 27: {
                        if (this.propertiesViewGlobalActionHandler == null) break;
                        this.propertiesViewGlobalActionHandler.restoreGlobalActions();
                        this.globalActionHandler.update();
                        break;
                    }
                }
            }
        };
        cellEditor.getControl().addListener(26, listener);
        cellEditor.getControl().addListener(27, listener);
    }

    private void addDragSupport() {
        int operations = 2;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.fTableViewer.addDragSupport(operations, transferTypes, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                UserPropertiesSection.this.fDragSourceValid = false;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }

            public void dragStart(DragSourceEvent event) {
                if (UserPropertiesSection.this.isMultiSelection()) {
                    event.doit = false;
                } else if (UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement())) {
                    IStructuredSelection selection = (IStructuredSelection)UserPropertiesSection.this.fTableViewer.getSelection();
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                    event.doit = true;
                    UserPropertiesSection.this.fDragSourceValid = true;
                }
            }
        });
    }

    private void addDropSupport() {
        int operations = 2;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.fTableViewer.addDropSupport(operations, transferTypes, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
                event.feedback = event.detail == 0 ? 0 : UserPropertiesSection.this.getDragFeedbackType(event);
                event.feedback |= 8;
            }

            public void drop(DropTargetEvent event) {
                UserPropertiesSection.this.doDropOperation(event);
            }

            public void dropAccept(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
            }

            private int getEventDetail(DropTargetEvent event) {
                return UserPropertiesSection.this.fDragSourceValid ? 2 : 0;
            }
        });
    }

    private void doDropOperation(DropTargetEvent event) {
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            return;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        int index = this.getDropTargetPosition(event);
        List list = ((IStructuredSelection)selection).toList();
        for (Object o : list) {
            IProperty property = (IProperty)o;
            int movedIndex = this.getFirstSelectedElement().getProperties().indexOf((Object)property);
            if (movedIndex != index && movedIndex + 1 != index) continue;
            return;
        }
        this.movePropertiesToIndex(list, index);
    }

    private void movePropertiesToIndex(List<IProperty> propertiesToMove, int index) {
        EList properties = this.getFirstSelectedElement().getProperties();
        if (index < 0) {
            index = 0;
        }
        if (index > properties.size()) {
            index = properties.size();
        }
        CompoundCommand compoundCmd = new CompoundCommand(Messages.UserPropertiesSection_8);
        for (IProperty property : propertiesToMove) {
            int oldIndex = properties.indexOf((Object)property);
            if (index > oldIndex) {
                --index;
            }
            if (index == oldIndex) break;
            compoundCmd.add((Command)new MovePropertyCommand((EList<IProperty>)properties, property, index));
            ++index;
        }
        this.executeCommand(compoundCmd.unwrap());
    }

    private int getDropTargetPosition(DropTargetEvent event) {
        int index = -1;
        Point pt = this.fTableViewer.getControl().toControl(event.x, event.y);
        if (pt.y < 5) {
            index = 0;
        } else if (event.item != null) {
            IProperty property = (IProperty)event.item.getData();
            index = this.getFirstSelectedElement().getProperties().indexOf((Object)property);
        } else {
            index = this.getFirstSelectedElement().getProperties().size();
        }
        int feedback = this.getDragFeedbackType(event);
        if (feedback == 4) {
            ++index;
        }
        return index;
    }

    private int getDragFeedbackType(DropTargetEvent event) {
        if (event.item == null) {
            return 0;
        }
        Rectangle rect = ((TableItem)event.item).getBounds();
        Point pt = this.fTableViewer.getControl().toControl(event.x, event.y);
        if (pt.y < rect.y + 3) {
            return 2;
        }
        if (pt.y > rect.y + rect.height - 3) {
            return 4;
        }
        return 0;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IProperties;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IProperties.class;
        }
    }

    private class KeyEditingSupport
    extends EditingSupport {
        StringComboBoxCellEditor cellEditor;

        public KeyEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = new StringComboBoxCellEditor((Composite)viewer.getControl(), new String[0], true);
            UserPropertiesSection.this.hookCellEditorGlobalActionHandler((CellEditor)this.cellEditor);
        }

        protected CellEditor getCellEditor(Object element) {
            String[] items = UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement()) ? UserPropertiesSection.this.getAllUniquePropertyKeysForModel(20000) : new String[]{};
            this.cellEditor.setItems(items);
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((IProperty)element).getKey();
        }

        protected void setValue(Object element, Object value) {
            CompoundCommand compoundCmd = new CompoundCommand();
            for (IProperties propertiesElement : UserPropertiesSection.this.fPropertiesElements) {
                EObjectFeatureCommand cmd;
                IProperty property = (IProperty)element;
                if (!UserPropertiesSection.this.isAlive((EObject)propertiesElement)) continue;
                if (UserPropertiesSection.this.isMultiSelection()) {
                    property = UserPropertiesSection.this.getFirstMatchingProperty((List<IProperty>)propertiesElement.getProperties(), property);
                }
                if (property == null || !(cmd = new EObjectFeatureCommand(Messages.UserPropertiesSection_10, (EObject)property, (EStructuralFeature)IArchimatePackage.Literals.PROPERTY__KEY, value)).canExecute()) continue;
                compoundCmd.add((Command)cmd);
            }
            if (UserPropertiesSection.this.isMultiSelection()) {
                try {
                    UserPropertiesSection.this.ignoreMessages = true;
                    UserPropertiesSection.this.executeCommand(compoundCmd.unwrap());
                    ((IProperty)element).setKey((String)value);
                    UserPropertiesSection.this.fTableViewer.update(element, null);
                }
                finally {
                    UserPropertiesSection.this.ignoreMessages = false;
                }
            } else {
                UserPropertiesSection.this.executeCommand(compoundCmd.unwrap());
            }
        }
    }

    private static class LabelCellProvider
    extends CellLabelProvider {
        private LabelCellProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getColumnText(cell.getElement(), cell.getColumnIndex()));
            cell.setForeground(this.getForeground(cell.getElement(), cell.getColumnIndex()));
            cell.setImage(this.getColumnImage(cell.getElement(), cell.getColumnIndex()));
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.isLink(element) ? IArchiImages.ImageFactory.getImage("img/browser.png") : null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    String key = ((IProperty)element).getKey();
                    return StringUtils.isSetAfterTrim(key) ? key : Messages.UserPropertiesSection_9;
                }
                case 2: {
                    String value = ((IProperty)element).getValue();
                    return multipleValuesIndicator.equals(value) ? Messages.UserPropertiesSection_22 : value;
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 2) {
                return this.isLink(element) ? ColorConstants.blue : null;
            }
            return null;
        }

        public String getToolTipText(Object element) {
            return this.isLink(element) ? Messages.UserPropertiesSection_21 : null;
        }

        private boolean isLink(Object element) {
            Matcher matcher = HTMLUtils.HTML_LINK_PATTERN.matcher(((IProperty)element).getValue());
            return matcher.find();
        }
    }

    private static class MovePropertyCommand
    extends Command {
        private EList<IProperty> properties;
        private IProperty property;
        private int oldIndex;
        private int newIndex;

        MovePropertyCommand(EList<IProperty> properties, IProperty property, int newIndex) {
            this.properties = properties;
            this.property = property;
            this.newIndex = newIndex;
            this.setLabel(Messages.UserPropertiesSection_13);
        }

        public void execute() {
            this.oldIndex = this.properties.indexOf((Object)this.property);
            this.properties.move(this.newIndex, (Object)this.property);
        }

        public void undo() {
            this.properties.move(this.oldIndex, (Object)this.property);
        }

        public void dispose() {
            this.properties = null;
            this.property = null;
        }
    }

    private static class MultipleAddDialog
    extends UserPropertiesKeySelectionDialog {
        public MultipleAddDialog(Shell parentShell, List<String> keys) {
            super(parentShell, keys, null);
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.setTitle(Messages.UserPropertiesSection_16);
            this.setMessage(Messages.UserPropertiesSection_17);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.UserPropertiesSection_6, true);
            this.createButton(parent, 1024, Messages.UserPropertiesSection_23, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            if (this.keys.size() == 0) {
                this.getButton(1024).setEnabled(false);
            }
        }
    }

    private class NewMultiplePropertiesAction
    extends Action {
        private NewMultiplePropertiesAction() {
            super(Messages.UserPropertiesSection_3);
            this.setToolTipText(Messages.UserPropertiesSection_3);
            this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/mutiple.png"));
        }

        public void run() {
            MultipleAddDialog dialog;
            if (UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement()) && (dialog = new MultipleAddDialog(UserPropertiesSection.this.fPage.getSite().getShell(), List.of(UserPropertiesSection.this.getAllUniquePropertyKeysForModel(-1)))).open() != 1) {
                List<String> newKeys = dialog.getSelectedKeys();
                if (newKeys == null || newKeys.isEmpty()) {
                    return;
                }
                CompoundCommand cmd = UserPropertiesSection.this.isMultiSelection() ? new CompoundCommand(Messages.UserPropertiesSection_20) : new EObjectNonNotifyingCompoundCommand((EObject)UserPropertiesSection.this.getFirstSelectedElement(), Messages.UserPropertiesSection_20);
                boolean addUnique = dialog.getReturnCode() == 1024;
                for (IProperties propertiesElement : UserPropertiesSection.this.fPropertiesElements) {
                    if (!UserPropertiesSection.this.isAlive((EObject)propertiesElement)) continue;
                    for (String key : newKeys) {
                        if (addUnique && this.hasPropertyKey(propertiesElement, key)) continue;
                        IProperty property = IArchimateFactory.eINSTANCE.createProperty(key, "");
                        cmd.add((Command)new NewPropertyCommand((EList<IProperty>)propertiesElement.getProperties(), property, -1));
                    }
                }
                UserPropertiesSection.this.executeCommand(cmd.unwrap());
            }
        }

        private boolean hasPropertyKey(IProperties propertiesElement, String key) {
            for (IProperty property : propertiesElement.getProperties()) {
                if (!key.equals(property.getKey())) continue;
                return true;
            }
            return false;
        }
    }

    private class NewPropertyAction
    extends Action {
        private NewPropertyAction() {
            super(Messages.UserPropertiesSection_2);
            this.setToolTipText(Messages.UserPropertiesSection_2);
            this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/plus.png"));
        }

        public void run() {
            UserPropertiesSection.this.fTableViewer.applyEditorValue();
            IProperty newProperty = null;
            if (UserPropertiesSection.this.isMultiSelection()) {
                CompoundCommand cmd = new CompoundCommand();
                for (IProperties propertiesElement : UserPropertiesSection.this.fPropertiesElements) {
                    if (!UserPropertiesSection.this.isAlive((EObject)propertiesElement)) continue;
                    IProperty property = IArchimateFactory.eINSTANCE.createProperty();
                    cmd.add((Command)new NewPropertyCommand((EList<IProperty>)propertiesElement.getProperties(), property, -1));
                }
                UserPropertiesSection.this.executeCommand(cmd.unwrap());
                if (UserPropertiesSection.this.fTableViewer.getTable().getItemCount() > 0) {
                    newProperty = (IProperty)UserPropertiesSection.this.fTableViewer.getElementAt(UserPropertiesSection.this.fTableViewer.getTable().getItemCount() - 1);
                }
            } else if (UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement())) {
                newProperty = IArchimateFactory.eINSTANCE.createProperty();
                int index = -1;
                IProperty selected = (IProperty)((IStructuredSelection)UserPropertiesSection.this.fTableViewer.getSelection()).getFirstElement();
                if (selected != null) {
                    index = UserPropertiesSection.this.getFirstSelectedElement().getProperties().indexOf((Object)selected) + 1;
                }
                UserPropertiesSection.this.executeCommand(new NewPropertyCommand((EList<IProperty>)UserPropertiesSection.this.getFirstSelectedElement().getProperties(), newProperty, index));
            }
            if (newProperty != null) {
                UserPropertiesSection.this.fTableViewer.editElement((Object)newProperty, 1);
            }
        }
    }

    private static class NewPropertyCommand
    extends Command {
        private EList<IProperty> properties;
        private IProperty property;
        private int index;

        NewPropertyCommand(EList<IProperty> properties, IProperty property, int index) {
            this.properties = properties;
            this.property = property;
            this.index = index;
            this.setLabel(Messages.UserPropertiesSection_12);
        }

        public void execute() {
            if (this.index < 0 || this.index > this.properties.size()) {
                this.properties.add((Object)this.property);
            } else {
                this.properties.add(this.index, (Object)this.property);
            }
        }

        public void undo() {
            this.properties.remove((Object)this.property);
        }

        public void dispose() {
            this.properties = null;
            this.property = null;
        }
    }

    private class RemovePropertiesAction
    extends Action {
        private RemovePropertiesAction() {
            super(Messages.UserPropertiesSection_4);
            this.setToolTipText(Messages.UserPropertiesSection_4);
            this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/smallx.png"));
            this.setEnabled(false);
        }

        public void run() {
            CompoundCommand cmd = UserPropertiesSection.this.isMultiSelection() ? new CompoundCommand() : new EObjectNonNotifyingCompoundCommand((EObject)UserPropertiesSection.this.getFirstSelectedElement());
            for (Object o : ((IStructuredSelection)UserPropertiesSection.this.fTableViewer.getSelection()).toList()) {
                IProperty property = (IProperty)o;
                for (IProperties propertiesElement : UserPropertiesSection.this.fPropertiesElements) {
                    if (!UserPropertiesSection.this.isAlive((EObject)propertiesElement)) continue;
                    if (UserPropertiesSection.this.isMultiSelection()) {
                        property = UserPropertiesSection.this.getFirstMatchingProperty((List<IProperty>)propertiesElement.getProperties(), property);
                    }
                    if (property == null) continue;
                    cmd.add((Command)new RemovePropertyCommand((EList<IProperty>)propertiesElement.getProperties(), property));
                }
            }
            UserPropertiesSection.this.executeCommand((Command)cmd);
        }
    }

    private static class RemovePropertyCommand
    extends Command {
        private EList<IProperty> properties;
        private IProperty property;
        private int index;

        RemovePropertyCommand(EList<IProperty> properties, IProperty property) {
            this.properties = properties;
            this.property = property;
            this.setLabel(Messages.UserPropertiesSection_5);
        }

        public void execute() {
            this.index = this.properties.indexOf((Object)this.property);
            if (this.index != -1) {
                this.properties.remove((Object)this.property);
            }
        }

        public void undo() {
            if (this.index != -1) {
                this.properties.add(this.index, (Object)this.property);
            }
        }

        public void dispose() {
            this.properties = null;
            this.property = null;
        }
    }

    private class ShowKeyEditorAction
    extends Action {
        private ShowKeyEditorAction() {
            super(Messages.UserPropertiesSection_7);
            this.setToolTipText(Messages.UserPropertiesSection_7);
            this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/cog.png"));
        }

        public void run() {
            if (UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement())) {
                UserPropertiesManagerDialog dialog = new UserPropertiesManagerDialog(UserPropertiesSection.this.fPage.getSite().getShell(), UserPropertiesSection.this.getArchimateModel());
                dialog.open();
            }
        }
    }

    private static class SortPropertiesCommand
    extends Command {
        private EList<IProperty> properties;
        private List<IProperty> original;
        private Collator collator = Collator.getInstance();

        public SortPropertiesCommand(EList<IProperty> properties) {
            this.setLabel(Messages.UserPropertiesSection_14);
            this.properties = properties;
            this.original = new ArrayList<IProperty>((Collection<IProperty>)properties);
        }

        public boolean canExecute() {
            if (this.properties.size() < 2) {
                return false;
            }
            ArrayList<IProperty> temp = new ArrayList<IProperty>((Collection<IProperty>)this.properties);
            Collections.sort(temp, (p1, p2) -> this.collator.compare(p1.getKey(), p2.getKey()));
            int i = 0;
            while (i < temp.size()) {
                if (temp.get(i) != this.properties.get(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void execute() {
            ECollections.sort(this.properties, (p1, p2) -> this.collator.compare(p1.getKey(), p2.getKey()));
        }

        public void undo() {
            this.properties.clear();
            this.properties.addAll(this.original);
        }

        public void dispose() {
            this.properties = null;
            this.original = null;
            this.collator = null;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (UserPropertiesSection.this.isMultiSelection()) {
                return UserPropertiesSection.this.getCommonProperties().toArray();
            }
            return UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement()) ? UserPropertiesSection.this.getFirstSelectedElement().getProperties().toArray() : new Object[]{};
        }
    }

    private class ValueEditingSupport
    extends EditingSupport {
        StringComboBoxCellEditor cellEditor;

        public ValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = new StringComboBoxCellEditor((Composite)viewer.getControl(), new String[0], true);
            UserPropertiesSection.this.hookCellEditorGlobalActionHandler((CellEditor)this.cellEditor);
        }

        protected CellEditor getCellEditor(Object element) {
            String[] items = UserPropertiesSection.this.isAlive((EObject)UserPropertiesSection.this.getFirstSelectedElement()) ? UserPropertiesSection.this.getAllUniquePropertyValuesForKeyForModel(((IProperty)element).getKey(), 20000) : new String[]{};
            this.cellEditor.setItems(items);
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            String value = ((IProperty)element).getValue();
            return multipleValuesIndicator.equals(value) ? "" : value;
        }

        protected void setValue(Object element, Object value) {
            CompoundCommand compoundCmd = new CompoundCommand();
            for (IProperties propertiesElement : UserPropertiesSection.this.fPropertiesElements) {
                EObjectFeatureCommand cmd;
                IProperty property = (IProperty)element;
                if (!UserPropertiesSection.this.isAlive((EObject)propertiesElement)) continue;
                if (UserPropertiesSection.this.isMultiSelection()) {
                    property = UserPropertiesSection.this.getFirstMatchingProperty((List<IProperty>)propertiesElement.getProperties(), property);
                }
                if (property == null || !(cmd = new EObjectFeatureCommand(Messages.UserPropertiesSection_11, (EObject)property, (EStructuralFeature)IArchimatePackage.Literals.PROPERTY__VALUE, value)).canExecute()) continue;
                compoundCmd.add((Command)cmd);
            }
            if (UserPropertiesSection.this.isMultiSelection()) {
                try {
                    UserPropertiesSection.this.ignoreMessages = true;
                    UserPropertiesSection.this.executeCommand(compoundCmd.unwrap());
                    ((IProperty)element).setValue((String)value);
                    UserPropertiesSection.this.fTableViewer.update(element, null);
                }
                finally {
                    UserPropertiesSection.this.ignoreMessages = false;
                }
            } else {
                UserPropertiesSection.this.executeCommand(compoundCmd.unwrap());
            }
        }
    }
}

