/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.tools;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.tools.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GenerateViewDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.GenerateViewDialog";
    private static String DIALOG_ID = "GenerateViewDialog";
    private static final String PREFS_ALLCONNECTIONS = "GenerateView_AllConnections";
    private static final String PREFS_LASTVIEWPOINT = "GenerateView_LastViewpoint";
    private List<IArchimateElement> fSelectedElements;
    private ComboViewer fComboViewer;
    private Button fAddAllConnectionsButton;
    private Text fNameText;
    private IViewpoint fSelectedViewpoint;
    private List<IViewpoint> fValidViewPoints = new ArrayList<IViewpoint>();
    private String fViewName;
    private boolean fAddAllConnections;

    public GenerateViewDialog(Shell parentShell, List<IArchimateElement> selectedElements) {
        super(parentShell, DIALOG_ID);
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSelectedElements = selectedElements;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.GenerateViewDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.GenerateViewDialog_1);
        Object message = "";
        Iterator<IArchimateElement> iter = this.fSelectedElements.iterator();
        while (iter.hasNext()) {
            message = (String)message + ArchiLabelProvider.INSTANCE.getLabel(iter.next());
            message = iter.hasNext() ? (String)message + ", " : (String)message + ".";
        }
        this.setMessage((String)message);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 20;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Label label = new Label(client, 0);
        label.setText(Messages.GenerateViewDialog_3);
        this.fComboViewer = new ComboViewer(new Combo(client, 2056));
        this.fComboViewer.getCombo().setVisibleItemCount(12);
        this.fComboViewer.getControl().setLayoutData((Object)new GridData(768));
        for (IViewpoint viewpoint : ViewpointManager.INSTANCE.getAllViewpoints()) {
            boolean allowed = true;
            for (IArchimateElement element : this.fSelectedElements) {
                if (viewpoint.isAllowedConcept(element.eClass())) continue;
                allowed = false;
                break;
            }
            if (!allowed || this.fValidViewPoints.contains(viewpoint)) continue;
            this.fValidViewPoints.add(viewpoint);
        }
        this.fComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return GenerateViewDialog.this.fValidViewPoints.toArray();
            }
        });
        this.fComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IViewpoint)element).getName();
            }
        });
        this.fComboViewer.setInput((Object)"");
        label = new Label(client, 0);
        label.setText(Messages.GenerateViewDialog_2);
        this.fNameText = UIUtils.createSingleTextControl(client, 2048, true);
        this.fNameText.setLayoutData((Object)new GridData(768));
        this.fNameText.setText(Messages.GenerateViewDialog_6 + " " + ArchiLabelProvider.INSTANCE.getLabel(this.fSelectedElements.get(0)));
        Group groupOptions = new Group(client, 0);
        groupOptions.setText(Messages.GenerateViewDialog_4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        groupOptions.setLayoutData((Object)gd);
        groupOptions.setLayout((Layout)new GridLayout(2, false));
        label = new Label((Composite)groupOptions, 0);
        label.setText(Messages.GenerateViewDialog_5);
        this.fAddAllConnectionsButton = new Button((Composite)groupOptions, 32);
        this.loadPreferences();
        return composite;
    }

    protected void okPressed() {
        this.fSelectedViewpoint = (IViewpoint)((IStructuredSelection)this.fComboViewer.getSelection()).getFirstElement();
        this.fAddAllConnections = this.fAddAllConnectionsButton.getSelection();
        this.fViewName = this.fNameText.getText();
        this.savePreferences();
        super.okPressed();
    }

    IViewpoint getSelectedViewpoint() {
        return this.fSelectedViewpoint;
    }

    boolean isAddAllConnections() {
        return this.fAddAllConnections;
    }

    String getViewName() {
        return this.fViewName;
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(500, 350);
    }

    void savePreferences() {
        IPreferenceStore store = ArchiPlugin.getInstance().getPreferenceStore();
        store.setValue(PREFS_ALLCONNECTIONS, this.fAddAllConnections);
        store.setValue(PREFS_LASTVIEWPOINT, this.fSelectedViewpoint.getID());
    }

    void loadPreferences() {
        IPreferenceStore store = ArchiPlugin.getInstance().getPreferenceStore();
        this.fAddAllConnectionsButton.setSelection(store.getBoolean(PREFS_ALLCONNECTIONS));
        String id = store.getString(PREFS_LASTVIEWPOINT);
        IViewpoint lastViewpoint = ViewpointManager.INSTANCE.getViewpoint(id);
        if (!this.fValidViewPoints.contains(lastViewpoint)) {
            lastViewpoint = ViewpointManager.NONE_VIEWPOINT;
        }
        this.fComboViewer.setSelection((ISelection)new StructuredSelection((Object)lastViewpoint));
    }
}

