/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.ui.IGraphicsIcon;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.ui.Messages;
import com.archimatetool.editor.ui.factory.IDiagramModelUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.INameable;
import com.archimatetool.model.IProfile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ArchiLabelProvider {
    public static ArchiLabelProvider INSTANCE = new ArchiLabelProvider();

    private ArchiLabelProvider() {
    }

    public String getLabel(Object object) {
        if (object == null) {
            return "";
        }
        object = this.getAdaptableObject(object);
        String name = null;
        if (object instanceof INameable) {
            INameable nameable = (INameable)object;
            name = nameable.getName();
        }
        if (!StringUtils.isSet(name) && object instanceof EObject) {
            EObject eObject = (EObject)object;
            name = this.getDefaultName(eObject.eClass());
        }
        return StringUtils.safeString(name);
    }

    public String getLabelNormalised(Object object) {
        return StringUtils.normaliseNewLineCharacters(this.getLabel(object));
    }

    public String getDefaultName(EClass eClass) {
        if (eClass == null) {
            return "";
        }
        IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProviderForClass(eClass);
        if (provider != null) {
            return provider.getDefaultName();
        }
        return "";
    }

    public Image getImage(Object object) {
        EObject eObject;
        IObjectUIProvider provider;
        if (object == null) {
            return null;
        }
        if ((object = this.getAdaptableObject(object)) instanceof EClass) {
            EClass eClass = (EClass)object;
            IObjectUIProvider provider2 = ObjectUIFactory.INSTANCE.getProviderForClass(eClass);
            if (provider2 != null) {
                return provider2.getImage();
            }
        } else if (object instanceof EObject && (provider = ObjectUIFactory.INSTANCE.getProvider(eObject = (EObject)object)) != null) {
            return provider.getImage();
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(EClass eClass) {
        if (eClass == null) {
            return null;
        }
        IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProviderForClass(eClass);
        if (provider != null) {
            return provider.getImageDescriptor();
        }
        return null;
    }

    public ImageDescriptor getImageDescriptorForSpecialization(final IProfile profile) {
        return new ImageDescriptor(){

            public ImageData getImageData(int zoom) {
                Image image = null;
                try {
                    IArchiveManager archiveManager = (IArchiveManager)profile.getAdapter(IArchiveManager.class);
                    if (archiveManager != null) {
                        image = archiveManager.createImage(profile.getImagePath());
                    }
                    if (image == null) {
                        return ArchiLabelProvider.this.getImageDescriptor(profile.getConceptClass()).getImageData(zoom);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return ArchiLabelProvider.this.getImageDescriptor(profile.getConceptClass()).getImageData(zoom);
                }
                Rectangle imageBounds = image.getBounds();
                Image iconImage = new Image((Device)Display.getDefault(), 16, 16);
                GC gc = new GC((Drawable)iconImage);
                gc.setAntialias(1);
                gc.setInterpolation(2);
                RGB background = new RGB(255, 255, 254);
                gc.setBackground(new Color(background));
                gc.fillRectangle(0, 0, 16, 16);
                Rectangle scaledSize = ImageFactory.getScaledImageSize(image, 16);
                int x = (16 - scaledSize.width) / 2;
                int y = (16 - scaledSize.height) / 2;
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, x, y, scaledSize.width, scaledSize.height);
                ImageData data = iconImage.getImageData(zoom);
                data.transparentPixel = data.palette.getPixel(background);
                gc.dispose();
                image.dispose();
                iconImage.dispose();
                return data;
            }
        };
    }

    public IGraphicsIcon getGraphicsIconForDiagramModel(IDiagramModel dm) {
        IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)dm);
        if (provider instanceof IDiagramModelUIProvider) {
            IDiagramModelUIProvider dmProvider = (IDiagramModelUIProvider)provider;
            return dmProvider.getGraphicsIcon();
        }
        return null;
    }

    public Object getWrappedElement(Object object) {
        return this.getAdaptableObject(object);
    }

    public Object getAdaptableObject(Object object) {
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            object = adaptable.getAdapter(IArchimateModelObject.class);
        }
        if (object instanceof IDiagramModelArchimateComponent) {
            IDiagramModelArchimateComponent dmac = (IDiagramModelArchimateComponent)object;
            return dmac.getArchimateConcept();
        }
        return object;
    }

    public String getRelationshipSentence(IArchimateRelationship relation) {
        if (relation != null && relation.getSource() != null && relation.getTarget() != null) {
            return this.getRelationshipSentence(relation.eClass(), relation.getSource(), relation.getTarget());
        }
        return "";
    }

    public String getRelationshipSentence(EClass relationshipType, IArchimateConcept source, IArchimateConcept target) {
        String nameSource = this.getLabel(source);
        String nameTarget = this.getLabel(target);
        if (source instanceof IJunction || target instanceof IJunction) {
            return NLS.bind((String)Messages.ArchiLabelProvider_0, (Object)nameSource, (Object)nameTarget);
        }
        switch (relationshipType.getClassifierID()) {
            case 108: {
                return NLS.bind((String)Messages.ArchiLabelProvider_3, (Object)nameSource, (Object)nameTarget);
            }
            case 103: {
                return NLS.bind((String)Messages.ArchiLabelProvider_4, (Object)nameSource, (Object)nameTarget);
            }
            case 100: {
                return NLS.bind((String)Messages.ArchiLabelProvider_5, (Object)nameSource, (Object)nameTarget);
            }
            case 109: {
                return NLS.bind((String)Messages.ArchiLabelProvider_6, (Object)nameSource, (Object)nameTarget);
            }
            case 104: {
                return NLS.bind((String)Messages.ArchiLabelProvider_7, (Object)nameSource, (Object)nameTarget);
            }
            case 99: {
                return NLS.bind((String)Messages.ArchiLabelProvider_8, (Object)nameSource, (Object)nameTarget);
            }
            case 102: {
                return NLS.bind((String)Messages.ArchiLabelProvider_9, (Object)nameSource, (Object)nameTarget);
            }
            case 101: {
                return NLS.bind((String)Messages.ArchiLabelProvider_10, (Object)nameSource, (Object)nameTarget);
            }
            case 106: {
                return NLS.bind((String)Messages.ArchiLabelProvider_11, (Object)nameSource, (Object)nameTarget);
            }
            case 107: {
                return NLS.bind((String)Messages.ArchiLabelProvider_12, (Object)nameSource, (Object)nameTarget);
            }
            case 105: {
                return NLS.bind((String)Messages.ArchiLabelProvider_13, (Object)nameSource, (Object)nameTarget);
            }
        }
        return "";
    }

    public String getRelationshipPhrase(EClass eClass, boolean reverseDirection) {
        if (eClass == null) {
            return "";
        }
        switch (eClass.getClassifierID()) {
            case 108: {
                return reverseDirection ? Messages.ArchiLabelProvider_14 : Messages.ArchiLabelProvider_15;
            }
            case 103: {
                return reverseDirection ? Messages.ArchiLabelProvider_16 : Messages.ArchiLabelProvider_17;
            }
            case 100: {
                return reverseDirection ? Messages.ArchiLabelProvider_18 : Messages.ArchiLabelProvider_19;
            }
            case 109: {
                return reverseDirection ? Messages.ArchiLabelProvider_20 : Messages.ArchiLabelProvider_21;
            }
            case 104: {
                return reverseDirection ? Messages.ArchiLabelProvider_22 : Messages.ArchiLabelProvider_23;
            }
            case 99: {
                return reverseDirection ? Messages.ArchiLabelProvider_24 : Messages.ArchiLabelProvider_25;
            }
            case 102: {
                return reverseDirection ? Messages.ArchiLabelProvider_26 : Messages.ArchiLabelProvider_27;
            }
            case 101: {
                return reverseDirection ? Messages.ArchiLabelProvider_28 : Messages.ArchiLabelProvider_29;
            }
            case 106: {
                return reverseDirection ? Messages.ArchiLabelProvider_30 : Messages.ArchiLabelProvider_31;
            }
            case 107: {
                return reverseDirection ? Messages.ArchiLabelProvider_32 : Messages.ArchiLabelProvider_33;
            }
            case 105: {
                return reverseDirection ? Messages.ArchiLabelProvider_34 : Messages.ArchiLabelProvider_35;
            }
        }
        return "";
    }
}

