/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILineObject;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorFactory {
    private static ColorRegistry ColorRegistry = new ColorRegistry(Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault());

    public static Color get(int red, int green, int blue) {
        return ColorFactory.get(new RGB(red, green, blue));
    }

    public static Color get(RGB rgb) {
        String rgbValue = ColorFactory.convertRGBToString(rgb);
        return ColorFactory.get(rgbValue);
    }

    public static Color get(String rgbValue) {
        RGB rgb;
        if (rgbValue == null) {
            return null;
        }
        if (!ColorRegistry.hasValueFor(rgbValue) && (rgb = ColorFactory.convertStringToRGB(rgbValue)) != null) {
            ColorRegistry.put(rgbValue, rgb);
        }
        return ColorRegistry.get(rgbValue);
    }

    public static void setDefaultColors(IDiagramModelComponent component) {
        if (component instanceof IDiagramModelObject) {
            IDiagramModelObject dmo = (IDiagramModelObject)component;
            dmo.setDeriveElementLineColor(ArchiPlugin.getInstance().getPreferenceStore().getBoolean("deriveElementLineColor"));
        }
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("saveUserDefaultFillColorInFile")) {
            ILineObject lo;
            Color lineColor;
            IDiagramModelObject dmo;
            Color fillColor;
            if (component instanceof IDiagramModelObject && (fillColor = ColorFactory.getDefaultFillColor(dmo = (IDiagramModelObject)component)) != null) {
                dmo.setFillColor(ColorFactory.convertColorToString(fillColor));
            }
            if (component instanceof ILineObject && (lineColor = ColorFactory.getDefaultLineColor(lo = (ILineObject)component)) != null) {
                lo.setLineColor(ColorFactory.convertColorToString(lineColor));
            }
        }
    }

    public static Color getDefaultFillColor(Object object) {
        Color color = ColorFactory.getUserDefaultFillColor(object);
        if (color == null) {
            color = ColorFactory.getInbuiltDefaultFillColor(object);
        }
        return color;
    }

    public static Color getUserDefaultFillColor(Object object) {
        String value;
        EClass eClass = ColorFactory.getEClassForObject(object);
        if (eClass != null && StringUtils.isSet(value = ArchiPlugin.getInstance().getPreferenceStore().getString("defaultFillColour_" + eClass.getName()))) {
            return ColorFactory.get(value);
        }
        return null;
    }

    public static Color getInbuiltDefaultFillColor(Object object) {
        EClass eClass = ColorFactory.getEClassForObject(object);
        if (eClass != null) {
            Color c;
            String defaultValue = ArchiPlugin.getInstance().getPreferenceStore().getDefaultString("defaultFillColour_" + eClass.getName());
            if (StringUtils.isSet(defaultValue) && (c = ColorFactory.get(defaultValue)) != null) {
                return c;
            }
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProviderForClass(eClass);
            if (provider instanceof IGraphicalObjectUIProvider) {
                Color color = ((IGraphicalObjectUIProvider)provider).getDefaultColor();
                return color != null ? color : ColorConstants.white;
            }
        }
        return ColorConstants.white;
    }

    public static Color getDefaultLineColor(Object object) {
        Color color = ColorFactory.getUserDefaultLineColor(object);
        if (color == null) {
            color = ColorFactory.getInbuiltDefaultLineColor(object);
        }
        return color;
    }

    public static Color getUserDefaultLineColor(Object object) {
        EClass eClass = ColorFactory.getEClassForObject(object);
        if (IArchimatePackage.eINSTANCE.getDiagramModelConnection().isSuperTypeOf(eClass) || IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass)) {
            String value = ArchiPlugin.getInstance().getPreferenceStore().getString("defaultConnectionLineColor");
            if (StringUtils.isSet(value)) {
                return ColorFactory.get(value);
            }
        } else {
            String value = ArchiPlugin.getInstance().getPreferenceStore().getString("defaultElementLineColor");
            if (StringUtils.isSet(value)) {
                return ColorFactory.get(value);
            }
        }
        return null;
    }

    public static Color getInbuiltDefaultLineColor(Object object) {
        EClass eClass = ColorFactory.getEClassForObject(object);
        if (eClass != null) {
            Color c;
            String defaultValue = null;
            defaultValue = IArchimatePackage.eINSTANCE.getDiagramModelConnection().isSuperTypeOf(eClass) || IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass) ? ArchiPlugin.getInstance().getPreferenceStore().getDefaultString("defaultConnectionLineColor") : ArchiPlugin.getInstance().getPreferenceStore().getDefaultString("defaultElementLineColor");
            if (StringUtils.isSet(defaultValue) && (c = ColorFactory.get(defaultValue)) != null) {
                return c;
            }
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProviderForClass(eClass);
            if (provider instanceof IGraphicalObjectUIProvider) {
                Color color = ((IGraphicalObjectUIProvider)provider).getDefaultLineColor();
                return color != null ? color : ColorConstants.black;
            }
        }
        return ColorConstants.black;
    }

    private static EClass getEClassForObject(Object object) {
        EClass eClass = null;
        if (object instanceof EClass) {
            eClass = (EClass)object;
        } else if (object instanceof IDiagramModelArchimateComponent) {
            eClass = ((IDiagramModelArchimateComponent)object).getArchimateConcept().eClass();
        } else if (object instanceof EObject) {
            eClass = ((EObject)object).eClass();
        }
        return eClass;
    }

    public static int getPixelValue(RGB rgb) {
        return rgb.red << 16 | rgb.green << 8 | rgb.blue;
    }

    public static String convertColorToString(Color color) {
        if (color == null) {
            return "";
        }
        return ColorFactory.convertRGBToString(color.getRGB());
    }

    public static String convertRGBToString(RGB rgb) {
        if (rgb == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("#");
        String s = Integer.toHexString(rgb.red);
        if (s.length() == 1) {
            sb.append("0");
        }
        sb.append(s);
        s = Integer.toHexString(rgb.green);
        if (s.length() == 1) {
            sb.append("0");
        }
        sb.append(s);
        s = Integer.toHexString(rgb.blue);
        if (s.length() == 1) {
            sb.append("0");
        }
        sb.append(s);
        return sb.toString();
    }

    public static RGB convertStringToRGB(String string) {
        if (string == null || string.length() != 7 || !string.startsWith("#")) {
            return null;
        }
        try {
            int red = Integer.parseInt(string.substring(1, 3), 16);
            int green = Integer.parseInt(string.substring(3, 5), 16);
            int blue = Integer.parseInt(string.substring(5, 7), 16);
            return new RGB(red, green, blue);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Color getDarkerColor(Color color) {
        return ColorFactory.getDarkerColor(color, 0.9f);
    }

    public static Color getDarkerColor(Color color, float factor) {
        if (color == null) {
            return null;
        }
        if (factor > 1.0f || factor < 0.0f) {
            factor = 1.0f;
        }
        RGB rgb = new RGB((int)((float)color.getRed() * factor), (int)((float)color.getGreen() * factor), (int)((float)color.getBlue() * factor));
        return ColorFactory.get(ColorFactory.convertRGBToString(rgb));
    }

    public static Color getLighterColor(Color color) {
        return ColorFactory.getLighterColor(color, 0.9f);
    }

    public static Color getLighterColor(Color color, float factor) {
        if (color == null) {
            return null;
        }
        RGB rgb = new RGB(Math.max(2, Math.min((int)((float)color.getRed() / factor), 255)), Math.max(2, Math.min((int)((float)color.getGreen() / factor), 255)), Math.max(2, Math.min((int)((float)color.getBlue() / factor), 255)));
        return ColorFactory.get(ColorFactory.convertRGBToString(rgb));
    }

    public static Color getDerivedLineColor(Color color) {
        if (color == null) {
            return null;
        }
        float contrastFactor = 0.7f;
        RGB rgb = new RGB((int)((float)color.getRed() * contrastFactor), (int)((float)color.getGreen() * contrastFactor), (int)((float)color.getBlue() * contrastFactor));
        return ColorFactory.get(ColorFactory.convertRGBToString(rgb));
    }
}

