/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.diagram.figures.IDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.factory.IArchimateElementUIProvider;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateObject;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class FigureImagePreviewFactory {
    static ImageRegistry imageRegistry = new ImageRegistry(Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault());

    /*
     * WARNING - void declaration
     */
    public static Image getPreviewImage(EClass eClass, int type) {
        void uiProvider;
        if (type < 0 || type > 1) {
            return null;
        }
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProviderForClass(eClass);
        if (!(provider instanceof IArchimateElementUIProvider)) {
            return null;
        }
        IArchimateElementUIProvider iArchimateElementUIProvider = (IArchimateElementUIProvider)provider;
        if (type > 0 && !uiProvider.hasAlternateFigure()) {
            return null;
        }
        String key = eClass.getName() + type;
        Image image = imageRegistry.get(key);
        if (image == null) {
            IDiagramModelArchimateObject dmo = IArchimateFactory.eINSTANCE.createDiagramModelArchimateObject();
            dmo.setArchimateElement((IArchimateElement)IArchimateFactory.eINSTANCE.create(eClass));
            dmo.setName(provider.getDefaultName());
            dmo.setType(type);
            dmo.setDeriveElementLineColor(false);
            if (eClass == IArchimatePackage.eINSTANCE.getGrouping()) {
                dmo.setTextAlignment(1);
            }
            dmo.setFillColor(ColorFactory.convertColorToString(ColorFactory.getInbuiltDefaultFillColor(dmo)));
            dmo.setLineColor(ColorFactory.convertColorToString(ColorFactory.getInbuiltDefaultLineColor(dmo)));
            GraphicalEditPart editPart = (GraphicalEditPart)provider.createEditPart();
            editPart.setModel((Object)dmo);
            IDiagramModelObjectFigure figure = (IDiagramModelObjectFigure)editPart.getFigure();
            figure.setSize(new Dimension(120, 55));
            figure.refreshVisuals();
            figure.validate();
            image = new Image((Device)Display.getDefault(), zoom -> {
                Image tmp = DiagramUtils.createImage(figure, 1.0, 0);
                ImageData imageData = tmp.getImageData(zoom);
                tmp.dispose();
                return imageData;
            });
            imageRegistry.put(key, image);
        }
        return image;
    }
}

