/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.CompositeMultiImageDescriptor;
import com.archimatetool.editor.utils.PlatformUtils;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageFactory {
    private AbstractUIPlugin fPlugin;

    public static int getDeviceZoom() {
        Display.getDefault();
        return DPIUtil.getDeviceZoom();
    }

    public static int getImageDeviceZoom() {
        boolean scaleImages = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("scaleImageExport");
        int deviceZoom = ImageFactory.getDeviceZoom();
        return scaleImages ? (deviceZoom == 100 ? 200 : deviceZoom) : 100;
    }

    public static int getCursorDeviceZoom() {
        return PlatformUtils.isWindows() ? ImageFactory.getDeviceZoom() : 100;
    }

    public ImageFactory(AbstractUIPlugin plugin) {
        this.fPlugin = plugin;
    }

    public AbstractUIPlugin getPlugin() {
        return this.fPlugin;
    }

    public Image getImage(String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException("Image name cannot be null");
        }
        ImageRegistry registry = this.fPlugin.getImageRegistry();
        Image image = registry.get(imageName);
        if (image == null) {
            this.getImageDescriptor(imageName);
            image = registry.get(imageName);
        }
        return image;
    }

    public Image getOverlayImage(Image underlay, String overlayName, int quadrant) {
        ImageDescriptor overlayDescripter;
        String key = underlay.hashCode() + overlayName + quadrant;
        Image newImage = this.getImage(key);
        if (newImage == null && (overlayDescripter = this.getImageDescriptor(overlayName)) != null && (newImage = new DecorationOverlayIcon(underlay, overlayDescripter, quadrant).createImage()) != null) {
            ImageRegistry registry = this.fPlugin.getImageRegistry();
            registry.put(key, newImage);
        }
        return newImage != null ? newImage : underlay;
    }

    public Image getCompositeImage(String[] imageNames) {
        Object key_name = "@";
        String[] stringArray = imageNames;
        int n = imageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            key_name = (String)key_name + name;
            ++n2;
        }
        ImageRegistry registry = this.fPlugin.getImageRegistry();
        Image image = registry.get((String)key_name);
        if (image == null) {
            this.getCompositeImageDescriptor(imageNames);
            image = registry.get((String)key_name);
        }
        return image;
    }

    public Image getImageWithRGB(String imageName, RGB rgb) {
        String rgbName = imageName + ColorFactory.convertRGBToString(rgb);
        ImageRegistry registry = this.fPlugin.getImageRegistry();
        Image image = registry.get(rgbName);
        if (image == null) {
            this.getImageDescriptorWithRGB(imageName, rgb);
            image = registry.get(rgbName);
        }
        return image;
    }

    public CompositeImageDescriptor getCompositeImageDescriptor(String[] imageNames) {
        Object key_name = "@";
        String[] stringArray = imageNames;
        int n = imageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            key_name = (String)key_name + name;
            ++n2;
        }
        ImageRegistry registry = this.fPlugin.getImageRegistry();
        CompositeImageDescriptor cid = (CompositeImageDescriptor)registry.getDescriptor((String)key_name);
        if (cid == null) {
            ImageDescriptor[] desc = new ImageDescriptor[imageNames.length];
            int i = 0;
            while (i < imageNames.length) {
                desc[i] = this.getImageDescriptor(imageNames[i]);
                ++i;
            }
            cid = new CompositeMultiImageDescriptor(desc);
            registry.put((String)key_name, (ImageDescriptor)cid);
        }
        return cid;
    }

    public ImageDescriptor getImageDescriptor(String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException("Image name cannot be null");
        }
        ImageRegistry registry = this.fPlugin.getImageRegistry();
        ImageDescriptor id = registry.getDescriptor(imageName);
        if (id == null && (id = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)this.fPlugin.getBundle().getSymbolicName(), (String)imageName).orElse(null)) != null) {
            registry.put(imageName, id);
        }
        return id;
    }

    public ImageDescriptor getImageDescriptorWithRGB(final String imageName, final RGB rgb) {
        ImageDescriptor id;
        String rgbName = imageName + ColorFactory.convertRGBToString(rgb);
        ImageRegistry registry = this.fPlugin.getImageRegistry();
        ImageDescriptor newImageDescriptor = registry.getDescriptor(rgbName);
        if (newImageDescriptor == null && (id = this.getImageDescriptor(imageName)) != null) {
            newImageDescriptor = new ImageDescriptor(){

                public ImageData getImageData(int zoom) {
                    ImageData imageData = ImageFactory.this.getImageDescriptor(imageName).getImageData(zoom);
                    if (imageData != null) {
                        int pixel = imageData.palette.getPixel(rgb);
                        int x = 0;
                        while (x < imageData.width) {
                            int y = 0;
                            while (y < imageData.height) {
                                imageData.setPixel(x, y, pixel);
                                ++y;
                            }
                            ++x;
                        }
                    }
                    return imageData;
                }
            };
            registry.put(rgbName, newImageDescriptor);
        }
        return newImageDescriptor;
    }

    public static Image getSharedImage(String name) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(name);
    }

    public static ImageDescriptor getSharedImageDescriptor(String name) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(name);
    }

    public static Image getScaledImage(Image source, int width, int height) {
        Image image;
        ImageData sourceImageData = source.getImageData(ImageFactory.getDeviceZoom());
        if (sourceImageData.transparentPixel != -1) {
            ImageData id = new ImageData(width, height, sourceImageData.depth, sourceImageData.palette);
            id.transparentPixel = sourceImageData.transparentPixel;
            image = new Image(source.getDevice(), id);
        } else {
            image = new Image(source.getDevice(), width, height);
        }
        GC gc = new GC((Drawable)image);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        Color transparentColor = source.getBackground();
        if (transparentColor != null) {
            gc.setBackground(transparentColor);
            gc.fillRectangle(0, 0, width, height);
        }
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, width, height);
        gc.dispose();
        return image;
    }

    public static Image getScaledImage(Image source, int maxSize) {
        if (maxSize < 10) {
            maxSize = 10;
        }
        Rectangle newSize = ImageFactory.getScaledImageSize(source, maxSize);
        return ImageFactory.getScaledImage(source, newSize.width, newSize.height);
    }

    public static Rectangle getScaledImageSize(Image source, int maxSize) {
        Rectangle srcBounds = source.getBounds();
        return ImageFactory.getScaledSize(srcBounds.width, srcBounds.height, maxSize);
    }

    public static Rectangle getScaledSize(int width, int height, int maxSize) {
        float w = width;
        float h = height;
        if (w > (float)maxSize) {
            w *= (float)maxSize / h;
            h = maxSize;
        }
        if (w > (float)maxSize) {
            h *= (float)maxSize / w;
            w = maxSize;
        }
        return new Rectangle(0, 0, (int)w, (int)h);
    }

    public static Image getFlippedImage(Image source) {
        Rectangle bounds = source.getBounds();
        Image newImage = new Image(source.getDevice(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)newImage);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        Transform transform = new Transform(source.getDevice());
        transform.setElements(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        transform.translate(0.0f, (float)(-bounds.height));
        gc.setTransform(transform);
        gc.drawImage(source, 0, 0, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
        gc.dispose();
        transform.dispose();
        return newImage;
    }
}

