/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.ui.ILocalClipboardListener;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LocalClipboard
extends EventManager {
    private static LocalClipboard defaultClipboard = new LocalClipboard();
    private static final ByteArrayTransfer TRANSFER = new ByteArrayTransfer(){
        private final String TYPE_NAME = "com.archimatetool.editor.clipboard.transfer" + System.currentTimeMillis();
        private final int TYPE_ID = 1.registerType((String)this.TYPE_NAME);
        private Object object;

        protected int[] getTypeIds() {
            return new int[]{this.TYPE_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{this.TYPE_NAME};
        }

        public void javaToNative(Object object, TransferData transferData) {
            this.object = object;
            super.javaToNative((Object)this.TYPE_NAME.getBytes(), transferData);
        }

        public Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null) {
                try {
                    return this.TYPE_NAME.equals(new String(bytes)) ? this.object : null;
                }
                catch (Exception exception) {}
            }
            return null;
        }
    };
    private Clipboard clipBoard = new Clipboard(null);

    public static LocalClipboard getDefault() {
        return defaultClipboard;
    }

    private LocalClipboard() {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                public final void windowActivated(IWorkbenchWindow window) {
                    LocalClipboard.this.fireClipboardChanged(LocalClipboard.this.getContents());
                }

                public final void windowClosed(IWorkbenchWindow window) {
                }

                public final void windowDeactivated(IWorkbenchWindow window) {
                }

                public final void windowOpened(IWorkbenchWindow window) {
                }
            });
        }
    }

    public Object getContents() {
        return this.clipBoard.getContents((Transfer)TRANSFER);
    }

    public void setContents(Object contents) {
        this.clipBoard.setContents(new Object[]{contents}, new Transfer[]{TRANSFER});
        this.fireClipboardChanged(contents);
    }

    public void addListener(ILocalClipboardListener l) {
        this.addListenerObject(l);
    }

    public void removeListener(ILocalClipboardListener l) {
        this.removeListenerObject(l);
    }

    private void fireClipboardChanged(final Object contents) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final ILocalClipboardListener l = (ILocalClipboardListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.clipBoardChanged(contents);
                }
            });
            ++n2;
        }
    }
}

