/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.utils.StringUtils;
import java.util.Objects;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public final class ThemeUtils {
    public static final String E4_DEFAULT_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_default";
    public static final String E4_DARK_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_dark";
    public static final String HIGH_CONTRAST_THEME_ID = "org.eclipse.e4.ui.css.theme.high-contrast";
    public static final String USE_ROUND_TABS = "USE_ROUND_TABS";
    public static final String THEME_ENABLED = "themeEnabled";
    public static final String THEMEID_KEY = "themeid";
    private static IThemeEngine engine;

    public static IThemeEngine getThemeEngine() {
        if (engine == null && PlatformUI.isWorkbenchRunning()) {
            engine = (IThemeEngine)PlatformUI.getWorkbench().getService(IThemeEngine.class);
        }
        return engine;
    }

    public static boolean isCssThemingEnabled() {
        return ThemeUtils.getThemeEngine() != null;
    }

    public static void resetCurrentTheme() {
        IThemeEngine iThemeEngine = ThemeUtils.getThemeEngine();
        if (iThemeEngine instanceof ThemeEngine) {
            ThemeEngine themeEngine = (ThemeEngine)iThemeEngine;
            themeEngine.resetCurrentTheme();
        }
    }

    public static IThemeRegistry getThemeRegistry() {
        return WorkbenchPlugin.getDefault().getThemeRegistry();
    }

    public static IThemeManager getThemeManager() {
        return PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getThemeManager() : null;
    }

    public static void registerCssClassName(Control control, String className) {
        control.setData("org.eclipse.e4.ui.css.CssClassName", (Object)className);
    }

    public static void registerCssId(Control control, String id) {
        control.setData("org.eclipse.e4.ui.css.id", (Object)id);
    }

    public static void applyStyles(Control control, boolean applyStylesToChildNodes) {
        if (ThemeUtils.getThemeEngine() != null) {
            ThemeUtils.getThemeEngine().applyStyles((Object)control, applyStylesToChildNodes);
        }
    }

    public static IEclipsePreferences getThemePreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
    }

    public static IEclipsePreferences getSwtRendererPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.workbench.renderers.swt");
    }

    public static String getDefaultThemeName() {
        String themeName;
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        Object object = context.get("cssTheme");
        return object instanceof String ? (themeName = (String)object) : E4_DEFAULT_THEME_ID;
    }

    public static boolean isDarkTheme() {
        return ThemeUtils.getThemeEngine() != null && ThemeUtils.getThemeEngine().getActiveTheme() != null && ThemeUtils.getThemeEngine().getActiveTheme().getId().contains("dark");
    }

    public static void setCurrentThemeColor(String colorDefinitionId, RGB newValue) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (Objects.equals(newValue, ThemeUtils.getCurrentThemeColor(colorDefinitionId))) {
            return;
        }
        ColorDefinition colorDef = ThemeUtils.getThemeRegistry().findColor(colorDefinitionId);
        if (colorDef == null) {
            return;
        }
        String preferenceKey = ThemeUtils.createPreferenceKey((ThemeElementDefinition)colorDef);
        if (Objects.equals(newValue, ThemeUtils.getDefaultThemeColor(colorDefinitionId))) {
            PrefUtil.getInternalPreferenceStore().setToDefault(preferenceKey);
        } else {
            PrefUtil.getInternalPreferenceStore().setValue(preferenceKey, StringConverter.asString((RGB)newValue));
        }
    }

    public static RGB getCurrentThemeColor(String colorDefinitionId) {
        return ThemeUtils.getThemeManager() != null ? ThemeUtils.getThemeManager().getCurrentTheme().getColorRegistry().getRGB(colorDefinitionId) : null;
    }

    public static RGB getDefaultThemeColor(String colorDefinitionId) {
        ColorDefinition colorDef = ThemeUtils.getThemeRegistry().findColor(colorDefinitionId);
        if (colorDef == null) {
            return null;
        }
        String preferenceKey = ThemeUtils.createPreferenceKey((ThemeElementDefinition)colorDef);
        String setting = PrefUtil.getInternalPreferenceStore().getDefaultString(preferenceKey);
        if (StringUtils.isSet(setting)) {
            return StringConverter.asRGB((String)setting, (RGB)colorDef.getValue());
        }
        return colorDef.getValue();
    }

    public static String getColorDefinitionName(String colorDefinitionId) {
        ColorDefinition colorDef = ThemeUtils.getThemeRegistry().findColor(colorDefinitionId);
        return colorDef != null ? colorDef.getName() : null;
    }

    public static void setBackgroundColorIfCssThemingDisabled(Control control, String colorDefinitionId) {
        ThemeUtils.setControlPropertyIfCssThemingDisabled(control, colorDefinitionId, () -> {
            RGB rgb = ThemeUtils.getCurrentThemeColor(colorDefinitionId);
            if (rgb != null) {
                control.setBackground(new Color(rgb));
            }
        });
    }

    public static void setCurrentThemeFont(String fontDefinitionId, FontData fontData, FontData defaultFontData) {
        if (!PlatformUI.isWorkbenchRunning() || fontData == null) {
            return;
        }
        FontDefinition fontDef = ThemeUtils.getThemeRegistry().findFont(fontDefinitionId);
        if (fontDef == null) {
            return;
        }
        String preferenceKey = ThemeUtils.createPreferenceKey((ThemeElementDefinition)fontDef);
        if (Objects.equals(fontData, defaultFontData)) {
            PrefUtil.getInternalPreferenceStore().setToDefault(preferenceKey);
            PrefUtil.getInternalPreferenceStore().setToDefault("default." + preferenceKey);
        } else {
            PrefUtil.getInternalPreferenceStore().setValue(preferenceKey, fontData.toString());
            PrefUtil.getInternalPreferenceStore().setValue("default." + preferenceKey, fontData.toString());
        }
    }

    public static FontData getCurrentThemeFontData(String fontDefinitionId) {
        FontData[] fd = ThemeUtils.getCurrentThemeFontRegistry() != null ? ThemeUtils.getCurrentThemeFontRegistry().getFontData(fontDefinitionId) : null;
        return fd != null ? fd[0] : null;
    }

    public static Font getCurrentThemeFont(String fontDefinitionId) {
        return ThemeUtils.getCurrentThemeFontRegistry() != null ? ThemeUtils.getCurrentThemeFontRegistry().get(fontDefinitionId) : null;
    }

    private static FontRegistry getCurrentThemeFontRegistry() {
        return ThemeUtils.getThemeManager() != null ? ThemeUtils.getThemeManager().getCurrentTheme().getFontRegistry() : null;
    }

    public static FontData getDefaultThemeFontData(String fontDefinitionId) {
        FontDefinition fontDef = ThemeUtils.getThemeRegistry().findFont(fontDefinitionId);
        if (fontDef == null) {
            return null;
        }
        String preferenceKey = ThemeUtils.createPreferenceKey((ThemeElementDefinition)fontDef);
        String value = PrefUtil.getInternalPreferenceStore().getDefaultString("default." + preferenceKey);
        if (StringUtils.isSet(value)) {
            try {
                return new FontData(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return PreferenceConverter.getDefaultFontData((IPreferenceStore)PrefUtil.getInternalPreferenceStore(), (String)preferenceKey);
    }

    public static void setFontIfCssThemingDisabled(Control control, String fontDefinitionId) {
        ThemeUtils.setControlPropertyIfCssThemingDisabled(control, fontDefinitionId, () -> {
            Font font = ThemeUtils.getCurrentThemeFont(fontDefinitionId);
            if (font != null) {
                control.setFont(font);
            }
        });
    }

    private static void setControlPropertyIfCssThemingDisabled(Control control, String definitionId, Runnable action) {
        if (ThemeUtils.isCssThemingEnabled() || ThemeUtils.getThemeManager() == null) {
            return;
        }
        action.run();
        IPropertyChangeListener themeListener = event -> {
            if (event.getProperty() == definitionId) {
                action.run();
            }
        };
        ThemeUtils.getThemeManager().addPropertyChangeListener(themeListener);
        control.addDisposeListener(e -> ThemeUtils.getThemeManager().removePropertyChangeListener(themeListener));
    }

    private static String createPreferenceKey(ThemeElementDefinition definition) {
        if (ThemeUtils.getThemeEngine() != null && (definition.isOverridden() || definition.isAddedByCss())) {
            return ThemeElementHelper.createPreferenceKey((org.eclipse.e4.ui.css.swt.theme.ITheme)ThemeUtils.getThemeEngine().getActiveTheme(), (ITheme)ThemeUtils.getThemeManager().getCurrentTheme(), (String)definition.getId());
        }
        return ThemeElementHelper.createPreferenceKey((ITheme)ThemeUtils.getThemeManager().getCurrentTheme(), (String)definition.getId());
    }
}

