/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class UIUtils {
    static final String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";

    public static Text createSingleTextControl(Composite parent, int style, boolean filterInvalidCharacters) {
        Text text = new Text(parent, style | 4);
        UIUtils.applyNewlineFilter((Control)text);
        if (filterInvalidCharacters) {
            UIUtils.applyInvalidCharacterFilter((Control)text);
        }
        return text;
    }

    public static void conformSingleTextControl(Text textControl) {
        UIUtils.applyNewlineFilter((Control)textControl);
    }

    public static void applyNewlineFilter(Control control) {
        control.addListener(25, e -> {
            if (StringUtils.isSet(e.text)) {
                e.text = e.text.replaceAll("(\\r\\n|\\r|\\n)", "");
            }
        });
    }

    public static void applyInvalidCharacterFilter(Control control) {
        control.addListener(25, e -> {
            e.text = e.text.replaceAll(xml10pattern, "");
        });
    }

    public static void applyMacUndoBugFilter(Control control) {
        if (PlatformUtils.isMac()) {
            control.addListener(1, e -> {
                if (e.keyCode == 122 && (e.stateMask & 0x400000) != 0) {
                    e.doit = false;
                }
            });
        }
    }

    public static void applyMacCancelIconListener(final Text textControl) {
        if (PlatformUtils.isMac() && (textControl.getStyle() & 0x100) != 0) {
            textControl.addMouseListener((MouseListener)new MouseAdapter(){
                boolean mouseDownWasClickedOnCancelIcon;

                public void mouseDown(MouseEvent e) {
                    this.mouseDownWasClickedOnCancelIcon = this.isCancelIconClicked(e);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.mouseDownWasClickedOnCancelIcon && this.isCancelIconClicked(e)) {
                        textControl.setText("");
                    }
                }

                private boolean isCancelIconClicked(MouseEvent e) {
                    Rectangle bounds = textControl.getBounds();
                    return !textControl.getText().isEmpty() && e.x > bounds.width - 25 && e.x < bounds.width - 5 && e.y > 0 && e.y < bounds.height;
                }
            });
        }
    }

    public static void applyTraverseListener(Text textControl, int flags) {
        if ((textControl.getStyle() & 2) == 0) {
            return;
        }
        textControl.addTraverseListener(e -> {
            if (e.detail == 4) {
                if ((e.stateMask & SWT.MOD1) != 0) {
                    e.doit = true;
                }
            } else if ((e.detail & flags) != 0) {
                e.doit = true;
            }
        });
    }

    public static void applyNumberVerifyListener(Text textControl, int low, int high) {
        textControl.addVerifyListener(event -> {
            String currentText = ((Text)event.widget).getText();
            String newText = currentText.substring(0, event.start) + event.text + currentText.substring(event.end);
            try {
                int val = Integer.valueOf(newText);
                event.doit = val >= low && val <= high;
            }
            catch (NumberFormatException numberFormatException) {
                event.doit = newText.length() == 0;
            }
        });
    }

    public static String shortenText(String text, Control control, int margin) {
        if (text == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        int maxExtent = gc.textExtent((String)text).x;
        int maxWidth = control.getBounds().width - margin;
        if (maxExtent < maxWidth) {
            gc.dispose();
            return text;
        }
        int length = text.length();
        int charsToClip = Math.round(0.95f * (float)length * (1.0f - (float)maxWidth / (float)maxExtent));
        int pivot = length / 2;
        int start = pivot - charsToClip / 2;
        int end = pivot + charsToClip / 2 + 1;
        while (start >= 0 && end < length) {
            String s1 = text.substring(0, start);
            String s2 = text.substring(end, length);
            String s = s1 + "..." + s2;
            int l = gc.textExtent((String)s).x;
            if (l < maxWidth) {
                gc.dispose();
                return s;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return text;
    }

    public static void fixMacSiliconItemHeight(Control control) {
    }
}

